/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.krad.bo.BusinessObject;

@ConfigureContext(session=UserNameFixture.khuntley)
public class AssetLocationServiceTest
extends KualiTestBase {
    private AssetLocationService assetLocationService;
    private AssetGlobalDetail onCampusObject;
    private AssetGlobalDetail offcampusObject;
    private static final Map<AssetLocationService.LocationField, String> fieldMap = new HashMap<AssetLocationService.LocationField, String>();

    protected void setUp() throws Exception {
        super.setUp();
        this.assetLocationService = (AssetLocationService)SpringContext.getBean(AssetLocationService.class);
        this.onCampusObject = new AssetGlobalDetail();
        this.onCampusObject.setCampusCode("BL");
        this.onCampusObject.setBuildingCode("BL001");
        this.onCampusObject.setBuildingRoomNumber("B009");
        this.onCampusObject.setBuildingSubRoomNumber("23");
        this.offcampusObject = new AssetGlobalDetail();
        this.offcampusObject.setOffCampusName("eddsdsd");
        this.offcampusObject.setOffCampusAddress("Addreed");
        this.offcampusObject.setOffCampusCityName("City");
        this.offcampusObject.setOffCampusStateCode("IN");
        this.offcampusObject.setOffCampusZipCode("47401");
        this.offcampusObject.setOffCampusCountryCode("US");
    }

    public void testValidateLocation_OnCampus() throws Exception {
        AssetType assetType = new AssetType();
        assetType.setMovingIndicator(true);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.onCampusObject.setBuildingCode(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.onCampusObject.setBuildingCode("BL001");
        this.onCampusObject.setBuildingRoomNumber(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.onCampusObject.setBuildingRoomNumber("B034F");
        this.onCampusObject.setBuildingSubRoomNumber(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        assetType.setMovingIndicator(false);
        assetType.setRequiredBuildingIndicator(true);
        this.onCampusObject.setBuildingRoomNumber(null);
        this.onCampusObject.setBuildingSubRoomNumber(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.onCampusObject.setBuildingCode(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.onCampusObject.setBuildingCode("BL001");
        this.onCampusObject.setBuildingRoomNumber("YYGBJGJH");
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.onCampusObject.setBuildingRoomNumber(null);
        this.onCampusObject.setBuildingSubRoomNumber("HGBJHNGBJH");
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    public void testValidateLocation_OffCampus() throws Exception {
        AssetType assetType = new AssetType();
        assetType.setMovingIndicator(false);
        assetType.setRequiredBuildingIndicator(false);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, true, assetType);
        AssetLocationServiceTest.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.offcampusObject.setOffCampusName(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.offcampusObject.setOffCampusName("me");
        this.offcampusObject.setOffCampusAddress(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.offcampusObject.setOffCampusAddress("Street");
        this.offcampusObject.setOffCampusCityName(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.offcampusObject.setOffCampusCityName("City");
        this.offcampusObject.setOffCampusStateCode(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.offcampusObject.setOffCampusStateCode("MI");
        this.offcampusObject.setOffCampusZipCode(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.offcampusObject.setOffCampusZipCode("34343");
        this.offcampusObject.setOffCampusCountryCode(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    public void testValidateLocation_CapitalAsset() throws Exception {
        AssetType assetType = null;
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        assetType = new AssetType();
        assetType.setRequiredBuildingIndicator(true);
        assetType.setMovingIndicator(false);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        assetType.setRequiredBuildingIndicator(false);
        assetType.setMovingIndicator(false);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        assetType.setRequiredBuildingIndicator(true);
        AssetGlobalDetail blankObject = new AssetGlobalDetail();
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)blankObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.onCampusObject.setOffCampusAddress("Street");
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, true, assetType);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    public void testValidateLocation_NonCapitalAsset() throws Exception {
        AssetGlobalDetail blankObject = new AssetGlobalDetail();
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)blankObject, false, null);
        AssetLocationServiceTest.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.onCampusObject.setBuildingCode(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.onCampusObject, false, null);
        AssetLocationServiceTest.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, false, null);
        AssetLocationServiceTest.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.offcampusObject.setOffCampusCountryCode(null);
        this.assetLocationService.validateLocation(fieldMap, (BusinessObject)this.offcampusObject, false, null);
        AssetLocationServiceTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    static {
        fieldMap.put(AssetLocationService.LocationField.CAMPUS_CODE, CamsPropertyConstants.AssetGlobalDetail.CAMPUS_CODE);
        fieldMap.put(AssetLocationService.LocationField.BUILDING_CODE, CamsPropertyConstants.AssetGlobalDetail.BUILDING_CODE);
        fieldMap.put(AssetLocationService.LocationField.ROOM_NUMBER, CamsPropertyConstants.AssetGlobalDetail.BUILDING_ROOM_NUMBER);
        fieldMap.put(AssetLocationService.LocationField.SUB_ROOM_NUMBER, CamsPropertyConstants.AssetGlobalDetail.BUILDING_SUB_ROOM_NUMBER);
        fieldMap.put(AssetLocationService.LocationField.CONTACT_NAME, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_NAME);
        fieldMap.put(AssetLocationService.LocationField.STREET_ADDRESS, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_ADDRESS);
        fieldMap.put(AssetLocationService.LocationField.CITY_NAME, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_CITY_NAME);
        fieldMap.put(AssetLocationService.LocationField.STATE_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_STATE_CODE);
        fieldMap.put(AssetLocationService.LocationField.ZIP_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_ZIP_CODE);
        fieldMap.put(AssetLocationService.LocationField.COUNTRY_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_COUNTRY_CODE);
    }
}

