/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service;

import java.lang.constant.Constable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.batch.AssetPaymentInfo;
import org.kuali.kfs.module.cam.batch.service.ReportService;
import org.kuali.kfs.module.cam.batch.service.impl.AssetDepreciationServiceImpl;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationConvention;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciableAssetsDao;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciationBatchDao;
import org.kuali.kfs.module.cam.document.dataaccess.impl.DepreciationBatchDaoJdbc;
import org.kuali.kfs.module.cam.document.service.AssetDateService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.fixture.AssetDepreciationServiceFixture;
import org.kuali.kfs.sys.batch.service.SchedulerService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.identity.TestPerson;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.util.Assert;

@RunWith(value=PowerMockRunner.class)
public class AssetDepreciationServiceTest {
    private String ERROR_RECORD_NUMBER_DOESNT_MATCH = "Depreciated assets collection doesn't have the same number of elements of the results we need to compare against";
    private String ERROR_INVALID_AMOUNTS = "Depreciation figures don't match those in the properties file";
    private ConfigurationService kualiConfigurationService;
    private AssetDepreciationServiceImpl camsAssetDepreciationService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;
    private SchedulerService schedulerService;
    private OptionsService optionsService;
    private DepreciableAssetsDao depreciableAssetsDao;
    private DepreciationBatchDao depreciationBatchDao;
    private ObjectCodeService objectCodeService;
    private WorkflowDocumentService workflowDocumentService;
    private AssetService assetService;
    private AssetDateService assetDateService;
    private UniversityDateService universityDateService;
    private UserSession userSession;
    private WorkflowDocument workflowDocument;
    private ReportService reportService;
    private List<AssetPaymentInfo> savedPaymentInfo;

    @Before
    public void setUp() throws Exception {
        this.camsAssetDepreciationService = new AssetDepreciationServiceImpl();
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.kualiConfigurationService = (ConfigurationService)EasyMock.createMock(ConfigurationService.class);
        this.parameterService = (ParameterService)EasyMock.createMock(ParameterService.class);
        this.dateTimeService = (DateTimeService)EasyMock.createMock(DateTimeService.class);
        this.schedulerService = (SchedulerService)EasyMock.createMock(SchedulerService.class);
        this.optionsService = (OptionsService)EasyMock.createMock(OptionsService.class);
        this.depreciableAssetsDao = (DepreciableAssetsDao)EasyMock.createMock(DepreciableAssetsDao.class);
        this.depreciationBatchDao = (DepreciationBatchDao)EasyMock.createMock(DepreciationBatchDao.class);
        this.objectCodeService = (ObjectCodeService)EasyMock.createMock(ObjectCodeService.class);
        this.workflowDocumentService = (WorkflowDocumentService)EasyMock.createMock(WorkflowDocumentService.class);
        this.assetService = (AssetService)EasyMock.createMock(AssetService.class);
        this.userSession = (UserSession)EasyMock.createMock(UserSession.class);
        this.workflowDocument = (WorkflowDocument)EasyMock.createMock(WorkflowDocument.class);
        this.assetDateService = (AssetDateService)EasyMock.createMock(AssetDateService.class);
        this.universityDateService = (UniversityDateService)EasyMock.createMock(UniversityDateService.class);
        this.reportService = (ReportService)EasyMock.createMock(ReportService.class);
        PowerMock.mockStatic(GlobalVariables.class);
        this.savedPaymentInfo = new ArrayList<AssetPaymentInfo>();
        this.camsAssetDepreciationService.setDateTimeService(this.dateTimeService);
        this.camsAssetDepreciationService.setConfigurationService(this.kualiConfigurationService);
        this.camsAssetDepreciationService.setParameterService(this.parameterService);
        this.camsAssetDepreciationService.setSchedulerService(this.schedulerService);
        this.camsAssetDepreciationService.setOptionsService(this.optionsService);
        this.camsAssetDepreciationService.setBusinessObjectService(this.businessObjectService);
        this.camsAssetDepreciationService.setDepreciableAssetsDao(this.depreciableAssetsDao);
        this.camsAssetDepreciationService.setDepreciationBatchDao(this.depreciationBatchDao);
        this.camsAssetDepreciationService.setObjectCodeService(this.objectCodeService);
        this.camsAssetDepreciationService.setWorkflowDocumentService(this.workflowDocumentService);
        this.camsAssetDepreciationService.setAssetService(this.assetService);
        this.camsAssetDepreciationService.setAssetDateService(this.assetDateService);
        this.camsAssetDepreciationService.setUniversityDateService(this.universityDateService);
        this.camsAssetDepreciationService.setCamsReportService(this.reportService);
    }

    @Test
    @PrepareForTest(value={GlobalVariables.class})
    public void testRunDepreciation() throws Exception {
        this.recordMocks();
        this.replayMocks();
        this.camsAssetDepreciationService.runDepreciation();
        this.verifyMocks();
        List<AssetPaymentInfo> resultsMustGet = AssetDepreciationServiceFixture.DATA.getResultsFromPropertiesFile();
        Assert.isTrue((resultsMustGet.size() == this.savedPaymentInfo.size() ? 1 : 0) != 0, (String)this.ERROR_RECORD_NUMBER_DOESNT_MATCH);
        Assert.isTrue((boolean)this.isDepreciationOk(this.savedPaymentInfo, resultsMustGet), (String)this.ERROR_INVALID_AMOUNTS);
    }

    @Test
    @PrepareForTest(value={GlobalVariables.class})
    public void testInvalidFiscalMonth() throws Exception {
        this.recordInvalidFiscalMonthMocks();
        this.replayMocks();
        this.camsAssetDepreciationService.runDepreciation();
    }

    @Test
    @PrepareForTest(value={GlobalVariables.class})
    public void testMissingDepreciationDateParameter() throws Exception {
        this.recordMissingDepreciationDateParameterMocks();
        this.replayMocks();
        this.camsAssetDepreciationService.runDepreciation();
        this.verifyMocks();
    }

    private void recordMocks() throws Exception {
        java.util.Date date = new java.util.Date();
        java.util.Date depreciationDate = AssetDepreciationServiceFixture.DATA.getDepreciationDate();
        Calendar depreciationCalendar = Calendar.getInstance();
        depreciationCalendar.setTime(depreciationDate);
        List<AssetObjectCode> assetObjectCodes = AssetDepreciationServiceFixture.DATA.getAssetObjectCodes();
        EasyMock.expect((Object)this.dateTimeService.getCurrentCalendar()).andReturn((Object)Calendar.getInstance()).anyTimes();
        EasyMock.expect((Object)this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.alreadyRan")).andReturn((Object)"Already ran");
        EasyMock.expect((Object)this.dateTimeService.getCurrentDate()).andReturn((Object)date).anyTimes();
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_BEGIN")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_END")).andReturn(null);
        EasyMock.expect((Object)this.schedulerService.cronConditionMet(null)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_DATE")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_DATE")).andReturn((Object)AssetDepreciationServiceFixture.DATA.getDepreciationDateString());
        EasyMock.expect((Object)this.businessObjectService.findBySinglePrimaryKey(UniversityDate.class, (Object)new Date(depreciationDate.getTime()))).andReturn((Object)AssetDepreciationServiceFixture.DATA.getUniversityDate());
        HashMap<String, Constable> fields = new HashMap<String, Constable>();
        fields.put("universityFiscalYear", Integer.valueOf(2010));
        fields.put("active", Boolean.TRUE);
        EasyMock.expect((Object)this.businessObjectService.findMatching(AssetObjectCode.class, fields)).andReturn(assetObjectCodes);
        EasyMock.expect((Object)this.depreciableAssetsDao.generateStatistics(true, null, Integer.valueOf(2010), Integer.valueOf(1), depreciationCalendar, "", assetObjectCodes, 1, "Already ran")).andReturn(new ArrayList());
        EasyMock.expect((Object)this.depreciationBatchDao.getListOfDepreciableAssetPaymentInfo(Integer.valueOf(2010), Integer.valueOf(1), depreciationCalendar)).andReturn(AssetDepreciationServiceFixture.DATA.getAssetPaymentInfo());
        EasyMock.expect((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE")).andReturn(Arrays.asList("C1", "C2", "CF", "CM", "ES", "NA", "UC", "UF"));
        EasyMock.expect((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE")).andReturn(Arrays.asList("BD", "BF", "BI", "BR", "BX", "IF", "LE", "LF", "LI", "LR"));
        EasyMock.expect((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_PERIOD")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_PERIOD")).andReturn((Object)"1");
        EasyMock.expect((Object)this.depreciationBatchDao.getPrimaryDepreciationBaseAmountForSV()).andReturn(AssetDepreciationServiceFixture.DATA.getPrimaryDepreciationBaseAmountForSV());
        EasyMock.expect((Object)this.depreciationBatchDao.getAssetsWithNoDepreciation()).andReturn(AssetDepreciationServiceFixture.DATA.getAssetsWithNoDepreciation());
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2010), "BL", "8910")).andReturn((Object)this.getObjectCode(2010, "BL", "8910")).anyTimes();
        EasyMock.expect((Object)this.objectCodeService.getByPrimaryId(Integer.valueOf(2010), "BL", "5115")).andReturn((Object)this.getObjectCode(2010, "BL", "5115")).anyTimes();
        this.depreciationBatchDao.updateAssetPayments((List)EasyMock.isA(List.class), Integer.valueOf(EasyMock.eq((int)1)));
        EasyMock.expectLastCall().andDelegateTo((Object)new DepreciationBatchDaoJdbc(){

            public void updateAssetPayments(List<AssetPaymentInfo> assetPayments, Integer fiscalPeriod) {
                AssetDepreciationServiceTest.this.savedPaymentInfo.addAll(assetPayments);
            }
        });
        EasyMock.expect((Object)GlobalVariables.getUserSession()).andReturn((Object)this.userSession);
        EasyMock.expect((Object)this.userSession.getPerson()).andReturn((Object)this.getPerson());
        EasyMock.expect((Object)this.workflowDocumentService.createWorkflowDocument("DEPR", null)).andReturn((Object)this.workflowDocument);
        EasyMock.expect((Object)this.workflowDocument.getDocumentId()).andReturn((Object)"12345");
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)EasyMock.isA(FinancialSystemDocumentHeader.class))).andReturn(null);
        EasyMock.expect((Object)this.optionsService.getCurrentYearOptions()).andReturn((Object)AssetDepreciationServiceFixture.DATA.getSystemOptions()).times(2);
        EasyMock.expect((Object)this.dateTimeService.toDateString(depreciationDate)).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.depreciableAssetsDao.generateStatistics(false, Arrays.asList("12345"), Integer.valueOf(2010), Integer.valueOf(1), depreciationCalendar, "", assetObjectCodes, 1, "Already ran")).andReturn(new ArrayList());
        this.depreciationBatchDao.savePendingGLEntries((List)EasyMock.isA(List.class));
        EasyMock.expectLastCall();
    }

    private void recordInvalidFiscalMonthMocks() throws Exception {
        java.util.Date date = new java.util.Date();
        java.util.Date depreciationDate = AssetDepreciationServiceFixture.DATA.getDepreciationDate();
        Calendar depreciationCalendar = Calendar.getInstance();
        depreciationCalendar.setTime(depreciationDate);
        List<AssetObjectCode> assetObjectCodes = AssetDepreciationServiceFixture.DATA.getAssetObjectCodes();
        EasyMock.expect((Object)this.dateTimeService.getCurrentCalendar()).andReturn((Object)Calendar.getInstance()).anyTimes();
        EasyMock.expect((Object)this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.alreadyRan")).andReturn((Object)"Already ran");
        EasyMock.expect((Object)this.dateTimeService.getCurrentDate()).andReturn((Object)date).anyTimes();
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_BEGIN")).andReturn(null).times(2);
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_END")).andReturn(null).times(2);
        EasyMock.expect((Object)this.schedulerService.cronConditionMet(null)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_DATE")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_DATE")).andReturn((Object)AssetDepreciationServiceFixture.DATA.getDepreciationDateString());
        EasyMock.expect((Object)this.businessObjectService.findBySinglePrimaryKey(UniversityDate.class, (Object)new Date(depreciationDate.getTime()))).andReturn((Object)AssetDepreciationServiceFixture.DATA.getUniversityDate());
        HashMap<String, Constable> fields = new HashMap<String, Constable>();
        fields.put("universityFiscalYear", Integer.valueOf(2010));
        fields.put("active", Boolean.TRUE);
        EasyMock.expect((Object)this.businessObjectService.findMatching(AssetObjectCode.class, fields)).andReturn(assetObjectCodes);
        EasyMock.expect((Object)this.depreciableAssetsDao.generateStatistics(true, null, Integer.valueOf(2010), Integer.valueOf(1), depreciationCalendar, "", assetObjectCodes, 1, "Already ran")).andReturn(new ArrayList());
        EasyMock.expect((Object)this.depreciationBatchDao.getListOfDepreciableAssetPaymentInfo(Integer.valueOf(2010), Integer.valueOf(1), depreciationCalendar)).andReturn(AssetDepreciationServiceFixture.DATA.getAssetPaymentInfo());
        EasyMock.expect((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "DEPRECIATION_ORGANIZATION_PLANT_FUND_OBJECT_SUB_TYPE")).andReturn(Arrays.asList("C1", "C2", "CF", "CM", "ES", "NA", "UC", "UF"));
        EasyMock.expect((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "DEPRECIATION_CAMPUS_PLANT_FUND_OBJECT_SUB_TYPE")).andReturn(Arrays.asList("BD", "BF", "BI", "BR", "BX", "IF", "LE", "LF", "LI", "LR"));
        EasyMock.expect((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_PERIOD")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "DEPRECIATION_PERIOD")).andReturn((Object)"3");
        EasyMock.expect((Object)this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.fiscalMonthNotValid")).andReturn((Object)"Fiscal month of depreciation date must be a multiple of the depreciation period.");
        EasyMock.expect((Object)this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.calculationError")).andReturn((Object)"An error occurred when calculating assets depreciation.");
        EasyMock.expect((Object)this.optionsService.getCurrentYearOptions()).andReturn((Object)AssetDepreciationServiceFixture.DATA.getSystemOptions()).times(2);
        EasyMock.expect((Object)this.dateTimeService.toDateString(depreciationDate)).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.depreciableAssetsDao.generateStatistics(false, new ArrayList(), Integer.valueOf(2010), Integer.valueOf(1), depreciationCalendar, "", assetObjectCodes, 1, "Already ran")).andReturn(new ArrayList());
        this.reportService.generateDepreciationReport((List)EasyMock.eq(new ArrayList()), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class));
        EasyMock.expectLastCall();
    }

    private void recordMissingDepreciationDateParameterMocks() {
        Calendar depreciationCalendar = Calendar.getInstance();
        depreciationCalendar.set(11, 0);
        depreciationCalendar.set(12, 0);
        depreciationCalendar.set(13, 0);
        depreciationCalendar.set(14, 0);
        java.util.Date date = depreciationCalendar.getTime();
        EasyMock.expect((Object)this.dateTimeService.getCurrentCalendar()).andReturn((Object)Calendar.getInstance()).anyTimes();
        EasyMock.expect((Object)this.kualiConfigurationService.getPropertyValueAsString("error.batch.depreciation.alreadyRan")).andReturn((Object)"Already ran");
        EasyMock.expect((Object)this.dateTimeService.getCurrentDate()).andReturn((Object)date).anyTimes();
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_BEGIN")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getParameterValueAsString(AssetDepreciationStep.class, "BLANK_OUT_PERIOD_END")).andReturn(null);
        EasyMock.expect((Object)this.schedulerService.cronConditionMet(null)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.parameterExists(AssetDepreciationStep.class, "DEPRECIATION_DATE")).andReturn((Object)false);
        EasyMock.expect((Object)this.businessObjectService.findBySinglePrimaryKey(UniversityDate.class, (Object)new Date(date.getTime()))).andReturn(null);
        EasyMock.expect((Object)this.kualiConfigurationService.getPropertyValueAsString("error.gl.UniversityDateNotFound")).andReturn((Object)"");
        this.reportService.generateDepreciationReport((List)EasyMock.eq(new ArrayList()), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class));
        EasyMock.expectLastCall();
    }

    private void replayMocks() {
        EasyMock.replay((Object[])new Object[]{this.dateTimeService, this.kualiConfigurationService, this.parameterService, this.schedulerService, this.optionsService, this.businessObjectService});
        EasyMock.replay((Object[])new Object[]{this.depreciableAssetsDao, this.depreciationBatchDao, this.objectCodeService, this.workflowDocumentService, this.workflowDocument, this.reportService});
        PowerMock.replay((Object[])new Object[]{GlobalVariables.class});
    }

    private void verifyMocks() {
        EasyMock.verify((Object[])new Object[]{this.dateTimeService, this.kualiConfigurationService, this.parameterService, this.schedulerService, this.optionsService, this.businessObjectService});
        EasyMock.verify((Object[])new Object[]{this.depreciableAssetsDao, this.depreciationBatchDao, this.workflowDocumentService, this.reportService});
        EasyMock.reset((Object[])new Object[]{this.dateTimeService, this.kualiConfigurationService, this.parameterService, this.schedulerService, this.optionsService, this.businessObjectService});
        EasyMock.reset((Object[])new Object[]{this.depreciableAssetsDao, this.depreciationBatchDao, this.objectCodeService, this.workflowDocumentService, this.workflowDocument, this.reportService});
    }

    private ObjectCode getObjectCode(int year, String chart, String code) {
        ObjectCode result = new ObjectCode();
        result.setActive(true);
        result.setChartOfAccountsCode(chart);
        result.setUniversityFiscalYear(Integer.valueOf(year));
        result.setFinancialObjectCode(code);
        return result;
    }

    private AssetDepreciationConvention getDepreciationConvention(String code) {
        AssetDepreciationConvention result = new AssetDepreciationConvention();
        result.setDepreciationConventionCode(code);
        return result;
    }

    private Person getPerson() {
        return new TestPerson("testPrincipalId", "testPrincipalName");
    }

    public boolean isDepreciationOk(Collection<AssetPaymentInfo> savedPaymentInfo, Collection<AssetPaymentInfo> resultsMustGet) {
        Iterator<AssetPaymentInfo> resultsMustGetIterator = resultsMustGet.iterator();
        for (AssetPaymentInfo depreciatedAsset : savedPaymentInfo) {
            AssetPaymentInfo resultMustGet = resultsMustGetIterator.next();
            if (!resultMustGet.getAccumulatedPrimaryDepreciationAmount().equals((Object)depreciatedAsset.getAccumulatedPrimaryDepreciationAmount())) {
                return false;
            }
            if (!resultMustGet.getTransactionAmount().equals((Object)depreciatedAsset.getTransactionAmount())) {
                return false;
            }
            if (resultMustGet.getAccumulatedRoundingErrorInMillicents().equals(depreciatedAsset.getAccumulatedRoundingErrorInMillicents())) continue;
            return false;
        }
        return true;
    }
}

