/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service;

import java.io.File;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.kuali.kfs.kns.bo.Step;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.ExtractProcessLog;
import org.kuali.kfs.module.cam.batch.ExtractStep;
import org.kuali.kfs.module.cam.batch.service.BatchExtractReportService;
import org.kuali.kfs.module.cam.batch.service.BatchTestBase;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.ProxyUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class ExtractStepTest
extends BatchTestBase {
    private Timestamp beforeRun = null;
    private DateTimeService dateTimeService;
    private BusinessObjectService boService;
    private ExtractStep extractStep;

    @Override
    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.extractStep = (ExtractStep)ProxyUtils.getTargetIfProxied((Object)SpringContext.getBean(Step.class, (String)"cabExtractStep"));
        this.beforeRun = this.dateTimeService.getCurrentTimestamp();
        this.extractStep.setBatchExtractReportService((BatchExtractReportService)new MockBatchExtractReportService());
        this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.extractStep.setBatchExtractReportService((BatchExtractReportService)SpringContext.getBean(BatchExtractReportService.class));
    }

    public void testNothing() {
    }

    public void NORUN_testExecute() throws Exception {
        Date currentSqlDate = this.dateTimeService.getCurrentSqlDate();
        this.extractStep.execute("CabBatchExtractJob", this.dateTimeService.getCurrentDate());
        HashMap<String, Date> m = new HashMap<String, Date>();
        m.put("transactionDate", this.dateTimeService.getCurrentSqlDate());
        Collection gls = this.boService.findMatching(GeneralLedgerEntry.class, m);
        ExtractStepTest.assertEquals((int)13, (int)gls.size());
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("activityStatusCode", "N");
        Collection allCabDocs = this.boService.findMatching(PurchasingAccountsPayableDocument.class, m2);
        ExtractStepTest.assertEquals((int)7, (int)allCabDocs.size());
        HashMap<String, String> m3 = new HashMap<String, String>();
        m3.put("activityStatusCode", "N");
        Collection allCabItems = this.boService.findMatching(PurchasingAccountsPayableItemAsset.class, m3);
        for (PurchasingAccountsPayableItemAsset aci : allCabItems) {
            System.out.println(aci.isActive() + " - " + aci.getActivityStatusCode());
        }
        Collection allCabAccts = this.boService.findAll(PurchasingAccountsPayableLineAssetAccount.class);
        SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy");
        ExtractStepTest.assertEquals((String)fmt.format(currentSqlDate), (String)this.findCabExtractTimeParam().getValue().substring(0, 10));
    }

    private static class MockBatchExtractReportService
    implements BatchExtractReportService {
        private MockBatchExtractReportService() {
        }

        public File generateStatusReportPDF(ExtractProcessLog extractProcessLog) {
            TestCase.assertNotNull((Object)extractProcessLog);
            TestCase.assertTrue((boolean)extractProcessLog.isSuccess());
            TestCase.assertEquals((Object)13, (Object)extractProcessLog.getTotalGlCount());
            TestCase.assertEquals((Object)2, (Object)extractProcessLog.getNonPurApGlCount());
            TestCase.assertEquals((Object)11, (Object)extractProcessLog.getPurApGlCount());
            TestCase.assertNotNull((Object)extractProcessLog.getStartTime());
            TestCase.assertNotNull((Object)extractProcessLog.getFinishTime());
            TestCase.assertNotNull((Object)extractProcessLog.getLastExtractTime());
            TestCase.assertTrue((extractProcessLog.getIgnoredGLEntries() == null || extractProcessLog.getIgnoredGLEntries().isEmpty() ? 1 : 0) != 0);
            TestCase.assertTrue((extractProcessLog.getMismatchedGLEntries() == null || extractProcessLog.getMismatchedGLEntries().isEmpty() ? 1 : 0) != 0);
            TestCase.assertTrue((extractProcessLog.getDuplicateGLEntries() == null || extractProcessLog.getDuplicateGLEntries().isEmpty() ? 1 : 0) != 0);
            return null;
        }

        public File generateMismatchReportPDF(ExtractProcessLog extractProcessLog) {
            return null;
        }
    }
}

