/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.service.impl.AssetBarcodeInventoryLoadServiceImpl;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class AssetBarcodeInventoryLoadServiceImplTest {
    private AssetService assetService;
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private AssetBarcodeInventoryLoadServiceImpl assetBarcodeInventoryLoadService;

    @Before
    public void setUp() {
        this.assetBarcodeInventoryLoadService = new AssetBarcodeInventoryLoadServiceImpl();
        this.assetService = (AssetService)EasyMock.createMock(AssetService.class);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.dateTimeService = (DateTimeService)EasyMock.createMock(DateTimeService.class);
        this.assetBarcodeInventoryLoadService.setAssetService(this.assetService);
        this.assetBarcodeInventoryLoadService.setBusinessObjectService(this.businessObjectService);
        this.assetBarcodeInventoryLoadService.setDateTimeService(this.dateTimeService);
    }

    @Test
    public void testUpdateAssetInformationTrue() {
        BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = new BarcodeInventoryErrorDetail();
        barcodeInventoryErrorDetail.setAssetTagNumber("IU025557");
        EasyMock.expect((Object)this.assetService.findActiveAssetsMatchingTagNumber("IU025557")).andReturn(this.getAssets());
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)EasyMock.anyObject(Asset.class))).andReturn((Object)new Asset());
        EasyMock.replay((Object[])new Object[]{this.assetService, this.businessObjectService, this.dateTimeService});
        this.assetBarcodeInventoryLoadService.updateAssetInformation(barcodeInventoryErrorDetail, true);
        EasyMock.verify((Object[])new Object[]{this.assetService, this.businessObjectService, this.dateTimeService});
    }

    @Test
    public void testUpdateAssetInformationFalse() {
        BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = new BarcodeInventoryErrorDetail();
        barcodeInventoryErrorDetail.setAssetTagNumber("IU025557");
        EasyMock.expect((Object)this.assetService.findActiveAssetsMatchingTagNumber("IU025557")).andReturn(this.getAssets());
        EasyMock.expect((Object)this.businessObjectService.save((PersistableBusinessObject)EasyMock.anyObject(Asset.class))).andReturn((Object)new Asset());
        Date jud = new Date();
        java.sql.Date jsd = new java.sql.Date(jud.getTime());
        EasyMock.expect((Object)this.dateTimeService.getCurrentSqlDate()).andReturn((Object)jsd);
        EasyMock.replay((Object[])new Object[]{this.assetService, this.businessObjectService, this.dateTimeService});
        this.assetBarcodeInventoryLoadService.updateAssetInformation(barcodeInventoryErrorDetail, false);
        EasyMock.verify((Object[])new Object[]{this.assetService, this.businessObjectService, this.dateTimeService});
    }

    private List<Asset> getAssets() {
        Asset asset = new Asset();
        return Collections.singletonList(asset);
    }
}

