/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam;

import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectLevel;
import org.kuali.kfs.coa.businessobject.ObjectSubType;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MessageList;
import org.kuali.kfs.module.cam.businessobject.AssetTransactionType;
import org.kuali.kfs.module.purap.fixture.PurchasingCapitalAssetFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class PurApItemValidationTest
extends MaintenanceRuleTestBase {
    private CapitalAssetManagementModuleService camModuleService;

    protected void setUp() throws Exception {
        super.setUp();
        KNSGlobalVariables.setMessageList((MessageList)new MessageList());
        if (null == this.camModuleService) {
            this.camModuleService = (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private ObjectCode getObjectCodeWithLevel(PurchasingCapitalAssetFixture fixture, String levelCode) {
        ObjectCode objectCode = fixture.getObjectCode();
        ObjectLevel objLevel = new ObjectLevel();
        objLevel.setFinancialObjectLevelCode(levelCode);
        objectCode.setFinancialObjectLevel(objLevel);
        objectCode.setFinancialObjectLevelCode(levelCode);
        return objectCode;
    }

    public void testValidateObjectCodeVersusTransactionType_Passing() {
        PurchasingCapitalAssetFixture fixture = PurchasingCapitalAssetFixture.POSITIVE_QUANTITY_CAPITAL_PRICE_POSSIBLE_OBJECT_CODE;
        ObjectCode objectCode = fixture.getObjectCode();
        ObjectSubType financialObjectSubType = new ObjectSubType();
        objectCode.setFinancialObjectSubTypeCode("AM");
        financialObjectSubType.setFinancialObjectSubTypeName("Arts and Museums");
        objectCode.setFinancialObjectSubType(financialObjectSubType);
        AssetTransactionType tranType = new AssetTransactionType();
        tranType.setCapitalAssetTransactionTypeCode("NEW");
    }

    public void testValidateObjectCodeVersusTransactionType_NotIncludedCombination() {
        PurchasingCapitalAssetFixture fixture = PurchasingCapitalAssetFixture.POSITIVE_QUANTITY_CAPITAL_PRICE_POSSIBLE_OBJECT_CODE;
        ObjectCode objectCode = fixture.getObjectCode();
        ObjectSubType financialObjectSubType = new ObjectSubType();
        objectCode.setFinancialObjectSubTypeCode("AM");
        financialObjectSubType.setFinancialObjectSubTypeName("Arts and Museums");
        objectCode.setFinancialObjectSubType(financialObjectSubType);
        AssetTransactionType tranType = new AssetTransactionType();
        tranType.setCapitalAssetTransactionTypeCode("FABR");
    }

    public void testValidateObjectCodeVersusTransactionType_NotIncludedSubtype() {
        PurchasingCapitalAssetFixture fixture = PurchasingCapitalAssetFixture.POSITIVE_QUANTITY_CAPITAL_PRICE_POSSIBLE_OBJECT_CODE;
        ObjectCode objectCode = fixture.getObjectCode();
        ObjectSubType financialObjectSubType = new ObjectSubType();
        objectCode.setFinancialObjectSubTypeCode("BI");
        financialObjectSubType.setFinancialObjectSubTypeName("Bond Issuance");
        objectCode.setFinancialObjectSubType(financialObjectSubType);
        AssetTransactionType tranType = new AssetTransactionType();
        tranType.setCapitalAssetTransactionTypeCode("NEW");
    }
}

