/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.ArrayList;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class AssetServiceTest
extends KualiTestBase {
    private AssetService assetService;

    protected void setUp() throws Exception {
        super.setUp();
        this.assetService = (AssetService)SpringContext.getBean(AssetService.class);
    }

    public void testIsObjectSubTypeCompatible_Success() throws Exception {
        ArrayList<String> ls = new ArrayList<String>();
        ls.add("UC");
        ls.add("UF");
        ls.add("UO");
        AssetServiceTest.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("LI");
        ls.add("LI");
        AssetServiceTest.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("LI");
        AssetServiceTest.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("IF");
        AssetServiceTest.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("IF");
        ls.add("IF");
        AssetServiceTest.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
    }

    public void testIsObjectSubTypeCompatible_Failure() throws Exception {
        ArrayList<String> ls = new ArrayList<String>();
        ls.add("BD");
        ls.add("UF");
        ls.add("UO");
        AssetServiceTest.assertFalse((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("UF");
        ls.add("LI");
        AssetServiceTest.assertFalse((boolean)this.assetService.isObjectSubTypeCompatible(ls));
    }

    public void testIsMovableFinancialObjectSubtypeCode_Success() throws Exception {
        AssetServiceTest.assertTrue((boolean)this.assetService.isAssetMovableCheckByPayment("C2"));
    }

    public void testIsMovableFinancialObjectSubtypeCode_Failure() throws Exception {
        AssetServiceTest.assertFalse((boolean)this.assetService.isAssetMovableCheckByPayment("LI"));
        boolean failedAsExpected = false;
        try {
            this.assetService.isAssetMovableCheckByPayment("XY");
        }
        catch (ValidationException e) {
            failedAsExpected = true;
        }
        AssetServiceTest.assertTrue((boolean)failedAsExpected);
    }
}

