/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.time.Month;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.service.impl.AssetServiceImpl;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.ObjectCodeFixture;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.util.ReflectionUtils;

public class AssetServiceTest {
    private AssetServiceImpl assetService;
    @Mock
    private ObjectCodeService objectCodeService;
    @Mock
    private ParameterService parameterService;
    private static PersistenceStructureService persistenceStructureService;
    private static AssetLocationGlobalDetail assetLocationGlobalDetail;

    @Before
    public void setUp() throws Exception {
        this.setupFiscalYearForTesting();
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(new ArrayList<String>(Arrays.asList("CM;CF;C1;C2;UC;UF;CO;UO;ES".split(";"))));
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "NON_MOVABLE_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(new ArrayList<String>(Arrays.asList("AM;BD;BF;BI;CP;IF;LA;LE;LI;LF;LR;BR;BY;BX".split(";"))));
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "OBJECT_SUB_TYPE_GROUPS")).thenReturn(new ArrayList<String>(Arrays.asList("BD,BF;CM,CF,CO;UC,UF,UO;LI,LF".split(";"))));
        Mockito.when((Object)this.objectCodeService.getByPrimaryIdForCurrentYear("BL", "7100")).thenReturn((Object)ObjectCodeFixture.OBJECT_CODE_LIB_ACQUIS.createObjectCode());
        Mockito.when((Object)this.objectCodeService.getByPrimaryIdForCurrentYear("BL", "7022")).thenReturn((Object)ObjectCodeFixture.OBJECT_CODE_CAP_LEASE.createObjectCode());
        this.assetService = new AssetServiceImpl();
        this.assetService.setParameterService(this.parameterService);
        this.assetService.setObjectCodeService(this.objectCodeService);
    }

    private void setupFiscalYearForTesting() {
        int year = YearMonth.now().getYear();
        int month = YearMonth.now().getMonthValue();
        if (month >= Month.JULY.getValue()) {
            ++year;
        }
        TestUtils.setFiscalYearForTesting((Integer)year);
    }

    @After
    public void tearDown() throws NoSuchFieldException, IllegalAccessException {
        AssetServiceTest.teardownPersistenceStructureService(assetLocationGlobalDetail);
        assetLocationGlobalDetail = null;
        this.objectCodeService = null;
        this.parameterService = null;
        persistenceStructureService = null;
        this.assetService.setParameterService(null);
        this.assetService.setObjectCodeService(null);
        this.assetService = null;
    }

    @Test
    public void testIsObjectSubTypeCompatible_Success() throws Exception {
        ArrayList<String> ls = new ArrayList<String>();
        ls.add("UC");
        ls.add("UF");
        ls.add("UO");
        Assert.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("LI");
        ls.add("LI");
        Assert.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("LI");
        Assert.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("IF");
        Assert.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("IF");
        ls.add("IF");
        Assert.assertTrue((boolean)this.assetService.isObjectSubTypeCompatible(ls));
    }

    @Test
    public void testIsObjectSubTypeCompatible_Failure() throws Exception {
        ArrayList<String> ls = new ArrayList<String>();
        ls.add("BD");
        ls.add("UF");
        ls.add("UO");
        Assert.assertFalse((boolean)this.assetService.isObjectSubTypeCompatible(ls));
        ls.clear();
        ls.add("UF");
        ls.add("LI");
        Assert.assertFalse((boolean)this.assetService.isObjectSubTypeCompatible(ls));
    }

    @Test
    public void isAssetMovableCheckByPaymentNoPayments() {
        Asset asset = new Asset();
        asset.setFinancialObjectSubTypeCode("C2");
        Assert.assertTrue((boolean)this.assetService.isAssetMovableCheckByPayment(asset));
    }

    @Test
    public void isAssetMovableCheckByPaymentOnePayment() {
        Asset asset = new Asset();
        asset.setFinancialObjectSubTypeCode("C2");
        List<AssetPayment> assetPayments = this.setupAssetPayments("7100");
        asset.setAssetPayments(assetPayments);
        Assert.assertFalse((boolean)this.assetService.isAssetMovableCheckByPayment(asset));
    }

    @Test
    public void isAssetMovableCheckByPaymentTwoPayment() {
        Asset asset = new Asset();
        asset.setFinancialObjectSubTypeCode("LI");
        List<AssetPayment> assetPayments = this.setupAssetPayments("7100");
        AssetPayment anotherAssetPayment = this.setupAssetPayment("7022");
        assetPayments.add(anotherAssetPayment);
        asset.setAssetPayments(assetPayments);
        Assert.assertTrue((boolean)this.assetService.isAssetMovableCheckByPayment(asset));
    }

    @Test
    public void isAssetMovableCheckByPaymentOutOfDatePayment() {
        Asset asset = new Asset();
        asset.setFinancialObjectSubTypeCode("C2");
        List<AssetPayment> assetPayments = this.setupAssetPayments("XXXX");
        asset.setAssetPayments(assetPayments);
        Assert.assertTrue((boolean)this.assetService.isAssetMovableCheckByPayment(asset));
    }

    private List<AssetPayment> setupAssetPayments(String financialObjectCode) {
        ArrayList<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
        AssetPayment assetPayment = this.setupAssetPayment(financialObjectCode);
        assetPayments.add(assetPayment);
        return assetPayments;
    }

    private AssetPayment setupAssetPayment(String financialObjectCode) {
        AssetPayment assetPayment = (AssetPayment)Mockito.mock(AssetPayment.class);
        ((AssetPayment)Mockito.doNothing().when((Object)assetPayment)).refreshReferenceObject("financialObject");
        Mockito.when((Object)assetPayment.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)assetPayment.getFinancialObjectCode()).thenReturn((Object)financialObjectCode);
        return assetPayment;
    }

    @Test
    public void testIsMovableFinancialObjectSubtypeCode_Success() throws Exception {
        Assert.assertTrue((boolean)this.assetService.isAssetMovableCheckByPayment("C2"));
    }

    @Test
    public void testIsMovableFinancialObjectSubtypeCode_Failure() throws Exception {
        Assert.assertFalse((boolean)this.assetService.isAssetMovableCheckByPayment("LI"));
        boolean failedAsExpected = false;
        try {
            this.assetService.isAssetMovableCheckByPayment("XY");
        }
        catch (ValidationException e) {
            failedAsExpected = true;
        }
        Assert.assertTrue((boolean)failedAsExpected);
    }

    @Test
    public void hasCapitalAssetChangedNoChanges() {
        Assert.assertFalse((boolean)this.assetService.hasCapitalAssetLocationDetailsChanged(new AssetLocationGlobalDetail()));
    }

    @Test
    public void hasCapitalAssetChangedCampusCodeChanged() throws NoSuchFieldException, IllegalAccessException {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail();
        assetLocationGlobalDetail.setCampusCode("BL");
        Assert.assertTrue((boolean)this.assetService.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    public void hasCapitalAssetChangedBuildingCodeChanged() throws NoSuchFieldException, IllegalAccessException {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail();
        assetLocationGlobalDetail.setBuildingCode("0001C");
        Assert.assertTrue((boolean)this.assetService.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    public void hasCapitalAssetChangedBuildingRoomNumberChanged() throws NoSuchFieldException, IllegalAccessException {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail();
        assetLocationGlobalDetail.setBuildingRoomNumber("001");
        Assert.assertTrue((boolean)this.assetService.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    public void hasCapitalAssetChangedBuildingSubRoomNumberChanged() throws NoSuchFieldException, IllegalAccessException {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail();
        assetLocationGlobalDetail.setBuildingSubRoomNumber("C");
        Assert.assertTrue((boolean)this.assetService.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    public void hasCapitalAssetChangedCampusTagNumberChanged() throws NoSuchFieldException, IllegalAccessException {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail();
        assetLocationGlobalDetail.setCampusTagNumber("ABC123");
        Assert.assertTrue((boolean)this.assetService.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    @Test
    public void hasCapitalAssetChangedUpdateLastInventoryDateButtonClicked() throws NoSuchFieldException, IllegalAccessException {
        AssetLocationGlobalDetail assetLocationGlobalDetail = AssetServiceTest.setupAssetLocationGlobalDetail();
        assetLocationGlobalDetail.setUpdateLastInventoryDate(true);
        Assert.assertFalse((boolean)this.assetService.hasCapitalAssetLocationDetailsChanged(assetLocationGlobalDetail));
    }

    public static AssetLocationGlobalDetail setupAssetLocationGlobalDetail() throws NoSuchFieldException, IllegalAccessException {
        assetLocationGlobalDetail = new AssetLocationGlobalDetail();
        AssetServiceTest.setupPersistenceStructureService(assetLocationGlobalDetail);
        assetLocationGlobalDetail.setAsset(new Asset());
        assetLocationGlobalDetail.setCapitalAssetNumber(Long.valueOf(12345L));
        return assetLocationGlobalDetail;
    }

    public static void setupPersistenceStructureService(AssetLocationGlobalDetail assetLocationGlobalDetail) throws NoSuchFieldException, IllegalAccessException {
        persistenceStructureService = (PersistenceStructureService)Mockito.mock(PersistenceStructureService.class);
        ReflectionUtils.doWithFields(AssetLocationGlobalDetail.class, field -> {
            field.setAccessible(true);
            field.set(assetLocationGlobalDetail, persistenceStructureService);
        }, field -> StringUtils.equals((String)field.getName(), (String)"persistenceStructureService"));
    }

    public static void teardownPersistenceStructureService(AssetLocationGlobalDetail assetLocationGlobalDetail) throws NoSuchFieldException, IllegalAccessException {
        ReflectionUtils.doWithFields(AssetLocationGlobalDetail.class, field -> {
            field.setAccessible(true);
            field.set(assetLocationGlobalDetail, null);
        }, field -> StringUtils.equals((String)field.getName(), (String)"persistenceStructureService"));
    }
}

