/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.fixture;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetRetirementGlobalDetail;
import org.kuali.kfs.module.cam.fixture.CamsFixture;
import org.kuali.kfs.sys.context.SpringContext;

public enum AssetRetirementGlobalMaintainableFixture {
    RETIREMENT1(1);

    private int testDataPos;
    private static Properties properties;
    private static final AccountService acctService;

    private AssetRetirementGlobalMaintainableFixture(int dataPos) {
        this.testDataPos = dataPos;
    }

    public AssetRetirementGlobal newAssetRetirement() {
        String propertyKey = "assetRetirement.testData" + this.testDataPos;
        String deliminator = properties.getProperty("deliminator");
        String fieldNames = properties.getProperty("assetRetirement.fieldNames");
        AssetRetirementGlobal assetRetirementGlobal = CamsFixture.DATA_POPULATOR.buildTestDataObject(AssetRetirementGlobal.class, properties, propertyKey, fieldNames, deliminator);
        List<AssetRetirementGlobalDetail> assetRetirementGlobalDetail = this.newAssetRetirementDetail();
        assetRetirementGlobal.setAssetRetirementGlobalDetails(assetRetirementGlobalDetail);
        return assetRetirementGlobal;
    }

    private List<AssetRetirementGlobalDetail> newAssetRetirementDetail() {
        ArrayList<AssetRetirementGlobalDetail> assetRetirementGlobalDetails = new ArrayList<AssetRetirementGlobalDetail>();
        List<Asset> assets = this.newAssets();
        for (Asset asset : assets) {
            AssetRetirementGlobalDetail assetRetirementDetail = new AssetRetirementGlobalDetail();
            assetRetirementDetail.setAsset(asset);
            assetRetirementGlobalDetails.add(assetRetirementDetail);
        }
        return assetRetirementGlobalDetails;
    }

    private List<Asset> newAssets() {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        String deliminator = properties.getProperty("deliminator");
        String fieldNames = properties.getProperty("asset.fieldNames");
        Integer dataRows = new Integer(properties.getProperty("asset.numOfData"));
        this.testDataPos = 1;
        for (int i = 1; i <= dataRows; ++i) {
            String propertyKey = "asset.testData" + i;
            Asset asset = CamsFixture.DATA_POPULATOR.buildTestDataObject(Asset.class, properties, propertyKey, fieldNames, deliminator);
            List<AssetPayment> assetPayments = this.newAssetPayments();
            asset.setAssetPayments(assetPayments);
            for (AssetPayment assetPayment : assetPayments) {
                assetPayment.setAsset(asset);
            }
            assets.add(asset);
            this.testDataPos += 2;
        }
        return assets;
    }

    private List<AssetPayment> newAssetPayments() {
        ArrayList<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
        String deliminator = properties.getProperty("deliminator");
        String fieldNames = properties.getProperty("assetPayment.fieldNames");
        Integer dataRows = new Integer(properties.getProperty("assetPayment.numOfData"));
        for (int i = this.testDataPos; i <= dataRows && i < this.testDataPos + 2; ++i) {
            String propertyKey = "assetPayment.testData" + i;
            AssetPayment assetPayment = CamsFixture.DATA_POPULATOR.buildTestDataObject(AssetPayment.class, properties, propertyKey, fieldNames, deliminator);
            String[] data = properties.getProperty(propertyKey).split(",");
            String[] fields = fieldNames.split(",");
            String coa = null;
            String acctnum = null;
            boolean gotit = false;
            for (int j = 0; j < fields.length; ++j) {
                if ("accountnumber".equalsIgnoreCase(fields[j])) {
                    acctnum = data[j];
                } else if ("chartofaccountscode".equalsIgnoreCase(fields[j])) {
                    coa = data[j];
                }
                if (acctnum == null || coa == null) continue;
                Account act = acctService.getByPrimaryId(coa, acctnum);
                assetPayment.setAccount(act);
                gotit = true;
                break;
            }
            if (!gotit) {
                throw new RuntimeException("Unable to find account number of asset payment.");
            }
            assetPayments.add(assetPayment);
        }
        return assetPayments;
    }

    static {
        String propertiesFileName = "org/kuali/kfs/module/cam/document/service/asset_retirement.properties";
        properties = new Properties();
        try {
            properties.load(AssetRetirementGlobalMaintainableFixture.class.getClassLoader().getResourceAsStream(propertiesFileName));
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        acctService = (AccountService)SpringContext.getBean(AccountService.class);
    }
}

