/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.fixture;

import java.io.IOException;
import java.util.Properties;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.AssetTransferDocument;
import org.kuali.kfs.module.cam.fixture.CamsFixture;

public enum AssetTransferFixture {
    ACTIVE_CAPITAL_ASSET(1),
    RETIRED_ASSET(2),
    ACTIVE_NON_CAPITAL_ASSET(3),
    PAYMENT1_WITH_OFFSET(1),
    PAYMENT2_WITH_OFFSET(2),
    PAYMENT3_WITHOUT_OFFSET(3),
    PAYMENT4_WITHOUT_OFFSET(4),
    ASSET_TRANSFER(1);

    private int testDataPos;
    private static Properties properties;

    private AssetTransferFixture(int dataPos) {
        this.testDataPos = dataPos;
    }

    public Asset newAsset() {
        String propertyKey = "asset.testData" + this.testDataPos;
        String deliminator = properties.getProperty("deliminator");
        String fieldNames = properties.getProperty("asset.fieldNames");
        Asset asset = CamsFixture.DATA_POPULATOR.buildTestDataObject(Asset.class, properties, propertyKey, fieldNames, deliminator);
        return asset;
    }

    public AssetTransferDocument newAssetTransferDocument() {
        String propertyKey = "assetTransfer.testData" + this.testDataPos;
        String deliminator = properties.getProperty("deliminator");
        String fieldNames = properties.getProperty("assetTransfer.fieldNames");
        AssetTransferDocument assetTransferDocument = CamsFixture.DATA_POPULATOR.buildTestDataObject(AssetTransferDocument.class, properties, propertyKey, fieldNames, deliminator);
        return assetTransferDocument;
    }

    public AssetPayment newAssetPayment() {
        String propertyKey = "assetPayment.testData" + this.testDataPos;
        String deliminator = properties.getProperty("deliminator");
        String fieldNames = properties.getProperty("assetPayment.fieldNames");
        AssetPayment assetPayment = CamsFixture.DATA_POPULATOR.buildTestDataObject(AssetPayment.class, properties, propertyKey, fieldNames, deliminator);
        return assetPayment;
    }

    static {
        String propertiesFileName = "org/kuali/kfs/module/cam/document/service/asset_transfer_service.properties";
        properties = new Properties();
        try {
            properties.load(AssetTransferFixture.class.getClassLoader().getResourceAsStream(propertiesFileName));
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

