/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam;

import java.util.List;
import org.kuali.kfs.module.cam.businessobject.PurApAccountLineGroup;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PurApAccountLineGroupTest
extends KualiTestBase {
    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCombineEntry_PREQ() throws Exception {
        PurApAccountLineGroup group = this.createAccountLineGroup(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(100), PaymentRequestAccountRevision.class);
        PurApAccountingLineBase first = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(200), PaymentRequestAccountRevision.class);
        PurApAccountLineGroupTest.assertTrue((boolean)group.equals((Object)new PurApAccountLineGroupTestable(first, "1001", null)));
        group.combineEntry(first);
        PurApAccountLineGroupTest.assertEquals((Object)new KualiDecimal(300), (Object)group.getAmount());
        PurApAccountingLineBase second = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(-100), PaymentRequestAccountRevision.class);
        PurApAccountLineGroupTest.assertTrue((boolean)group.equals((Object)new PurApAccountLineGroupTestable(second, "1001", null)));
        group.combineEntry(second);
        PurApAccountLineGroupTest.assertEquals((Object)new KualiDecimal(200), (Object)group.getAmount());
        PurApAccountingLineBase third = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(-200), PaymentRequestAccountRevision.class);
        PurApAccountLineGroupTest.assertTrue((boolean)group.equals((Object)new PurApAccountLineGroupTestable(third, "1001", null)));
        group.combineEntry(third);
        PurApAccountLineGroupTest.assertEquals((Object)new KualiDecimal(0), (Object)group.getAmount());
        List sourceEntries = group.getSourceEntries();
        PurApAccountLineGroupTest.assertEquals((int)4, (int)sourceEntries.size());
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        for (PurApAccountingLineBase entry : sourceEntries) {
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)entry.getAmount());
        }
        PurApAccountLineGroupTest.assertEquals((Object)group.getAmount(), (Object)totalAmount);
    }

    public void testCombineEntry_CM() throws Exception {
        PurApAccountLineGroup group = this.createAccountLineGroup(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(100), CreditMemoAccountRevision.class);
        PurApAccountingLineBase first = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(200), CreditMemoAccountRevision.class);
        PurApAccountLineGroupTest.assertTrue((boolean)group.equals((Object)new PurApAccountLineGroupTestable(first, "1001", null)));
        group.combineEntry(first);
        PurApAccountLineGroupTest.assertEquals((Object)new KualiDecimal(-300), (Object)group.getAmount());
        PurApAccountingLineBase second = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(-100), CreditMemoAccountRevision.class);
        PurApAccountLineGroupTest.assertTrue((boolean)group.equals((Object)new PurApAccountLineGroupTestable(second, "1001", null)));
        group.combineEntry(second);
        PurApAccountLineGroupTest.assertEquals((Object)new KualiDecimal(-200), (Object)group.getAmount());
        PurApAccountingLineBase third = this.createEntry(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(-200), CreditMemoAccountRevision.class);
        PurApAccountLineGroupTest.assertTrue((boolean)group.equals((Object)new PurApAccountLineGroupTestable(third, "1001", null)));
        group.combineEntry(third);
        PurApAccountLineGroupTest.assertEquals((Object)new KualiDecimal(0), (Object)group.getAmount());
        List sourceEntries = group.getSourceEntries();
        PurApAccountLineGroupTest.assertEquals((int)4, (int)sourceEntries.size());
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        for (PurApAccountingLineBase entry : sourceEntries) {
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)entry.getAmount());
        }
        PurApAccountLineGroupTest.assertEquals((Object)group.getAmount(), (Object)totalAmount);
    }

    private PurApAccountLineGroup createAccountLineGroup(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, String refDocNum, KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entry = this.createEntry(i, chartCode, acctNum, subAcctNum, objCd, subObjCd, fiscalPrd, docNum, refDocNum, amount, clazz);
        PurApAccountLineGroupTestable first = new PurApAccountLineGroupTestable(entry, docNum, refDocNum);
        return first;
    }

    private PurApAccountingLineBase createEntry(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, String refDocNum, KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entry = null;
        try {
            entry = clazz.newInstance();
        }
        catch (Exception e) {
            PurApAccountLineGroupTest.fail((String)e.toString());
        }
        entry.setPostingYear(i);
        entry.setChartOfAccountsCode(chartCode);
        entry.setAccountNumber(acctNum);
        entry.setSubAccountNumber(subAcctNum);
        entry.setFinancialObjectCode(objCd);
        entry.setFinancialSubObjectCode(subObjCd);
        entry.setPostingPeriodCode(fiscalPrd);
        entry.setDocumentNumber(docNum);
        entry.setAmount(amount);
        return entry;
    }

    public static class PurApAccountLineGroupTestable
    extends PurApAccountLineGroup {
        public PurApAccountLineGroupTestable(PurApAccountingLineBase entry, String docNum, String refDocNum) {
            this.setDocumentNumber(docNum);
            this.setReferenceFinancialDocumentNumber(refDocNum);
            this.setUniversityFiscalYear(entry.getPostingYear());
            this.setUniversityFiscalPeriodCode(entry.getPostingPeriodCode());
            this.setChartOfAccountsCode(entry.getChartOfAccountsCode());
            this.setAccountNumber(entry.getAccountNumber());
            this.setSubAccountNumber(entry.getSubAccountNumber());
            this.setFinancialObjectCode(entry.getFinancialObjectCode());
            this.setFinancialSubObjectCode(entry.getFinancialSubObjectCode());
            this.getSourceEntries().add(entry);
            if (CreditMemoAccountRevision.class.isAssignableFrom(entry.getClass())) {
                this.setAmount((KualiDecimal)entry.getAmount().negated());
            } else {
                this.setAmount(entry.getAmount());
            }
        }
    }
}

