/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.lookup.AssetLookupableHelperServiceImpl;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentAuthorizerBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AssetLookupableHelperServiceImplTest {
    public static final String AUTHORIZED_PRINCIPAL_ID = "khuntley";
    public static final String UNAUTHORIZED_PRINCIPAL_ID = "rorenfro";
    public static final String NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE = "NA";
    public static final String CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE = "C2";
    private TestableAssetLookupableHelperServiceImpl assetLookupableHelperService;
    @Mock
    private AssetService assetService;
    @Mock
    private DocumentDictionaryService documentDictionaryService;
    @Mock
    private FinancialSystemTransactionalDocumentAuthorizerBase documentAuthorizer;
    @Mock
    private ParameterService parameterService;
    @Mock
    private PermissionService permissionService;
    @Mock
    private Person person;
    @Mock
    private UserSession userSession;
    private Asset moveableAsset;
    private Asset nonMoveableAssetAuthorized;
    private Asset nonMoveableAssetNonAuthorized;
    private Asset unableToDetermineMoveableAsset;
    private Asset nonCapitalAssetNoPayments;
    private Asset nonCapitalAssetSubTypeShowLink;
    private Asset nonCapitalAssetSubTypeHideLink;
    @Mock
    private AssetPayment assetPaymentNonCapitalEquipmentObjectSubType;
    @Mock
    private AssetPayment assetPayment;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupMockObjects();
        this.setupAssets();
        this.setupMockServices();
        this.assetLookupableHelperService = new TestableAssetLookupableHelperServiceImpl();
        this.assetLookupableHelperService.setPrincipalId(AUTHORIZED_PRINCIPAL_ID);
        this.assetLookupableHelperService.setAssetService(this.assetService);
        this.assetLookupableHelperService.setDocumentDictionaryService(this.documentDictionaryService);
        this.assetLookupableHelperService.setParameterService(this.parameterService);
    }

    private void setupMockObjects() {
        ((AssetPayment)Mockito.doNothing().when((Object)this.assetPaymentNonCapitalEquipmentObjectSubType)).refreshReferenceObject("financialObject");
        ObjectCode objectCodeNonCapitalEquipmentObjectSubType = new ObjectCode();
        objectCodeNonCapitalEquipmentObjectSubType.setChartOfAccountsCode("BL");
        objectCodeNonCapitalEquipmentObjectSubType.setFinancialObjectCode("5200");
        this.assetPaymentNonCapitalEquipmentObjectSubType.setFinancialObject(objectCodeNonCapitalEquipmentObjectSubType);
        ((AssetPayment)Mockito.doNothing().when((Object)this.assetPayment)).refreshReferenceObject("financialObject");
        Mockito.when((Object)this.person.getPrincipalId()).thenReturn((Object)"principalId");
        Mockito.when((Object)this.userSession.getPerson()).thenReturn((Object)this.person);
    }

    private void setupAssets() {
        this.moveableAsset = new Asset();
        this.moveableAsset.setCapitalAssetNumber(Long.valueOf(0L));
        this.moveableAsset.setInventoryStatusCode("A");
        this.nonMoveableAssetAuthorized = new Asset();
        this.nonMoveableAssetAuthorized.setCapitalAssetNumber(Long.valueOf(1L));
        this.nonMoveableAssetAuthorized.setInventoryStatusCode("A");
        this.nonMoveableAssetNonAuthorized = new Asset();
        this.nonMoveableAssetNonAuthorized.setCapitalAssetNumber(Long.valueOf(2L));
        this.nonMoveableAssetNonAuthorized.setInventoryStatusCode("A");
        this.unableToDetermineMoveableAsset = new Asset();
        this.unableToDetermineMoveableAsset.setCapitalAssetNumber(Long.valueOf(3L));
        this.unableToDetermineMoveableAsset.setInventoryStatusCode("A");
        this.nonCapitalAssetNoPayments = new Asset();
        this.nonCapitalAssetNoPayments.setCapitalAssetNumber(Long.valueOf(4L));
        this.nonCapitalAssetNoPayments.setInventoryStatusCode("N");
        this.nonCapitalAssetSubTypeShowLink = new Asset();
        this.nonCapitalAssetSubTypeShowLink.setCapitalAssetNumber(Long.valueOf(5L));
        ArrayList<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
        assetPayments.add(this.assetPaymentNonCapitalEquipmentObjectSubType);
        this.nonCapitalAssetSubTypeShowLink.setAssetPayments(assetPayments);
        this.nonCapitalAssetSubTypeShowLink.setInventoryStatusCode("N");
        this.nonCapitalAssetSubTypeHideLink = new Asset();
        this.nonCapitalAssetSubTypeHideLink.setCapitalAssetNumber(Long.valueOf(6L));
        assetPayments.clear();
        assetPayments.add(this.assetPayment);
        this.nonCapitalAssetSubTypeHideLink.setAssetPayments(assetPayments);
        this.nonCapitalAssetSubTypeHideLink.setInventoryStatusCode("N");
    }

    private void setupMockServices() {
        Mockito.when((Object)this.assetService.isAssetMovableCheckByPayment(this.moveableAsset)).thenReturn((Object)true);
        Mockito.when((Object)this.assetService.isAssetMovableCheckByPayment(this.nonMoveableAssetAuthorized)).thenReturn((Object)false);
        Mockito.when((Object)this.assetService.isAssetMovableCheckByPayment(this.nonMoveableAssetNonAuthorized)).thenReturn((Object)false);
        Mockito.when((Object)this.assetService.isAssetMovableCheckByPayment(this.unableToDetermineMoveableAsset)).thenThrow(ValidationException.class);
        Mockito.when((Object)this.assetService.determineFinancialObjectSubTypeCode(this.nonCapitalAssetSubTypeHideLink)).thenReturn((Object)CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE);
        Mockito.when((Object)this.assetService.determineFinancialObjectSubTypeCode(this.nonCapitalAssetSubTypeShowLink)).thenReturn((Object)NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE);
        HashMap<String, String> roleQualification = new HashMap<String, String>();
        roleQualification.put("principalId", AUTHORIZED_PRINCIPAL_ID);
        Mockito.when((Object)this.permissionService.isAuthorized(AUTHORIZED_PRINCIPAL_ID, "KFS-CAM", "Separate", roleQualification)).thenReturn((Object)true);
        roleQualification.put("principalId", UNAUTHORIZED_PRINCIPAL_ID);
        Mockito.when((Object)this.permissionService.isAuthorized(UNAUTHORIZED_PRINCIPAL_ID, "KFS-CAM", "Separate", roleQualification)).thenReturn((Object)false);
        FinancialSystemTransactionalDocumentAuthorizerBase.setPermissionService((PermissionService)this.permissionService);
        Mockito.when((Object)this.documentAuthorizer.isAuthorized((BusinessObject)this.nonMoveableAssetAuthorized, "KFS-CAM", "Separate", AUTHORIZED_PRINCIPAL_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.documentAuthorizer.isAuthorized((BusinessObject)this.nonMoveableAssetNonAuthorized, "KFS-CAM", "Separate", UNAUTHORIZED_PRINCIPAL_ID)).thenReturn((Object)false);
        Mockito.when((Object)this.documentDictionaryService.getDocumentAuthorizer("AT")).thenReturn((Object)this.documentAuthorizer);
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(AssetDepreciationStep.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.parameterService.getParameterValuesAsString(Asset.class, "NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(new ArrayList<String>(Arrays.asList(NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE)));
    }

    @After
    public void tearDown() {
        this.tearDownMockObjects();
        this.tearDownAssets();
        this.tearDownMockServices();
    }

    private void tearDownMockObjects() {
        this.assetPaymentNonCapitalEquipmentObjectSubType = null;
        this.assetPayment = null;
        this.person = null;
        this.userSession = null;
    }

    private void tearDownAssets() {
        this.moveableAsset = null;
        this.nonMoveableAssetAuthorized = null;
        this.nonMoveableAssetNonAuthorized = null;
        this.unableToDetermineMoveableAsset = null;
        this.nonCapitalAssetNoPayments = null;
        this.nonCapitalAssetSubTypeShowLink = null;
        this.nonCapitalAssetSubTypeHideLink = null;
    }

    private void tearDownMockServices() {
        this.assetService = null;
        this.permissionService = null;
        FinancialSystemTransactionalDocumentAuthorizerBase.setPermissionService(null);
        this.documentAuthorizer = null;
        this.documentDictionaryService = null;
        this.parameterService = null;
    }

    @Test
    public void getTransferUrlUnableToDetermineMoveableAssetNonAuthorized() throws Exception {
        this.assetLookupableHelperService.setPrincipalId(UNAUTHORIZED_PRINCIPAL_ID);
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.assetLookupableHelperService.getTransferUrl(this.unableToDetermineMoveableAsset);
        this.validateEmptyAnchorHtmlData(anchorHtmlData);
    }

    @Test
    public void getTransferUrlUnableToDetermineMoveableAssetAuthorized() throws Exception {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.assetLookupableHelperService.getTransferUrl(this.unableToDetermineMoveableAsset);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.unableToDetermineMoveableAsset.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlMoveableAsset() throws Exception {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.assetLookupableHelperService.getTransferUrl(this.moveableAsset);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.moveableAsset.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlNonMoveableAssetAuthorized() throws Exception {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.assetLookupableHelperService.getTransferUrl(this.nonMoveableAssetAuthorized);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.nonMoveableAssetAuthorized.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlNonMoveableAssetNonAuthorized() throws Exception {
        this.assetLookupableHelperService.setPrincipalId(UNAUTHORIZED_PRINCIPAL_ID);
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.assetLookupableHelperService.getTransferUrl(this.nonMoveableAssetNonAuthorized);
        this.validateEmptyAnchorHtmlData(anchorHtmlData);
    }

    @Test
    public void getTransferUrlNonCapitalAssetNoPayments() throws Exception {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.assetLookupableHelperService.getTransferUrl(this.nonCapitalAssetNoPayments);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.nonCapitalAssetNoPayments.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlNonCapitalAssetSubTypeShouldHideLink() throws Exception {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.assetLookupableHelperService.getTransferUrl(this.nonCapitalAssetSubTypeHideLink);
        this.validateEmptyAnchorHtmlData(anchorHtmlData);
    }

    @Test
    public void getTransferUrlNonCapitalAssetSubTypeShouldShowLink() throws Exception {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.assetLookupableHelperService.getTransferUrl(this.nonCapitalAssetSubTypeShowLink);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.nonCapitalAssetSubTypeShowLink.getCapitalAssetNumber().toString());
    }

    private void validateEmptyAnchorHtmlData(HtmlData.AnchorHtmlData anchorHtmlData) {
        Assert.assertEquals((Object)"", (Object)anchorHtmlData.getHref());
        Assert.assertEquals((Object)"", (Object)anchorHtmlData.getMethodToCall());
        Assert.assertEquals((Object)"", (Object)anchorHtmlData.getDisplayText());
    }

    private void validatePopulatedAnchorHtmlData(HtmlData.AnchorHtmlData anchorHtmlData, String capitalAssetNumber) {
        Assert.assertEquals((Object)("../camsAssetTransfer.do?capitalAssetNumber=" + capitalAssetNumber + "&docTypeName=AT&methodToCall=docHandler&command=initiate"), (Object)anchorHtmlData.getHref());
        Assert.assertEquals((Object)"docHandler", (Object)anchorHtmlData.getMethodToCall());
        Assert.assertEquals((Object)"transfer", (Object)anchorHtmlData.getDisplayText());
    }

    private class TestableAssetLookupableHelperServiceImpl
    extends AssetLookupableHelperServiceImpl {
        private String principalId;

        private TestableAssetLookupableHelperServiceImpl() {
        }

        protected String determinePrincipalIdForCurrentUser() {
            return this.principalId;
        }

        public void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }
    }
}

