/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetLocationGlobalDetail;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.AssetServiceTest;
import org.kuali.kfs.module.cam.document.service.impl.AssetLocationServiceImpl;
import org.kuali.kfs.module.cam.document.service.impl.AssetServiceImpl;
import org.kuali.kfs.module.cam.document.validation.impl.AssetLocationGlobalRule;
import org.springframework.util.AutoPopulatingList;

public class AssetLocationGlobalRuleTest {
    private AssetLocationGlobalRule assetLocationGlobalRule;
    private AssetLocationGlobalDetail assetLocationGlobalDetail;
    private Asset asset;

    @Before
    public void setUp() {
        this.assetLocationGlobalRule = new AssetLocationGlobalRule();
        this.assetLocationGlobalRule.setAssetLocationService((AssetLocationService)new AssetLocationServiceImpl());
        this.assetLocationGlobalRule.setAssetService((AssetService)new AssetServiceImpl());
        this.assetLocationGlobalDetail = new AssetLocationGlobalDetail();
        this.assetLocationGlobalDetail.setCapitalAssetNumber(Long.valueOf(12345L));
        this.assetLocationGlobalDetail.setCampusCode("BL");
        this.assetLocationGlobalDetail.setBuildingCode("BL001");
        this.assetLocationGlobalDetail.setBuildingRoomNumber("001");
        this.asset = new Asset();
        this.assetLocationGlobalDetail.setAsset(this.asset);
    }

    @After
    public void tearDown() throws NoSuchFieldException, IllegalAccessException {
        AssetServiceTest.teardownPersistenceStructureService(this.assetLocationGlobalDetail);
        this.assetLocationGlobalRule = null;
        this.assetLocationGlobalDetail = null;
        this.asset = null;
        GlobalVariables.getMessageMap().getWarningMessages().clear();
    }

    @Test
    public void checkRequiredFieldsAfterAdd() throws Exception {
        Assert.assertTrue((boolean)this.assetLocationGlobalRule.checkRequiredFieldsAfterAdd(this.assetLocationGlobalDetail));
    }

    @Test
    public void checkRequiredFieldsAfterAddEmptyBuildingFields() throws Exception {
        this.assetLocationGlobalDetail.setBuildingCode(null);
        this.assetLocationGlobalDetail.setBuildingRoomNumber(null);
        Assert.assertFalse((boolean)this.assetLocationGlobalRule.checkRequiredFieldsAfterAdd(this.assetLocationGlobalDetail));
    }

    @Test
    public void checkRequiredFieldsAfterAddEmptyBuildingFieldsOffCampusLocation() throws Exception {
        ArrayList<AssetLocation> assetLocations = new ArrayList<AssetLocation>();
        AssetLocation assetLocation = new AssetLocation();
        assetLocation.setAssetLocationTypeCode("O");
        assetLocation.setAssetLocationStreetAddress("123 Main St.");
        assetLocations.add(assetLocation);
        this.asset.setAssetLocations(assetLocations);
        this.assetLocationGlobalDetail.setBuildingCode(null);
        this.assetLocationGlobalDetail.setBuildingRoomNumber(null);
        Assert.assertFalse((boolean)this.assetLocationGlobalRule.checkRequiredFieldsAfterAdd(this.assetLocationGlobalDetail));
    }

    @Test
    public void checkRequiredFieldsAfterAddEmptyBuildingFieldsOffCampusLocationUpdateButtonClicked() throws Exception {
        ArrayList<AssetLocation> assetLocations = new ArrayList<AssetLocation>();
        AssetLocation assetLocation = new AssetLocation();
        assetLocation.setAssetLocationTypeCode("O");
        assetLocation.setAssetLocationStreetAddress("123 Main St.");
        assetLocations.add(assetLocation);
        this.asset.setAssetLocations(assetLocations);
        this.assetLocationGlobalDetail.setBuildingCode(null);
        this.assetLocationGlobalDetail.setBuildingRoomNumber(null);
        this.assetLocationGlobalDetail.setUpdateLastInventoryDate(true);
        Assert.assertTrue((boolean)this.assetLocationGlobalRule.checkRequiredFieldsAfterAdd(this.assetLocationGlobalDetail));
    }

    @Test
    public void hasCapitalAssetChangedNoChanges() throws NoSuchFieldException, IllegalAccessException {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail();
        Assert.assertFalse((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assert.assertEquals((String)"We expect ONE warning messages at this point.", (long)1L, (long)GlobalVariables.getMessageMap().getWarningCount());
        Assert.assertEquals((Object)"warning.asset.not.changed", (Object)((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getWarningMessages().get("capitalAssetNumber")).get(0)).getErrorKey());
        Assert.assertEquals((Object[])new String[]{"12345"}, (Object[])((ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getWarningMessages().get("capitalAssetNumber")).get(0)).getMessageParameters());
    }

    @Test
    public void hasCapitalAssetChangedCampusCodeChanged() throws NoSuchFieldException, IllegalAccessException {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail();
        this.assetLocationGlobalDetail.setCampusCode("BL");
        Assert.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assert.assertEquals((String)"We expect NO warning messages at this point.", (long)0L, (long)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    public void hasCapitalAssetChangedBuildingCodeChanged() throws NoSuchFieldException, IllegalAccessException {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail();
        this.assetLocationGlobalDetail.setBuildingCode("0001C");
        Assert.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assert.assertEquals((String)"We expect NO warning messages at this point.", (long)0L, (long)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    public void hasCapitalAssetChangedBuildingRoomNumberChanged() throws NoSuchFieldException, IllegalAccessException {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail();
        this.assetLocationGlobalDetail.setBuildingRoomNumber("001");
        Assert.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assert.assertEquals((String)"We expect NO warning messages at this point.", (long)0L, (long)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    public void hasCapitalAssetChangedBuildingSubRoomNumberChanged() throws NoSuchFieldException, IllegalAccessException {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail();
        this.assetLocationGlobalDetail.setBuildingSubRoomNumber("C");
        Assert.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assert.assertEquals((String)"We expect NO warning messages at this point.", (long)0L, (long)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    public void hasCapitalAssetChangedCampusTagNumberChanged() throws NoSuchFieldException, IllegalAccessException {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail();
        this.assetLocationGlobalDetail.setCampusTagNumber("ABC123");
        Assert.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assert.assertEquals((String)"We expect NO warning messages at this point.", (long)0L, (long)GlobalVariables.getMessageMap().getWarningCount());
    }

    @Test
    public void hasCapitalAssetChangedUpdateLastInventoryDateButtonClicked() throws NoSuchFieldException, IllegalAccessException {
        this.assetLocationGlobalDetail = this.setupAssetLocationGlobalDetail();
        this.assetLocationGlobalDetail.setUpdateLastInventoryDate(true);
        Assert.assertTrue((boolean)this.assetLocationGlobalRule.hasCapitalAssetChangedOrUpdateInventoryDateButtonClicked(this.assetLocationGlobalDetail));
        Assert.assertEquals((String)"We expect NO warning messages at this point.", (long)0L, (long)GlobalVariables.getMessageMap().getWarningCount());
    }

    public AssetLocationGlobalDetail setupAssetLocationGlobalDetail() throws NoSuchFieldException, IllegalAccessException {
        this.assetLocationGlobalDetail = new AssetLocationGlobalDetail();
        AssetServiceTest.setupPersistenceStructureService(this.assetLocationGlobalDetail);
        this.assetLocationGlobalDetail.setAsset(new Asset());
        this.assetLocationGlobalDetail.setCapitalAssetNumber(Long.valueOf(12345L));
        return this.assetLocationGlobalDetail;
    }
}

