/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.impl.ObjectCodeServiceImpl;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.impl.BusinessObjectServiceImpl;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationConvention;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.AssetGlobalMaintainableImpl;
import org.kuali.kfs.module.cam.document.service.AssetDateService;
import org.kuali.kfs.module.cam.document.service.AssetGlobalService;
import org.kuali.kfs.module.cam.document.service.impl.AssetDateServiceImpl;
import org.kuali.kfs.module.cam.document.service.impl.AssetGlobalServiceImpl;
import org.kuali.rice.krad.bo.BusinessObject;

public class AssetGlobalMaintainableImplTest {
    private AssetGlobalMaintainableImpl assetGlobalMaintainable;
    private AssetGlobal assetGlobal;
    private Date now;
    private Date yesterday;

    @Before
    public void setUp() throws Exception {
        long currentTimeMillis = System.currentTimeMillis();
        this.now = new Date(currentTimeMillis);
        this.yesterday = new Date(currentTimeMillis - 86400000L);
        this.assetGlobalMaintainable = new StubAssetGlobalMaintainableImpl();
        this.assetGlobal = new AssetGlobal();
        this.assetGlobal.setCreateDate(this.yesterday);
        this.assetGlobal.setCapitalAssetInServiceDate(this.now);
        this.assetGlobal.setCapitalAssetDepreciationDate(this.now);
        this.assetGlobal.setCapitalAssetTypeCode("07009");
        AssetType assetType = new AssetType();
        this.assetGlobal.setCapitalAssetType(assetType);
        ArrayList<AssetPaymentDetail> assetPaymentDetails = new ArrayList<AssetPaymentDetail>();
        AssetPaymentDetail assetPaymentDetail = new AssetPaymentDetail();
        assetPaymentDetail.setPostingYear(Integer.valueOf(2017));
        assetPaymentDetails.add(assetPaymentDetail);
        this.assetGlobal.setAssetPaymentDetails(assetPaymentDetails);
        this.assetGlobalMaintainable.setBusinessObject((PersistableBusinessObject)this.assetGlobal);
        this.assetGlobalMaintainable.setAssetGlobalService((AssetGlobalService)new AssetGlobalServiceImpl());
        this.assetGlobalMaintainable.setBusinessObjectService((BusinessObjectService)new StubBusinessObjectServiceImpl());
        this.assetGlobalMaintainable.setObjectCodeService((ObjectCodeService)new StubObjectCodeServiceImpl());
        this.assetGlobalMaintainable.setAssetDateService((AssetDateService)new StubAssetDateServiceImpl());
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void prepareForSaveAssetNotSeparate() throws Exception {
        this.assetGlobal.getCapitalAssetType().setDepreciableLifeLimit(Integer.valueOf(1));
        this.assetGlobalMaintainable.prepareForSave();
        Assert.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCreateDate());
        Assert.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCapitalAssetInServiceDate());
        Assert.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCapitalAssetDepreciationDate());
    }

    @Test
    public void prepareForSaveAssetNotSeparateNoDepreciableLifeLimit() throws Exception {
        this.assetGlobalMaintainable.prepareForSave();
        Assert.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCreateDate());
        Assert.assertEquals(null, (Object)this.assetGlobal.getCapitalAssetInServiceDate());
        Assert.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCapitalAssetDepreciationDate());
    }

    @Test
    public void prepareForSaveAssetSeparate() throws Exception {
        this.assetGlobal.getCapitalAssetType().setDepreciableLifeLimit(Integer.valueOf(1));
        this.assetGlobal.setFinancialDocumentTypeCode("ASEP");
        this.assetGlobalMaintainable.prepareForSave();
        Assert.assertEquals((Object)this.yesterday, (Object)this.assetGlobal.getCreateDate());
        Assert.assertEquals((Object)this.now, (Object)this.assetGlobal.getCapitalAssetInServiceDate());
        Assert.assertEquals((Object)this.now, (Object)this.assetGlobal.getCapitalAssetDepreciationDate());
    }

    private class StubAssetDateServiceImpl
    extends AssetDateServiceImpl {
        private StubAssetDateServiceImpl() {
        }

        public Date computeDepreciationDate(AssetType assetType, AssetDepreciationConvention depreciationConvention, Date inServiceDate) {
            return AssetGlobalMaintainableImplTest.this.assetGlobal.getCreateDate();
        }
    }

    private class StubBusinessObjectServiceImpl
    extends BusinessObjectServiceImpl {
        private StubBusinessObjectServiceImpl() {
        }

        public <T extends BusinessObject> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys) {
            return null;
        }
    }

    private class StubObjectCodeServiceImpl
    extends ObjectCodeServiceImpl {
        private StubObjectCodeServiceImpl() {
        }

        public ObjectCode getByPrimaryId(Integer universityFiscalYear, String chartOfAccountsCode, String financialObjectCode) {
            return new ObjectCode();
        }
    }

    private class StubAssetGlobalMaintainableImpl
    extends AssetGlobalMaintainableImpl {
        private StubAssetGlobalMaintainableImpl() {
        }

        protected void refreshReferenceObject(PersistableBusinessObjectBase persistableBusinessObject, String referenceObjectName) {
        }
    }
}

