/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.dataaccess.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.module.cam.batch.AssetPaymentInfo;
import org.kuali.kfs.module.cam.document.dataaccess.DepreciationBatchDao;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class MockDepreciationBatchDao
implements DepreciationBatchDao {
    private DepreciationBatchDao impl;
    private List<String> assetPaymentsStr = new ArrayList<String>();

    public void updateAssetPayments(List<AssetPaymentInfo> assetPayments, Integer fiscalMonth) {
        this.impl.updateAssetPayments(assetPayments, fiscalMonth);
        for (AssetPaymentInfo assetPaymentInfo : assetPayments) {
            String t = fiscalMonth + "-" + assetPaymentInfo.getCapitalAssetNumber() + "-" + assetPaymentInfo.getPaymentSequenceNumber() + "-" + assetPaymentInfo.getTransactionAmount().bigDecimalValue();
            this.assetPaymentsStr.add(t);
        }
    }

    public Integer getFullyDepreciatedAssetCount() {
        return this.impl.getFullyDepreciatedAssetCount();
    }

    public Collection<AssetPaymentInfo> getListOfDepreciableAssetPaymentInfo(Integer fiscalYear, Integer fiscalMonth, Calendar depreciationDate) {
        return this.impl.getListOfDepreciableAssetPaymentInfo(fiscalYear, fiscalMonth, depreciationDate);
    }

    public void resetPeriodValuesWhenFirstFiscalPeriod(Integer fiscalPeriod) throws Exception {
        this.impl.resetPeriodValuesWhenFirstFiscalPeriod(fiscalPeriod);
    }

    public void savePendingGLEntries(List<GeneralLedgerPendingEntry> glPendingEntries) {
        this.impl.savePendingGLEntries(glPendingEntries);
    }

    public Map<Long, KualiDecimal> getPrimaryDepreciationBaseAmountForSV() {
        return this.impl.getPrimaryDepreciationBaseAmountForSV();
    }

    public List<String> getAssetPaymentsStr() {
        return this.assetPaymentsStr;
    }

    public void setAssetPaymentsStr(List<String> assetPaymentsStr) {
        this.assetPaymentsStr = assetPaymentsStr;
    }

    public DepreciationBatchDao getImpl() {
        return this.impl;
    }

    public void setImpl(DepreciationBatchDao impl) {
        this.impl = impl;
    }

    public Object[] getAssetAndPaymentCount(Integer fiscalYear, Integer fiscalMonth, Calendar depreciationDate, boolean includePending) {
        return this.impl.getAssetAndPaymentCount(fiscalYear, fiscalMonth, depreciationDate, includePending);
    }

    public Object[] getFederallyOwnedAssetAndPaymentCount(Integer fiscalYear, Integer fiscalMonth, Calendar depreciationDate) {
        return this.impl.getFederallyOwnedAssetAndPaymentCount(fiscalYear, fiscalMonth, depreciationDate);
    }

    public Integer getRetireDocLockedAssetCount() {
        return this.impl.getRetireDocLockedAssetCount();
    }

    public Integer getTransferDocLockedAssetCount() {
        return this.impl.getTransferDocLockedAssetCount();
    }

    public Set<Long> getLockedAssets() {
        return this.impl.getLockedAssets();
    }

    public List<Map<String, Object>> getAssetsByDepreciationConvention(Date lastFiscalYearDate, List<String> movableEquipmentObjectSubTypes, String depreciationConventionCd) {
        return null;
    }

    public void updateAssetInServiceAndDepreciationDate(List<String> selectedAssets, Date inServiceDate, Date depreciationDate) {
    }

    public Set<Long> getAssetsWithNoDepreciation() {
        return null;
    }

    public Set<Long> getTransferDocPendingAssets() {
        return null;
    }
}

