/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;

import java.util.LinkedHashMap;

/**
 * Asset Transaction Type Business Object.
 */
public class AssetLock extends PersistableBusinessObjectBase {

    private String documentNumber;
    private Long capitalAssetNumber;
    private String lockingInformation;
    private String documentTypeName;

    /**
     * Default constructor.
     */
    public AssetLock() {

    }

    public AssetLock(String documentNumber, Long capitalAssetNumber, String lockingInformation, String documentType) {
        this.documentNumber = documentNumber;
        this.capitalAssetNumber = capitalAssetNumber;
        this.lockingInformation = lockingInformation;
        this.documentTypeName = documentType;
    }

    /**
     * @see org.kuali.rice.krad.bo.BusinessObjectBase#toStringMapper()
     */
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap m = new LinkedHashMap();
        m.put("documentNumber", this.documentNumber);
        m.put("capitalAssetNumber", this.capitalAssetNumber);
        m.put("lockingInformation", this.lockingInformation);
        return m;
    }

    /**
     * Gets the documentNumber attribute.
     *
     * @return Returns the documentNumber.
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /**
     * Sets the documentNumber attribute value.
     *
     * @param documentNumber The documentNumber to set.
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /**
     * Gets the capitalAssetNumber attribute.
     *
     * @return Returns the capitalAssetNumber.
     */
    public Long getCapitalAssetNumber() {
        return capitalAssetNumber;
    }

    /**
     * Sets the capitalAssetNumber attribute value.
     *
     * @param capitalAssetNumber The capitalAssetNumber to set.
     */
    public void setCapitalAssetNumber(Long capitalAssetNumber) {
        this.capitalAssetNumber = capitalAssetNumber;
    }

    /**
     * Gets the lockingInformation attribute.
     *
     * @return Returns the lockingInformation.
     */
    public String getLockingInformation() {
        return lockingInformation;
    }

    /**
     * Sets the lockingInformation attribute value.
     *
     * @param lockingInformation The lockingInformation to set.
     */
    public void setLockingInformation(String lockingInformation) {
        this.lockingInformation = lockingInformation;
    }

    /**
     * Gets the documentTypeName attribute.
     *
     * @return Returns the documentTypeName.
     */
    public String getDocumentTypeName() {
        return documentTypeName;
    }

    /**
     * Sets the documentTypeName attribute value.
     *
     * @param documentTypeName The documentTypeName to set.
     */
    public void setDocumentTypeName(String documentTypeName) {
        this.documentTypeName = documentTypeName;
    }

}
