/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectSubType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.FiscalYearBasedBusinessObject;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

import java.util.List;

public class AssetObjectCode extends PersistableBusinessObjectBase implements MutableInactivatable, FiscalYearBasedBusinessObject {

    public static final String CACHE_NAME = KFSConstants.APPLICATION_NAMESPACE_CODE + "/" + "AssetObjectCode";

    protected Integer universityFiscalYear;
    protected String chartOfAccountsCode;
    protected String financialObjectSubTypeCode;
    protected String capitalizationFinancialObjectCode;
    protected String accumulatedDepreciationFinancialObjectCode;
    protected String depreciationExpenseFinancialObjectCode;
    protected boolean active;

    protected transient SystemOptions universityFiscal;
    protected ObjectCode accumulatedDepreciationFinancialObject;
    protected ObjectCode capitalizationFinancialObject;
    protected ObjectCode depreciationExpenseFinancialObject;
    protected List<ObjectCode> objectCode;
    protected Chart chartOfAccounts;
    protected ObjectSubType financialObjectSubType;

    public AssetObjectCode() {

    }

    /**
     * Gets the universityFiscalYear attribute.
     *
     * @return Returns the universityFiscalYear
     */
    public Integer getUniversityFiscalYear() {
        return universityFiscalYear;
    }

    /**
     * Sets the universityFiscalYear attribute.
     *
     * @param universityFiscalYear The universityFiscalYear to set.
     */
    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }


    /**
     * Gets the chartOfAccountsCode attribute.
     *
     * @return Returns the chartOfAccountsCode
     */
    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    /**
     * Sets the chartOfAccountsCode attribute.
     *
     * @param chartOfAccountsCode The chartOfAccountsCode to set.
     */
    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }


    /**
     * Gets the financialObjectSubTypeCode attribute.
     *
     * @return Returns the financialObjectSubTypeCode
     */
    public String getFinancialObjectSubTypeCode() {
        return financialObjectSubTypeCode;
    }

    /**
     * Sets the financialObjectSubTypeCode attribute.
     *
     * @param financialObjectSubTypeCode The financialObjectSubTypeCode to set.
     */
    public void setFinancialObjectSubTypeCode(String financialObjectSubTypeCode) {
        this.financialObjectSubTypeCode = financialObjectSubTypeCode;
    }


    /**
     * Gets the capitalizationFinancialObjectCode attribute.
     *
     * @return Returns the capitalizationFinancialObjectCode
     */
    public String getCapitalizationFinancialObjectCode() {
        return capitalizationFinancialObjectCode;
    }

    /**
     * Sets the capitalizationFinancialObjectCode attribute.
     *
     * @param capitalizationFinancialObjectCode The capitalizationFinancialObjectCode to set.
     */
    public void setCapitalizationFinancialObjectCode(String capitalizationFinancialObjectCode) {
        this.capitalizationFinancialObjectCode = capitalizationFinancialObjectCode;
    }


    /**
     * Gets the accumulatedDepreciationFinancialObjectCode attribute.
     *
     * @return Returns the accumulatedDepreciationFinancialObjectCode
     */
    public String getAccumulatedDepreciationFinancialObjectCode() {
        return accumulatedDepreciationFinancialObjectCode;
    }

    /**
     * Sets the accumulatedDepreciationFinancialObjectCode attribute.
     *
     * @param accumulatedDepreciationFinancialObjectCode The accumulatedDepreciationFinancialObjectCode to set.
     */
    public void setAccumulatedDepreciationFinancialObjectCode(String accumulatedDepreciationFinancialObjectCode) {
        this.accumulatedDepreciationFinancialObjectCode = accumulatedDepreciationFinancialObjectCode;
    }


    /**
     * Gets the depreciationExpenseFinancialObjectCode attribute.
     *
     * @return Returns the depreciationExpenseFinancialObjectCode
     */
    public String getDepreciationExpenseFinancialObjectCode() {
        return depreciationExpenseFinancialObjectCode;
    }

    /**
     * Sets the depreciationExpenseFinancialObjectCode attribute.
     *
     * @param depreciationExpenseFinancialObjectCode The depreciationExpenseFinancialObjectCode to set.
     */
    public void setDepreciationExpenseFinancialObjectCode(String depreciationExpenseFinancialObjectCode) {
        this.depreciationExpenseFinancialObjectCode = depreciationExpenseFinancialObjectCode;
    }


    /**
     * Gets the accumulatedDepreciationFinancialObject attribute.
     *
     * @return Returns the accumulatedDepreciationFinancialObject
     */
    public ObjectCode getAccumulatedDepreciationFinancialObject() {
        return accumulatedDepreciationFinancialObject;
    }

    /**
     * Sets the accumulatedDepreciationFinancialObject attribute.
     *
     * @param accumulatedDepreciationFinancialObject The accumulatedDepreciationFinancialObject to set.
     * @deprecated
     */
    public void setAccumulatedDepreciationFinancialObject(ObjectCode accumulatedDepreciationFinancialObject) {
        this.accumulatedDepreciationFinancialObject = accumulatedDepreciationFinancialObject;
    }

    /**
     * Gets the capitalizationFinancialObject attribute.
     *
     * @return Returns the capitalizationFinancialObject
     */
    public ObjectCode getCapitalizationFinancialObject() {
        return capitalizationFinancialObject;
    }

    /**
     * Sets the capitalizationFinancialObject attribute.
     *
     * @param capitalizationFinancialObject The capitalizationFinancialObject to set.
     * @deprecated
     */
    public void setCapitalizationFinancialObject(ObjectCode capitalizationFinancialObject) {
        this.capitalizationFinancialObject = capitalizationFinancialObject;
    }

    /**
     * Gets the depreciationExpenseFinancialObject attribute.
     *
     * @return Returns the depreciationExpenseFinancialObject
     */
    public ObjectCode getDepreciationExpenseFinancialObject() {
        return depreciationExpenseFinancialObject;
    }

    /**
     * Sets the depreciationExpenseFinancialObject attribute.
     *
     * @param depreciationExpenseFinancialObject The depreciationExpenseFinancialObject to set.
     * @deprecated
     */
    public void setDepreciationExpenseFinancialObject(ObjectCode depreciationExpenseFinancialObject) {
        this.depreciationExpenseFinancialObject = depreciationExpenseFinancialObject;
    }

    /**
     * Gets the chartOfAccounts attribute.
     *
     * @return Returns the chartOfAccounts
     */
    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    /**
     * Sets the chartOfAccounts attribute.
     *
     * @param chartOfAccounts The chartOfAccounts to set.
     * @deprecated
     */
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Gets the financialObjectSubType attribute.
     *
     * @return Returns the financialObjectSubType.
     */
    public ObjectSubType getFinancialObjectSubType() {
        return financialObjectSubType;
    }

    /**
     * Sets the financialObjectSubType attribute value.
     *
     * @param financialObjectSubType The financialObjectSubType to set.
     * @deprecated
     */
    public void setFinancialObjectSubType(ObjectSubType financialObjectSubType) {
        this.financialObjectSubType = financialObjectSubType;
    }

    /**
     * Gets the active attribute.
     *
     * @return Returns the active
     */
    public boolean isActive() {
        return active;
    }

    /**
     * Sets the active attribute.
     *
     * @param active The active to set.
     */
    public void setActive(boolean active) {
        this.active = active;
    }

    /**
     * Gets the universityFiscal attribute.
     *
     * @return Returns the universityFiscal.
     */
    public SystemOptions getUniversityFiscal() {
        return universityFiscal;
    }

    /**
     * Sets the universityFiscal attribute value.
     *
     * @param universityFiscal The universityFiscal to set.
     */
    public void setUniversityFiscal(SystemOptions universityFiscal) {
        this.universityFiscal = universityFiscal;
    }

    public List<ObjectCode> getObjectCode() {
        return objectCode;
    }

    public void setObjectCode(List<ObjectCode> objectCode) {
        this.objectCode = objectCode;
    }

}
