/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.service.AssetBarcodeInventoryLoadService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.web.struts.AssetBarCodeInventoryInputFileForm;
import org.kuali.kfs.module.cam.fixture.BarcodeInventoryServiceFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;

@ConfigureContext(session=UserNameFixture.bomiddle)
public class AssetBarcodeInventoryLoadServiceTest
extends KualiTestBase {
    private static Logger LOG = LogManager.getLogger(AssetBarcodeInventoryLoadServiceTest.class);
    private DateTimeService dateTimeService;
    private AssetBarcodeInventoryLoadService assetBarcodeInventoryLoadService;
    private BusinessObjectService businessObjectService;
    private static final String BARCODE = "barcode";
    private static final String ERROR = "error";
    private static final String VALID = "valid";
    private static final String FORMAT = "format";
    private static final String INVALID_FORMAT_MSG = "Invalid file format";
    private static final String FILE_NOT_PROCESSED_MSG = "File was not processed successfully.";

    protected void setUp() throws Exception {
        super.setUp();
        this.assetBarcodeInventoryLoadService = (AssetBarcodeInventoryLoadService)SpringContext.getBean(AssetBarcodeInventoryLoadService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    public void testIsFileFormatValid() {
        File[] listOfFiles = this.getFiles(false);
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile() || listOfFiles[i].length() <= 0L) continue;
            LOG.info("*** testIsFileFormatValid() - Running test on file " + listOfFiles[i].getName());
            if (listOfFiles[i].getName().indexOf(ERROR) != -1 && listOfFiles[i].getName().indexOf(FORMAT) != -1) {
                AssetBarcodeInventoryLoadServiceTest.assertFalse((String)INVALID_FORMAT_MSG, (boolean)this.assetBarcodeInventoryLoadService.isFileFormatValid(listOfFiles[i]));
                continue;
            }
            AssetBarcodeInventoryLoadServiceTest.assertTrue((String)INVALID_FORMAT_MSG, (boolean)this.assetBarcodeInventoryLoadService.isFileFormatValid(listOfFiles[i]));
        }
    }

    public void testProcessFile() {
        File[] filesToProcess;
        AssetBarCodeInventoryInputFileForm form = new AssetBarCodeInventoryInputFileForm();
        for (File file : filesToProcess = this.getFiles(true)) {
            LOG.info("*** testProcessFile() - Running test on file " + file.getName());
            try {
                this.assetBarcodeInventoryLoadService.processFile(file, form);
            }
            catch (IllegalArgumentException e) {
                Throwable origin = e;
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    origin = cause;
                }
                AssetBarcodeInventoryLoadServiceTest.assertTrue((boolean)ValidationException.class.isAssignableFrom(origin.getClass()));
            }
        }
    }

    private File[] getFiles(boolean onlyValid) {
        File[] listOfFiles;
        try {
            Class<AssetBarcodeInventoryLoadServiceTest> THIS_CLASS = AssetBarcodeInventoryLoadServiceTest.class;
            String childPath = THIS_CLASS.getPackage().getName().replace('.', '/');
            File directory = new File(new File(THIS_CLASS.getProtectionDomain().getCodeSource().getLocation().toURI()), childPath);
            listOfFiles = !onlyValid ? directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".csv") && name.startsWith(AssetBarcodeInventoryLoadServiceTest.BARCODE) && name.indexOf(AssetBarcodeInventoryLoadServiceTest.ERROR) != -1 || name.indexOf(AssetBarcodeInventoryLoadServiceTest.VALID) != -1;
                }
            }) : directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".csv") && name.startsWith(AssetBarcodeInventoryLoadServiceTest.BARCODE) && name.indexOf(AssetBarcodeInventoryLoadServiceTest.VALID) != -1;
                }
            });
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        return listOfFiles;
    }

    public void testUpdateAssetInformation() {
        List<BarcodeInventoryErrorDetail> barcodeInventoryErrorDetails = BarcodeInventoryServiceFixture.DATA.getBarcodeInventoryDetail();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        for (int row = 0; row < barcodeInventoryErrorDetails.size(); ++row) {
            BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = barcodeInventoryErrorDetails.get(row);
            this.assetBarcodeInventoryLoadService.updateAssetInformation(barcodeInventoryErrorDetail, false);
            fieldValues.put("campusTagNumber", barcodeInventoryErrorDetail.getAssetTagNumber());
            Asset asset = (Asset)((List)this.businessObjectService.findMatching(Asset.class, fieldValues)).get(0);
            AssetBarcodeInventoryLoadServiceTest.assertTrue((String)"Error on data", (asset.getInventoryScannedCode().equals(barcodeInventoryErrorDetail.isUploadScanIndicator() ? "1" : "0") && asset.getBuildingCode().equals(barcodeInventoryErrorDetail.getBuildingCode()) && asset.getBuildingRoomNumber().equals(barcodeInventoryErrorDetail.getBuildingRoomNumber()) && asset.getBuildingSubRoomNumber().equals(barcodeInventoryErrorDetail.getBuildingSubRoomNumber()) && asset.getCampusCode().equals(barcodeInventoryErrorDetail.getCampusCode()) && asset.getConditionCode().equals(barcodeInventoryErrorDetail.getAssetConditionCode()) ? 1 : 0) != 0);
        }
    }
}

