/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.module.cam.fixture.AssetPaymentServiceFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;

@ConfigureContext(session=UserNameFixture.bomiddle)
public class AssetPaymentServiceTest
extends KualiTestBase {
    private static Logger LOG = LogManager.getLogger(AssetPaymentServiceTest.class);
    private DateTimeService dateTimeService;
    private UniversityDateService universityDateService;
    private AssetPaymentService assetPaymentService;
    private BusinessObjectService businessObjectService;

    protected void setUp() throws Exception {
        super.setUp();
        this.assetPaymentService = (AssetPaymentService)SpringContext.getBean(AssetPaymentService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    public void testAdjustPaymentAmounts_params_false_false() throws Exception {
        AssetPayment assetPayment = AssetPaymentServiceFixture.PAYMENT1.newAssetPayment();
        this.assetPaymentService.adjustPaymentAmounts(assetPayment, false, false);
        AssetPaymentServiceTest.assertTrue((boolean)assetPayment.getAccountChargeAmount().isPositive());
        AssetPaymentServiceTest.assertTrue((boolean)assetPayment.getAccumulatedPrimaryDepreciationAmount().isPositive());
        AssetPaymentServiceTest.assertNotNull((Object)assetPayment.getPeriod1Depreciation1Amount());
        AssetPaymentServiceTest.assertNotNull((Object)assetPayment.getPeriod11Depreciation1Amount());
        AssetPaymentServiceTest.assertTrue((boolean)(assetPayment.getPeriod11Depreciation1Amount() instanceof KualiDecimal));
    }

    public void testAdjustPaymentAmounts_params_true_true() throws Exception {
        AssetPayment assetPayment = AssetPaymentServiceFixture.PAYMENT1.newAssetPayment();
        this.assetPaymentService.adjustPaymentAmounts(assetPayment, true, true);
        AssetPaymentServiceTest.assertTrue((boolean)assetPayment.getAccountChargeAmount().isNegative());
        AssetPaymentServiceTest.assertTrue((boolean)assetPayment.getAccumulatedPrimaryDepreciationAmount().isNegative());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod1Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod11Depreciation1Amount());
        AssetPaymentServiceTest.assertFalse((boolean)(assetPayment.getPeriod11Depreciation1Amount() instanceof KualiDecimal));
    }

    public void testAdjustPaymentAmounts_false_true() throws Exception {
        AssetPayment assetPayment = AssetPaymentServiceFixture.PAYMENT1.newAssetPayment();
        this.assetPaymentService.adjustPaymentAmounts(assetPayment, false, true);
        AssetPaymentServiceTest.assertTrue((boolean)assetPayment.getAccountChargeAmount().isPositive());
        AssetPaymentServiceTest.assertTrue((boolean)assetPayment.getAccumulatedPrimaryDepreciationAmount().isPositive());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod1Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod2Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod3Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod4Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod5Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod6Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod7Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod8Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod9Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod10Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod11Depreciation1Amount());
        AssetPaymentServiceTest.assertNull((Object)assetPayment.getPeriod12Depreciation1Amount());
    }

    public void testProcessApprovedAssetPayment() throws Exception {
        KualiDecimal calculatedAssetNewCost;
        Long capitalAssetNumber;
        AssetPaymentAssetDetail assetPaymentAssetDetail;
        int x;
        int detailRows = 0;
        int assetRows = 0;
        AssetPaymentDocument document = AssetPaymentServiceFixture.PAYMENT1.newAssetPaymentDocument();
        document.setDocumentHeader(this.getDocumentHeader());
        document.setAssetPaymentAllocationTypeCode("3");
        KualiDecimal totalDocument = new KualiDecimal(0);
        List assetPaymentAssetDetails = document.getAssetPaymentAssetDetail();
        List assetPaymentDetails = document.getSourceAccountingLines();
        for (AssetPaymentDetail assetPaymentDetail : assetPaymentDetails) {
            ++detailRows;
            totalDocument = (KualiDecimal)totalDocument.add((AbstractKualiDecimal)assetPaymentDetail.getAmount());
        }
        Double totalHistoricalAmount = new Double(0.0);
        HashMap<Long, Double> assets = new HashMap<Long, Double>();
        HashMap<Long, KualiDecimal> assetsNewCost = new HashMap<Long, KualiDecimal>();
        for (AssetPaymentAssetDetail assetPaymentAssetDetail2 : assetPaymentAssetDetails) {
            ++assetRows;
            assetPaymentAssetDetail2.refreshReferenceObject("asset");
            assets.put(assetPaymentAssetDetail2.getCapitalAssetNumber(), new Double(assetPaymentAssetDetail2.getAsset().getTotalCostAmount().toString()));
            assetPaymentAssetDetail2.setPreviousTotalCostAmount(assetPaymentAssetDetail2.getAsset().getTotalCostAmount());
            totalHistoricalAmount = totalHistoricalAmount + new Double(assetPaymentAssetDetail2.getAsset().getTotalCostAmount().toString());
            LOG.info("***Asset:" + assetPaymentAssetDetail2.getCapitalAssetNumber().toString() + " Previous Cost:" + assetPaymentAssetDetail2.getAsset().getTotalCostAmount());
        }
        LOG.info("***Saving Document:" + document.getDocumentHeader().getDocumentNumber());
        this.businessObjectService.save((PersistableBusinessObject)document);
        LOG.info("***Processing Document:" + document.getDocumentNumber());
        this.assetPaymentService.processApprovedAssetPayment(document);
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("documentNumber", document.getDocumentNumber());
        LOG.info("***Retrieving Document:" + document.getDocumentNumber());
        document = (AssetPaymentDocument)this.businessObjectService.findByPrimaryKey(AssetPaymentDocument.class, key);
        document.setAssetPaymentAllocationTypeCode("3");
        key = new HashMap();
        key.put("documentNumber", document.getDocumentNumber());
        List assetPayments = (List)this.businessObjectService.findMatching(AssetPayment.class, key);
        AssetPaymentServiceTest.assertEquals((int)assetPayments.size(), (int)(assetRows * detailRows));
        for (x = 0; x < document.getAssetPaymentAssetDetail().size(); ++x) {
            assetPaymentAssetDetail = (AssetPaymentAssetDetail)document.getAssetPaymentAssetDetail().get(x);
            assetPaymentAssetDetail.refreshReferenceObject("asset");
            capitalAssetNumber = assetPaymentAssetDetail.getAsset().getCapitalAssetNumber();
            key = new HashMap();
            key.put("capitalAssetNumber", capitalAssetNumber);
            key.put("documentNumber", document.getDocumentNumber());
            assetPayments = (List)this.businessObjectService.findMatching(AssetPayment.class, key);
            calculatedAssetNewCost = new KualiDecimal(((Double)assets.get(capitalAssetNumber)).doubleValue());
            Double previousTotalCostAmount = (Double)assets.get(capitalAssetNumber);
            Double percentage = previousTotalCostAmount / totalHistoricalAmount;
            for (int i = 0; i < document.getSourceAccountingLines().size(); ++i) {
                AssetPaymentDetail assetPaymentDetail = (AssetPaymentDetail)document.getSourceAccountingLines().get(i);
                Double paymentAmount = new Double(assetPaymentDetail.getAmount().toString());
                KualiDecimal amount = new KualiDecimal(paymentAmount * percentage);
                calculatedAssetNewCost = (KualiDecimal)calculatedAssetNewCost.add((AbstractKualiDecimal)amount);
                AssetPayment assetPayment = (AssetPayment)assetPayments.get(i);
                AssetPaymentServiceTest.assertEquals((String)assetPaymentDetail.getAccountNumber(), (String)assetPayment.getAccountNumber());
                AssetPaymentServiceTest.assertEquals((String)assetPaymentDetail.getChartOfAccountsCode(), (String)assetPayment.getChartOfAccountsCode());
                AssetPaymentServiceTest.assertEquals((String)assetPaymentDetail.getFinancialObjectCode(), (String)assetPayment.getFinancialObjectCode());
                AssetPaymentServiceTest.assertEquals((Object)amount, (Object)assetPayment.getAccountChargeAmount());
                AssetPaymentServiceTest.assertEquals((Object)assetPaymentDetail.getPostingYear(), (Object)assetPayment.getFinancialDocumentPostingYear());
                AssetPaymentServiceTest.assertEquals((String)assetPaymentDetail.getPostingPeriodCode(), (String)assetPayment.getFinancialDocumentPostingPeriodCode());
            }
            assetsNewCost.put(capitalAssetNumber, calculatedAssetNewCost);
        }
        for (x = 0; x < document.getAssetPaymentAssetDetail().size(); ++x) {
            assetPaymentAssetDetail = (AssetPaymentAssetDetail)document.getAssetPaymentAssetDetail().get(x);
            assetPaymentAssetDetail.refreshReferenceObject("asset");
            capitalAssetNumber = assetPaymentAssetDetail.getAsset().getCapitalAssetNumber();
            calculatedAssetNewCost = (KualiDecimal)assetsNewCost.get(capitalAssetNumber);
            AssetPaymentServiceTest.assertEquals((Object)calculatedAssetNewCost, (Object)assetPaymentAssetDetail.getAsset().getTotalCostAmount());
        }
    }

    public DocumentHeader getDocumentHeader() throws Exception {
        WorkflowDocument workflowDocument = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).createWorkflowDocument(((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(AssetPaymentDocument.class), GlobalVariables.getUserSession().getPerson());
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setWorkflowDocument(workflowDocument);
        documentHeader.setDocumentNumber(workflowDocument.getDocumentId());
        documentHeader.setFinancialDocumentStatusCode("A");
        documentHeader.setExplanation("New asset payment");
        documentHeader.setDocumentDescription("New asset payment");
        documentHeader.setFinancialDocumentTotalAmount(KualiDecimal.ZERO);
        return documentHeader;
    }

    public void testExtractPostedDatePeriod() throws Exception {
        Calendar currentDate = Calendar.getInstance();
        AssetPaymentDetail assetPaymentDetail = new AssetPaymentDetail();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        int currentYear = this.universityDateService.getCurrentFiscalYear();
        int testYear = this.universityDateService.getCurrentFiscalYear() + 1000;
        currentDate.setTime(dateFormat.parse(currentYear + "-01-01"));
        Date jsqlD = new Date(currentDate.getTime().getTime());
        assetPaymentDetail.setExpenditureFinancialDocumentPostedDate(jsqlD);
        AssetPaymentServiceTest.assertEquals((boolean)this.assetPaymentService.extractPostedDatePeriod(assetPaymentDetail), (boolean)true);
        currentDate.setTime(dateFormat.parse(testYear + "-01-01"));
        jsqlD = new Date(currentDate.getTime().getTime());
        assetPaymentDetail.setExpenditureFinancialDocumentPostedDate(jsqlD);
        AssetPaymentServiceTest.assertEquals((boolean)this.assetPaymentService.extractPostedDatePeriod(assetPaymentDetail), (boolean)false);
    }
}

