/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.CamsKeyConstants;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class AssetPaymentAllocationByAmountValidation extends GenericValidation {

    @Override
    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;

        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument) event.getDocument();

        if (!assetPaymentDocument.isCapitalAssetBuilderOriginIndicator() &&
            CamsPropertyConstants.AssetPaymentAllocation.ASSET_DISTRIBUTION_BY_AMOUNT_CODE.equals(assetPaymentDocument.getAssetPaymentAllocationTypeCode())) {
            valid &= validateNonZeroAssetByAmountAllocation(assetPaymentDocument);
        }

        return valid;
    }

    /**
     * If a user selects 0$ amount allocation, they shouldn't select amount allocation. That is even allocation
     *
     * @param assetPaymentDocument
     * @return
     */
    protected boolean validateNonZeroAssetByAmountAllocation(AssetPaymentDocument assetPaymentDocument) {
        boolean isZero = true;

        for (AssetPaymentAssetDetail apad : assetPaymentDocument.getAssetPaymentAssetDetail()) {
            isZero &= apad.getAllocatedUserValue().isZero();
        }

        if (isZero) {
            GlobalVariables.getMessageMap().putErrorForSectionId(CamsPropertyConstants.COMMON_ERROR_SECTION_ID, CamsKeyConstants.AssetPaymentAllocation.ERROR_NONE_ZERO_BY_AMOUNT);
            return false;
        }

        return true;
    }

}
