/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam;

import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.module.cam.PurApAccountLineGroupTest;
import org.kuali.kfs.module.cam.businessobject.GlAccountLineGroup;
import org.kuali.kfs.module.cam.businessobject.PurApAccountLineGroup;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccountRevision;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AccountLineGroupTest
extends KualiTestBase {
    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testEquals() throws Exception {
        GlAccountLineGroup first = this.createAccountLineGroup(2008, "BL", "BL002323", "--", "7000", "--------", "01", "1001", null, "D");
        GlAccountLineGroup second = this.createAccountLineGroup(2008, "BL", "BL002323", "------", "7000", null, "01", "1001", null, "C");
        PurApAccountLineGroup third = this.createPurApAccountLineGroup(2008, "BL", "BL002323", "---", "7000", null, "01", "1001", "----", new KualiDecimal(100), PaymentRequestAccountRevision.class);
        AccountLineGroupTest.assertTrue((boolean)first.equals((Object)first));
        AccountLineGroupTest.assertTrue((boolean)first.equals((Object)second));
        AccountLineGroupTest.assertTrue((boolean)second.equals((Object)first));
        AccountLineGroupTest.assertTrue((boolean)second.equals((Object)third));
        AccountLineGroupTest.assertTrue((boolean)third.equals((Object)second));
        AccountLineGroupTest.assertTrue((boolean)first.equals((Object)third));
        AccountLineGroupTest.assertTrue((boolean)third.equals((Object)first));
        first = this.createAccountLineGroup(2008, "BA", "BL002323", "--", "7000", null, "01", "1001", null, "C");
        second = this.createAccountLineGroup(2008, "BL", "BL002323", "--", "7000", null, "01", "1001", null, "D");
        third = this.createPurApAccountLineGroup(2008, "BA", "BL002323", "--", "7000", null, "01", "1001", null, new KualiDecimal(100), PaymentRequestAccountRevision.class);
        AccountLineGroupTest.assertFalse((boolean)first.equals((Object)second));
        AccountLineGroupTest.assertFalse((boolean)second.equals((Object)first));
        AccountLineGroupTest.assertFalse((boolean)second.equals((Object)third));
        AccountLineGroupTest.assertFalse((boolean)third.equals((Object)second));
        AccountLineGroupTest.assertTrue((boolean)first.equals((Object)third));
        AccountLineGroupTest.assertTrue((boolean)third.equals((Object)first));
        first = this.createAccountLineGroup(2008, "BA", "BL002323", "X", "7000", null, "01", "1001", null, "C");
        second = this.createAccountLineGroup(2008, "BA", "BL002323", "XXX", "7000", null, "01", "1001", null, "D");
        third = this.createPurApAccountLineGroup(2008, "BL", "BL002323", "X", "7001", null, "01", "1001", null, new KualiDecimal(100), PaymentRequestAccountRevision.class);
        AccountLineGroupTest.assertFalse((boolean)first.equals((Object)second));
        AccountLineGroupTest.assertFalse((boolean)second.equals((Object)first));
        AccountLineGroupTest.assertFalse((boolean)second.equals((Object)third));
        AccountLineGroupTest.assertFalse((boolean)third.equals((Object)second));
        AccountLineGroupTest.assertFalse((boolean)first.equals((Object)third));
        AccountLineGroupTest.assertFalse((boolean)third.equals((Object)first));
        AccountLineGroupTest.assertFalse((boolean)first.equals(null));
        AccountLineGroupTest.assertFalse((boolean)second.equals(null));
        AccountLineGroupTest.assertFalse((boolean)third.equals(null));
    }

    public void testHashcode() throws Exception {
        GlAccountLineGroup first = this.createAccountLineGroup(new Integer(2008), new String("BL"), "BL002323", "--", "7000", "12121", "01", "1001", "A", "C");
        GlAccountLineGroup second = this.createAccountLineGroup(2008, "BL", "BL002323", "--", new String("7000"), "12121", "01", "1001", "A", "C");
        GlAccountLineGroup third = this.createAccountLineGroup(2008, "BL", new String("BL002323"), "", "7000", "12121", "01", "1001", "A", "D");
        AccountLineGroupTest.assertEquals((int)first.hashCode(), (int)second.hashCode());
        AccountLineGroupTest.assertEquals((int)second.hashCode(), (int)third.hashCode());
        AccountLineGroupTest.assertEquals((int)first.hashCode(), (int)third.hashCode());
    }

    private GlAccountLineGroup createAccountLineGroup(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, String refDocNum, String dbtCrdtCode) {
        Entry entry = new Entry();
        entry.setUniversityFiscalYear(i);
        entry.setChartOfAccountsCode(chartCode);
        entry.setAccountNumber(acctNum);
        entry.setSubAccountNumber(subAcctNum);
        entry.setFinancialObjectCode(objCd);
        entry.setFinancialSubObjectCode(subObjCd);
        entry.setUniversityFiscalPeriodCode(fiscalPrd);
        entry.setDocumentNumber(docNum);
        entry.setReferenceFinancialDocumentNumber(refDocNum);
        entry.setTransactionDebitCreditCode(dbtCrdtCode);
        entry.setTransactionLedgerEntryAmount(KualiDecimal.ZERO);
        GlAccountLineGroup first = new GlAccountLineGroup(entry);
        return first;
    }

    private PurApAccountLineGroup createPurApAccountLineGroup(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, String refDocNum, KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entry = this.createEntry(i, chartCode, acctNum, subAcctNum, objCd, subObjCd, fiscalPrd, docNum, refDocNum, amount, clazz);
        PurApAccountLineGroupTest.PurApAccountLineGroupTestable first = new PurApAccountLineGroupTest.PurApAccountLineGroupTestable(entry, docNum, refDocNum);
        return first;
    }

    private PurApAccountingLineBase createEntry(Integer i, String chartCode, String acctNum, String subAcctNum, String objCd, String subObjCd, String fiscalPrd, String docNum, String refDocNum, KualiDecimal amount, Class<? extends PurApAccountingLineBase> clazz) {
        PurApAccountingLineBase entry = null;
        try {
            entry = clazz.newInstance();
        }
        catch (Exception e) {
            AccountLineGroupTest.fail((String)e.toString());
        }
        entry.setPostingYear(i);
        entry.setChartOfAccountsCode(chartCode);
        entry.setAccountNumber(acctNum);
        entry.setSubAccountNumber(subAcctNum);
        entry.setFinancialObjectCode(objCd);
        entry.setFinancialSubObjectCode(subObjCd);
        entry.setPostingPeriodCode(fiscalPrd);
        entry.setDocumentNumber(docNum);
        entry.setAmount(amount);
        return entry;
    }
}

