/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetOrganization;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.AssetTransferDocument;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetTransferService;
import org.kuali.kfs.module.cam.fixture.AssetTransferFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AssetTransferServiceTest
extends KualiTestBase {
    private UniversityDateService universityDateService;
    private AssetTransferService assetTransferService;

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        this.assetTransferService = (AssetTransferService)SpringContext.getBean(AssetTransferService.class);
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testCreateGLPostables_Success() {
        AssetTransferDocument document = this.buildTransferDocument(AssetTransferFixture.ACTIVE_CAPITAL_ASSET.newAsset(), true);
        this.assetTransferService.createGLPostables(document);
        List generalLedgerPostables = document.getGeneralLedgerPendingEntrySourceDetails();
        AssetTransferServiceTest.assertFalse((boolean)generalLedgerPostables.isEmpty());
        AssetTransferServiceTest.assertEquals((int)12, (int)generalLedgerPostables.size());
        Asset asset = document.getAsset();
        AssetPayment payment1 = (AssetPayment)asset.getAssetPayments().get(0);
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(0), asset.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccountChargeAmount(), "9520004", "Reverse asset cost", "8610");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(1), asset.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccumulatedPrimaryDepreciationAmount(), "9520004", "Reverse accumulated depreciation", "8910");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(2), asset.getOrganizationOwnerChartOfAccountsCode(), (KualiDecimal)payment1.getAccountChargeAmount().subtract((AbstractKualiDecimal)payment1.getAccumulatedPrimaryDepreciationAmount()), "9520004", "Reverse offset amount", "9899");
        AssetPayment payment2 = (AssetPayment)asset.getAssetPayments().get(1);
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(3), asset.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccountChargeAmount(), "9520004", "Reverse asset cost", "8610");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(4), asset.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccumulatedPrimaryDepreciationAmount(), "9520004", "Reverse accumulated depreciation", "8910");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(5), asset.getOrganizationOwnerChartOfAccountsCode(), (KualiDecimal)payment2.getAccountChargeAmount().subtract((AbstractKualiDecimal)payment2.getAccumulatedPrimaryDepreciationAmount()), "9520004", "Reverse offset amount", "9899");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(6), document.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccountChargeAmount(), "9567077", "Transfer asset cost", "8610");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(7), document.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccumulatedPrimaryDepreciationAmount(), "9567077", "Transfer accumulated depreciation", "8910");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(8), document.getOrganizationOwnerChartOfAccountsCode(), (KualiDecimal)payment1.getAccountChargeAmount().subtract((AbstractKualiDecimal)payment1.getAccumulatedPrimaryDepreciationAmount()), "9567077", "Transfer offset amount", "9899");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(9), document.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccountChargeAmount(), "9567077", "Transfer asset cost", "8610");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(10), document.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccumulatedPrimaryDepreciationAmount(), "9567077", "Transfer accumulated depreciation", "8910");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(11), document.getOrganizationOwnerChartOfAccountsCode(), (KualiDecimal)payment2.getAccountChargeAmount().subtract((AbstractKualiDecimal)payment2.getAccumulatedPrimaryDepreciationAmount()), "9567077", "Transfer offset amount", "9899");
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testCreateGLPostables_No_Offset() {
        AssetTransferDocument document = this.buildTransferDocumentWithoutOffset(AssetTransferFixture.ACTIVE_CAPITAL_ASSET.newAsset(), true);
        this.assetTransferService.createGLPostables(document);
        List generalLedgerPostables = document.getGeneralLedgerPendingEntrySourceDetails();
        AssetTransferServiceTest.assertFalse((boolean)generalLedgerPostables.isEmpty());
        AssetTransferServiceTest.assertEquals((int)8, (int)generalLedgerPostables.size());
        Asset asset = document.getAsset();
        AssetPayment payment1 = (AssetPayment)asset.getAssetPayments().get(0);
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(0), asset.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccountChargeAmount(), "9520004", "Reverse asset cost", "8610");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(1), asset.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccumulatedPrimaryDepreciationAmount(), "9520004", "Reverse accumulated depreciation", "8910");
        AssetPayment payment2 = (AssetPayment)asset.getAssetPayments().get(1);
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(2), asset.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccountChargeAmount(), "9520004", "Reverse asset cost", "8610");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(3), asset.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccumulatedPrimaryDepreciationAmount(), "9520004", "Reverse accumulated depreciation", "8910");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(4), document.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccountChargeAmount(), "9567077", "Transfer asset cost", "8610");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(5), document.getOrganizationOwnerChartOfAccountsCode(), payment1.getAccumulatedPrimaryDepreciationAmount(), "9567077", "Transfer accumulated depreciation", "8910");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(6), document.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccountChargeAmount(), "9567077", "Transfer asset cost", "8610");
        this.assertGLPostable((GeneralLedgerPendingEntrySourceDetail)generalLedgerPostables.get(7), document.getOrganizationOwnerChartOfAccountsCode(), payment2.getAccumulatedPrimaryDepreciationAmount(), "9567077", "Transfer accumulated depreciation", "8910");
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testCreateGLPostables_Non_CapitalAsset() {
        AssetTransferDocument document = this.buildTransferDocument(AssetTransferFixture.ACTIVE_NON_CAPITAL_ASSET.newAsset(), true);
        this.assetTransferService.createGLPostables(document);
        List generalLedgerPostables = document.getGeneralLedgerPendingEntrySourceDetails();
        AssetTransferServiceTest.assertTrue((boolean)generalLedgerPostables.isEmpty());
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testCreateGLPostables_No_Payments() {
        AssetTransferDocument document = this.buildTransferDocument(AssetTransferFixture.ACTIVE_CAPITAL_ASSET.newAsset(), false);
        this.assetTransferService.createGLPostables(document);
        List generalLedgerPostables = document.getGeneralLedgerPendingEntrySourceDetails();
        AssetTransferServiceTest.assertTrue((boolean)generalLedgerPostables.isEmpty());
    }

    private void assertGLPostable(GeneralLedgerPendingEntrySourceDetail glPostable, String chartOfAccountsCode, KualiDecimal amount, String plantAccount, String financialLineDesc, String financialObjectCode) {
        AssetTransferServiceTest.assertEquals((String)plantAccount, (String)glPostable.getAccountNumber());
        AssetTransferServiceTest.assertEquals((Object)amount, (Object)glPostable.getAmount());
        AssetTransferServiceTest.assertEquals((String)"AC", (String)glPostable.getBalanceTypeCode());
        AssetTransferServiceTest.assertEquals((String)chartOfAccountsCode, (String)glPostable.getChartOfAccountsCode());
        AssetTransferServiceTest.assertEquals((String)financialLineDesc, (String)glPostable.getFinancialDocumentLineDescription());
        AssetTransferServiceTest.assertEquals((String)financialObjectCode, (String)glPostable.getFinancialObjectCode());
        AssetTransferServiceTest.assertEquals((Object)this.universityDateService.getCurrentFiscalYear(), (Object)glPostable.getPostingYear());
        AssetTransferServiceTest.assertNull((Object)glPostable.getOrganizationReferenceId());
        AssetTransferServiceTest.assertNull((Object)glPostable.getProjectCode());
        AssetTransferServiceTest.assertNull((Object)glPostable.getReferenceNumber());
        AssetTransferServiceTest.assertNull((Object)glPostable.getReferenceOriginCode());
        AssetTransferServiceTest.assertNull((Object)glPostable.getReferenceTypeCode());
    }

    private AssetTransferDocument buildTransferDocument(Asset asset, boolean addPayments) {
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        AssetTransferDocument document = AssetTransferFixture.ASSET_TRANSFER.newAssetTransferDocument();
        asset.setCapitalAssetNumber(null);
        asset.setCapitalAssetTypeCode("665");
        boService.save((PersistableBusinessObject)asset);
        if (addPayments) {
            AssetPayment payment1 = AssetTransferFixture.PAYMENT1_WITH_OFFSET.newAssetPayment();
            AssetPayment payment2 = AssetTransferFixture.PAYMENT2_WITH_OFFSET.newAssetPayment();
            payment1.setCapitalAssetNumber(asset.getCapitalAssetNumber());
            payment1.setPaymentSequenceNumber(Integer.valueOf(1));
            payment2.setCapitalAssetNumber(asset.getCapitalAssetNumber());
            payment2.setPaymentSequenceNumber(Integer.valueOf(2));
            boService.save((PersistableBusinessObject)payment1);
            boService.save((PersistableBusinessObject)payment2);
            payment1.refresh();
            payment2.refresh();
            asset.getAssetPayments().add(payment1);
            asset.getAssetPayments().add(payment2);
        }
        document.setAsset(asset);
        document.setCapitalAssetNumber(asset.getCapitalAssetNumber());
        return document;
    }

    private AssetTransferDocument buildTransferDocumentWithoutOffset(Asset asset, boolean addPayments) {
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        AssetTransferDocument document = AssetTransferFixture.ASSET_TRANSFER.newAssetTransferDocument();
        asset.setCapitalAssetNumber(null);
        asset.setCapitalAssetTypeCode("665");
        boService.save((PersistableBusinessObject)asset);
        if (addPayments) {
            AssetPayment payment1 = AssetTransferFixture.PAYMENT3_WITHOUT_OFFSET.newAssetPayment();
            AssetPayment payment2 = AssetTransferFixture.PAYMENT4_WITHOUT_OFFSET.newAssetPayment();
            payment1.setCapitalAssetNumber(asset.getCapitalAssetNumber());
            payment1.setPaymentSequenceNumber(Integer.valueOf(1));
            payment2.setCapitalAssetNumber(asset.getCapitalAssetNumber());
            payment2.setPaymentSequenceNumber(Integer.valueOf(2));
            boService.save((PersistableBusinessObject)payment1);
            boService.save((PersistableBusinessObject)payment2);
            payment1.refresh();
            payment2.refresh();
            asset.getAssetPayments().add(payment1);
            asset.getAssetPayments().add(payment2);
        }
        document.setAsset(asset);
        document.setCapitalAssetNumber(asset.getCapitalAssetNumber());
        return document;
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testSaveApprovedChanges() {
        AssetTransferDocument document = this.buildTransferDocument(AssetTransferFixture.ACTIVE_CAPITAL_ASSET.newAsset(), true);
        this.assetTransferService.saveApprovedChanges(document);
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        Asset asset = document.getAsset();
        asset = (Asset)boService.retrieve((PersistableBusinessObject)asset);
        asset.refreshReferenceObject("assetPayments");
        AssetTransferServiceTest.assertNotNull((Object)asset);
        AssetTransferServiceTest.assertEquals((String)document.getOrganizationOwnerChartOfAccountsCode(), (String)asset.getOrganizationOwnerChartOfAccountsCode());
        AssetTransferServiceTest.assertEquals((String)document.getOrganizationOwnerAccountNumber(), (String)asset.getOrganizationOwnerAccountNumber());
        AssetTransferServiceTest.assertEquals((String)document.getCampusCode(), (String)asset.getCampusCode());
        AssetTransferServiceTest.assertEquals((String)document.getBuildingCode(), (String)asset.getBuildingCode());
        AssetTransferServiceTest.assertEquals((String)document.getBuildingRoomNumber(), (String)asset.getBuildingRoomNumber());
        AssetTransferServiceTest.assertEquals((String)document.getBuildingSubRoomNumber(), (String)asset.getBuildingSubRoomNumber());
        AssetTransferServiceTest.assertTrue((boolean)DateUtils.isSameDay((Date)new Date(), (Date)asset.getLastInventoryDate()));
        List assetPayments = asset.getAssetPayments();
        Collections.sort(assetPayments, new Comparator<AssetPayment>(){

            @Override
            public int compare(AssetPayment o1, AssetPayment o2) {
                return o1.getPaymentSequenceNumber().compareTo(o2.getPaymentSequenceNumber());
            }
        });
        AssetTransferServiceTest.assertEquals((int)6, (int)assetPayments.size());
        AssetPayment testDataPayment = AssetTransferFixture.PAYMENT1_WITH_OFFSET.newAssetPayment();
        AssetPayment assetPayment1 = (AssetPayment)assetPayments.get(0);
        this.assertOriginalPayment(testDataPayment, assetPayment1);
        testDataPayment = AssetTransferFixture.PAYMENT2_WITH_OFFSET.newAssetPayment();
        AssetPayment assetPayment2 = (AssetPayment)assetPayments.get(1);
        this.assertOriginalPayment(testDataPayment, assetPayment2);
        testDataPayment = AssetTransferFixture.PAYMENT1_WITH_OFFSET.newAssetPayment();
        AssetPayment offsetPayment1 = (AssetPayment)assetPayments.get(2);
        this.assertOffsetPayment(testDataPayment, offsetPayment1);
        testDataPayment = AssetTransferFixture.PAYMENT2_WITH_OFFSET.newAssetPayment();
        AssetPayment offsetPayment2 = (AssetPayment)assetPayments.get(3);
        this.assertOffsetPayment(testDataPayment, offsetPayment2);
        testDataPayment = AssetTransferFixture.PAYMENT1_WITH_OFFSET.newAssetPayment();
        AssetPayment newPayment1 = (AssetPayment)assetPayments.get(4);
        this.assertNewPayment(document, testDataPayment, newPayment1);
        testDataPayment = AssetTransferFixture.PAYMENT2_WITH_OFFSET.newAssetPayment();
        AssetPayment newPayment2 = (AssetPayment)assetPayments.get(5);
        this.assertNewPayment(document, testDataPayment, newPayment2);
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testSaveApprovedChanges_Offcampus() {
        AssetTransferDocument document = this.buildTransferDocument(AssetTransferFixture.ACTIVE_CAPITAL_ASSET.newAsset(), true);
        document.setOffCampusAddress("4700 S HAGADORN");
        document.setOffCampusCityName("E LANSING");
        document.setOffCampusStateCode("MI");
        document.setOffCampusZipCode("48823");
        document.setCampusCode(null);
        document.setBuildingCode(null);
        document.setBuildingRoomNumber(null);
        document.setBuildingSubRoomNumber(null);
        this.assetTransferService.saveApprovedChanges(document);
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        Asset asset = document.getAsset();
        asset = (Asset)boService.retrieve((PersistableBusinessObject)asset);
        asset.refreshReferenceObject("assetLocations");
        ((AssetLocationService)SpringContext.getBean(AssetLocationService.class)).setOffCampusLocation(asset);
        AssetTransferServiceTest.assertNotNull((Object)asset);
        AssetTransferServiceTest.assertEquals((String)document.getOrganizationOwnerChartOfAccountsCode(), (String)asset.getOrganizationOwnerChartOfAccountsCode());
        AssetTransferServiceTest.assertEquals((String)document.getOrganizationOwnerAccountNumber(), (String)asset.getOrganizationOwnerAccountNumber());
        AssetTransferServiceTest.assertEquals((String)document.getCampusCode(), (String)asset.getCampusCode());
        AssetTransferServiceTest.assertTrue((boolean)DateUtils.isSameDay((Date)new Date(), (Date)asset.getLastInventoryDate()));
        AssetLocation offCampusLocation = asset.getOffCampusLocation();
        AssetTransferServiceTest.assertNotNull((Object)offCampusLocation);
        AssetTransferServiceTest.assertEquals((String)"4700 S HAGADORN", (String)offCampusLocation.getAssetLocationStreetAddress());
        AssetTransferServiceTest.assertEquals((String)"E LANSING", (String)offCampusLocation.getAssetLocationCityName());
        AssetTransferServiceTest.assertEquals((String)"MI", (String)offCampusLocation.getAssetLocationStateCode());
        AssetTransferServiceTest.assertEquals((String)"48823", (String)offCampusLocation.getAssetLocationZipCode());
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    public void testSaveApprovedChanges_AssetOrgInfo() {
        AssetTransferDocument document = this.buildTransferDocument(AssetTransferFixture.ACTIVE_CAPITAL_ASSET.newAsset(), true);
        document.setOrganizationTagNumber("TEL");
        document.setOrganizationText("TEXT");
        this.assetTransferService.saveApprovedChanges(document);
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        Asset asset = document.getAsset();
        asset = (Asset)boService.retrieve((PersistableBusinessObject)asset);
        asset.refreshReferenceObject("assetOrganization");
        AssetOrganization assetOrganization = asset.getAssetOrganization();
        AssetTransferServiceTest.assertNotNull((Object)assetOrganization);
        AssetTransferServiceTest.assertEquals((String)"TEL", (String)assetOrganization.getOrganizationTagNumber());
        AssetTransferServiceTest.assertEquals((String)"TEXT", (String)assetOrganization.getOrganizationText());
    }

    private void assertNewPayment(AssetTransferDocument document, AssetPayment referencePayment, AssetPayment newPayment) {
        AssetTransferServiceTest.assertEquals((String)document.getOrganizationOwnerAccountNumber(), (String)newPayment.getAccountNumber());
        AssetTransferServiceTest.assertEquals((Object)referencePayment.getAccountChargeAmount(), (Object)newPayment.getAccountChargeAmount());
        AssetTransferServiceTest.assertEquals((Object)referencePayment.getAccumulatedPrimaryDepreciationAmount(), (Object)newPayment.getAccumulatedPrimaryDepreciationAmount());
        AssetTransferServiceTest.assertEquals(null, (Object)newPayment.getPeriod1Depreciation1Amount());
        AssetTransferServiceTest.assertEquals((String)"N", (String)newPayment.getTransferPaymentCode());
    }

    private void assertOriginalPayment(AssetPayment referencePayment, AssetPayment assetOriginalPayment) {
        AssetTransferServiceTest.assertEquals((String)referencePayment.getAccountNumber(), (String)assetOriginalPayment.getAccountNumber());
        AssetTransferServiceTest.assertEquals((Object)referencePayment.getAccountChargeAmount(), (Object)assetOriginalPayment.getAccountChargeAmount());
        AssetTransferServiceTest.assertEquals((Object)referencePayment.getAccumulatedPrimaryDepreciationAmount(), (Object)assetOriginalPayment.getAccumulatedPrimaryDepreciationAmount());
        AssetTransferServiceTest.assertEquals((Object)referencePayment.getPeriod1Depreciation1Amount(), (Object)assetOriginalPayment.getPeriod1Depreciation1Amount());
        AssetTransferServiceTest.assertEquals((String)"Y", (String)assetOriginalPayment.getTransferPaymentCode());
    }

    private void assertOffsetPayment(AssetPayment referencePayment, AssetPayment assetOffsetPayment) {
        AssetTransferServiceTest.assertEquals((String)referencePayment.getAccountNumber(), (String)assetOffsetPayment.getAccountNumber());
        KualiDecimal negative = new KualiDecimal(-1);
        AssetTransferServiceTest.assertEquals((Object)referencePayment.getAccountChargeAmount().multiply((AbstractKualiDecimal)negative), (Object)assetOffsetPayment.getAccountChargeAmount());
        AssetTransferServiceTest.assertEquals((Object)referencePayment.getAccumulatedPrimaryDepreciationAmount().multiply((AbstractKualiDecimal)negative), (Object)assetOffsetPayment.getAccumulatedPrimaryDepreciationAmount());
        AssetTransferServiceTest.assertEquals(null, (Object)assetOffsetPayment.getPeriod1Depreciation1Amount());
        AssetTransferServiceTest.assertEquals((String)"Y", (String)assetOffsetPayment.getTransferPaymentCode());
    }
}

