/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.batch.service.impl.AssetBarcodeInventoryLoadServiceImpl;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.BarcodeInventoryErrorDetail;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class AssetBarcodeInventoryLoadServiceImplTest {
    @Mock
    private AssetService assetSvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private DateTimeService dateTimeSvcMock;
    private AssetBarcodeInventoryLoadServiceImpl cut;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new AssetBarcodeInventoryLoadServiceImpl();
        this.cut.setAssetService(this.assetSvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setDateTimeService(this.dateTimeSvcMock);
    }

    @Test
    public void updateAssetInformation_True() {
        BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = new BarcodeInventoryErrorDetail();
        barcodeInventoryErrorDetail.setAssetTagNumber("IU025557");
        Mockito.when((Object)this.assetSvcMock.findActiveAssetsMatchingTagNumber("IU025557")).thenReturn(this.getAssets());
        Mockito.when((Object)this.boServiceMock.save((PersistableBusinessObject)ArgumentMatchers.any(Asset.class))).thenReturn((Object)new Asset());
        this.cut.updateAssetInformation(barcodeInventoryErrorDetail, true);
        ((AssetService)Mockito.verify((Object)this.assetSvcMock, (VerificationMode)Mockito.times((int)1))).findActiveAssetsMatchingTagNumber("IU025557");
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock, (VerificationMode)Mockito.times((int)1))).save((PersistableBusinessObject)ArgumentMatchers.any(Asset.class));
    }

    @Test
    public void updateAssetInformation_False() {
        BarcodeInventoryErrorDetail barcodeInventoryErrorDetail = new BarcodeInventoryErrorDetail();
        barcodeInventoryErrorDetail.setAssetTagNumber("IU025557");
        Mockito.when((Object)this.assetSvcMock.findActiveAssetsMatchingTagNumber("IU025557")).thenReturn(this.getAssets());
        Mockito.when((Object)this.boServiceMock.save((PersistableBusinessObject)ArgumentMatchers.any(Asset.class))).thenReturn((Object)new Asset());
        Date jud = new Date();
        java.sql.Date jsd = new java.sql.Date(jud.getTime());
        Mockito.when((Object)this.dateTimeSvcMock.getCurrentSqlDate()).thenReturn((Object)jsd);
        this.cut.updateAssetInformation(barcodeInventoryErrorDetail, false);
        ((AssetService)Mockito.verify((Object)this.assetSvcMock, (VerificationMode)Mockito.times((int)1))).findActiveAssetsMatchingTagNumber("IU025557");
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock, (VerificationMode)Mockito.times((int)1))).save((PersistableBusinessObject)ArgumentMatchers.any(Asset.class));
    }

    private List<Asset> getAssets() {
        Asset asset = new Asset();
        return Collections.singletonList(asset);
    }
}

