/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableActionHistory;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableItemAsset;
import org.kuali.kfs.module.cam.businessobject.PurchasingAccountsPayableLineAssetAccount;
import org.kuali.kfs.module.cam.document.service.PurApLineService;
import org.kuali.kfs.module.cam.fixture.PurchasingAccountsPayableDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PurApLineServiceTest
extends KualiTestBase {
    private PurApLineService purApLineService;
    private List<PurchasingAccountsPayableDocument> purApDocuments;
    private PurchasingAccountsPayableItemAsset percentItemAsset;
    private PurchasingAccountsPayableDocument preqDocumentWithSingleItemSingleAccount;
    private PurchasingAccountsPayableDocument preqDocumentWithTwoItemsSingleAccount;
    private PurchasingAccountsPayableDocument cmDocumentWithSingleItemTwoAccounts;
    private String ERROR_MERGE_OBJECT_SUB_TYPES_DIFFERENT = "objectSubTypes are different for Merge";
    private String ERROR_MERGE_OBJECT_SUB_TYPES_SAME = "objectSubTypes are the same for Merge";
    private String ERROR_ALLOCATE_OBJECT_SUB_TYPES_DIFFERENT = "objectSubTypes are different for Allocate";
    private String ERROR_ALLOCATE_OBJECT_SUB_TYPES_SAME = "objectSubTypes are the same for Allocate";
    private String ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT = "process split error happens when one item has one account";
    private String ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT = "process split error happens when one item has multiple accounts";
    private String ERROR_PROCESS_MERGE = "process merge error";
    private String ERROR_PROCESS_ALLOCATE = "process allocate error";

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.purApLineService = (PurApLineService)SpringContext.getBean(PurApLineService.class);
        this.prepareTestDataRecords();
    }

    private void prepareTestDataRecords() throws Exception {
        this.purApDocuments = PurchasingAccountsPayableDocumentFixture.createPurApDocuments();
        this.preqDocumentWithTwoItemsSingleAccount = this.purApDocuments.get(0);
        this.preqDocumentWithSingleItemSingleAccount = this.purApDocuments.get(1);
        this.cmDocumentWithSingleItemTwoAccounts = this.purApDocuments.get(2);
        this.percentItemAsset = (PurchasingAccountsPayableItemAsset)this.preqDocumentWithTwoItemsSingleAccount.getPurchasingAccountsPayableItemAssets().get(0);
    }

    public void testProcessPercentPayment() throws Exception {
        ArrayList actionsTaken = new ArrayList();
        this.purApLineService.processPercentPayment(this.percentItemAsset, actionsTaken);
        PurApLineServiceTest.assertEquals((Object)this.percentItemAsset.getAccountsPayableItemQuantity(), (Object)new KualiDecimal(1));
        PurApLineServiceTest.assertEquals((Object)this.percentItemAsset.getTotalCost(), (Object)this.getTotalCost(this.percentItemAsset));
        PurApLineServiceTest.assertEquals((Object)this.percentItemAsset.getUnitCost(), (Object)this.getTotalCost(this.percentItemAsset));
        PurApLineServiceTest.assertEquals((int)actionsTaken.size(), (int)1);
        PurApLineServiceTest.assertEquals((String)((PurchasingAccountsPayableActionHistory)actionsTaken.get(0)).getActionTypeCode(), (String)"percent payment");
    }

    public void testProcessPercentPayment_noAction() throws Exception {
        this.percentItemAsset.setAccountsPayableItemQuantity(new KualiDecimal(2));
        ArrayList actionsTaken = new ArrayList();
        this.purApLineService.processPercentPayment(this.percentItemAsset, actionsTaken);
        PurApLineServiceTest.assertEquals((Object)this.percentItemAsset.getAccountsPayableItemQuantity(), (Object)new KualiDecimal(2));
        PurApLineServiceTest.assertEquals((int)actionsTaken.size(), (int)0);
    }

    private KualiDecimal getTotalCost(PurchasingAccountsPayableItemAsset item) {
        KualiDecimal totalCost = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableLineAssetAccount account : item.getPurchasingAccountsPayableLineAssetAccounts()) {
            totalCost = (KualiDecimal)totalCost.add((AbstractKualiDecimal)account.getItemAccountTotalAmount());
        }
        return totalCost;
    }

    public void testMergeLinesHasDifferentObjectSubTypes_True() {
        ArrayList items = new ArrayList();
        items.add(this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(1));
        items.add(this.purApDocuments.get(1).getPurchasingAccountsPayableItemAssets().get(0));
        PurApLineServiceTest.assertTrue((String)this.ERROR_MERGE_OBJECT_SUB_TYPES_DIFFERENT, (boolean)this.purApLineService.mergeLinesHasDifferentObjectSubTypes(items));
    }

    public void testMergeLinesHasDifferentObjectSubTypes_False() {
        ArrayList items = new ArrayList();
        items.add(this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(0));
        items.add(this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(1));
        PurApLineServiceTest.assertFalse((String)this.ERROR_MERGE_OBJECT_SUB_TYPES_SAME, (boolean)this.purApLineService.mergeLinesHasDifferentObjectSubTypes(items));
    }

    public void testAllocateLinesHasDifferentObjectSubTypes_Ture() {
        ArrayList items = new ArrayList();
        items.add(this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(0));
        items.add(this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(1));
        PurchasingAccountsPayableItemAsset allocateSourceItem = (PurchasingAccountsPayableItemAsset)this.purApDocuments.get(1).getPurchasingAccountsPayableItemAssets().get(0);
        PurApLineServiceTest.assertTrue((String)this.ERROR_ALLOCATE_OBJECT_SUB_TYPES_DIFFERENT, (boolean)this.purApLineService.allocateLinesHasDifferentObjectSubTypes(items, allocateSourceItem));
    }

    public void testAllocateLinesHasDifferentObjectSubTypes_False() {
        ArrayList items = new ArrayList();
        items.add(this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(0));
        items.add(this.purApDocuments.get(2).getPurchasingAccountsPayableItemAssets().get(0));
        PurchasingAccountsPayableItemAsset allocateSourceItem = (PurchasingAccountsPayableItemAsset)this.purApDocuments.get(0).getPurchasingAccountsPayableItemAssets().get(1);
        PurApLineServiceTest.assertFalse((String)this.ERROR_ALLOCATE_OBJECT_SUB_TYPES_SAME, (boolean)this.purApLineService.allocateLinesHasDifferentObjectSubTypes(items, allocateSourceItem));
    }

    public void testProcessSplit_ItemHasSingleAccount() {
        ArrayList actionsTaken = new ArrayList();
        PurchasingAccountsPayableItemAsset splitItemAsset = (PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(0);
        int oldItemSize = this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().size();
        KualiDecimal oldQuantity = splitItemAsset.getAccountsPayableItemQuantity();
        KualiDecimal oldTotalCost = this.getTotalCost(splitItemAsset);
        splitItemAsset.setSplitQty(new KualiDecimal(1));
        this.purApLineService.processSplit(splitItemAsset, actionsTaken);
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT, (++oldItemSize == this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().size() ? 1 : 0) != 0);
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT, (boolean)splitItemAsset.getAccountsPayableItemQuantity().equals((Object)oldQuantity.subtract((AbstractKualiDecimal)new KualiDecimal(1))));
        KualiDecimal newQuantity = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableItemAsset item : this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets()) {
            newQuantity = (KualiDecimal)newQuantity.add((AbstractKualiDecimal)item.getAccountsPayableItemQuantity());
        }
        PurApLineServiceTest.assertEquals((Object)oldQuantity, (Object)newQuantity);
        KualiDecimal newTotalCost = KualiDecimal.ZERO;
        newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(0)));
        newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(1)));
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT, (boolean)oldTotalCost.equals((Object)newTotalCost));
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_SPLIT_SINGLE_ACCOUNT, (actionsTaken.size() == 1 ? 1 : 0) != 0);
    }

    public void testProcessSplit_ItemHasTwoAccounts() {
        ArrayList actionsTaken = new ArrayList();
        PurchasingAccountsPayableItemAsset splitItemAsset = (PurchasingAccountsPayableItemAsset)this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().get(0);
        int oldItemSize = this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().size();
        KualiDecimal oldQuantity = splitItemAsset.getAccountsPayableItemQuantity();
        KualiDecimal oldTotalCost = this.getTotalCost(splitItemAsset);
        splitItemAsset.setSplitQty(new KualiDecimal(1));
        this.purApLineService.processSplit(splitItemAsset, actionsTaken);
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT, (++oldItemSize == this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().size() ? 1 : 0) != 0);
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT, (boolean)splitItemAsset.getAccountsPayableItemQuantity().equals((Object)oldQuantity.subtract((AbstractKualiDecimal)new KualiDecimal(1))));
        KualiDecimal newQuantity = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableItemAsset item : this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets()) {
            newQuantity = (KualiDecimal)newQuantity.add((AbstractKualiDecimal)item.getAccountsPayableItemQuantity());
        }
        PurApLineServiceTest.assertEquals((Object)oldQuantity, (Object)newQuantity);
        KualiDecimal newTotalCost = KualiDecimal.ZERO;
        newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().get(0)));
        newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost((PurchasingAccountsPayableItemAsset)this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets().get(1)));
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT, (boolean)oldTotalCost.equals((Object)newTotalCost));
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_SPLIT_MULTIPLE_ACCOUNT, (actionsTaken.size() == 2 ? 1 : 0) != 0);
    }

    public void testProcessMerge_NotMergeAll() {
        ArrayList actionsTakeHistory = new ArrayList();
        ArrayList mergeLines = new ArrayList();
        mergeLines.addAll(this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets());
        mergeLines.addAll(this.preqDocumentWithTwoItemsSingleAccount.getPurchasingAccountsPayableItemAssets());
        KualiDecimal oldTotalCost = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableItemAsset item : mergeLines) {
            oldTotalCost = (KualiDecimal)oldTotalCost.add((AbstractKualiDecimal)this.getTotalCost(item));
        }
        this.purApLineService.processMerge(mergeLines, actionsTakeHistory, false);
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_MERGE, (this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().size() == 1 ? 1 : 0) != 0);
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_MERGE, (boolean)this.preqDocumentWithTwoItemsSingleAccount.getPurchasingAccountsPayableItemAssets().isEmpty());
        KualiDecimal newTotalCost = this.getTotalCost((PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(0));
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_MERGE, (boolean)oldTotalCost.equals((Object)newTotalCost));
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_MERGE, (!this.preqDocumentWithTwoItemsSingleAccount.isActive() ? 1 : 0) != 0);
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_MERGE, (actionsTakeHistory.size() == 2 ? 1 : 0) != 0);
    }

    public void testProcessAllocate_AllocateOneItemToAllTheOtherItems() {
        ArrayList actionsTakeHistory = new ArrayList();
        PurchasingAccountsPayableItemAsset sourceLineItem = (PurchasingAccountsPayableItemAsset)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().get(0);
        ArrayList<PurchasingAccountsPayableItemAsset> allocateTargetLines = new ArrayList<PurchasingAccountsPayableItemAsset>();
        KualiDecimal oldTotalCost = this.getTotalCost(sourceLineItem);
        for (PurchasingAccountsPayableItemAsset item : this.preqDocumentWithTwoItemsSingleAccount.getPurchasingAccountsPayableItemAssets()) {
            allocateTargetLines.add(item);
            oldTotalCost = (KualiDecimal)oldTotalCost.add((AbstractKualiDecimal)this.getTotalCost(item));
        }
        for (PurchasingAccountsPayableItemAsset item : this.cmDocumentWithSingleItemTwoAccounts.getPurchasingAccountsPayableItemAssets()) {
            allocateTargetLines.add(item);
            oldTotalCost = (KualiDecimal)oldTotalCost.add((AbstractKualiDecimal)this.getTotalCost(item));
        }
        this.purApLineService.processAllocate(sourceLineItem, allocateTargetLines, actionsTakeHistory, this.purApDocuments, false);
        PurApLineServiceTest.assertTrue((String)"PurchasingAccountsPayableItemAssets was not empty", (boolean)this.preqDocumentWithSingleItemSingleAccount.getPurchasingAccountsPayableItemAssets().isEmpty());
        PurApLineServiceTest.assertFalse((String)"preqDocumentWithSingleItemSingleAccount was active", (boolean)this.preqDocumentWithSingleItemSingleAccount.isActive());
        KualiDecimal newTotalCost = KualiDecimal.ZERO;
        for (PurchasingAccountsPayableItemAsset item : allocateTargetLines) {
            newTotalCost = (KualiDecimal)newTotalCost.add((AbstractKualiDecimal)this.getTotalCost(item));
        }
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_ALLOCATE, (boolean)oldTotalCost.equals((Object)newTotalCost));
        PurApLineServiceTest.assertTrue((String)this.ERROR_PROCESS_ALLOCATE, (actionsTakeHistory.size() == 4 ? 1 : 0) != 0);
    }
}

