/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.io.Serializable;
import java.util.List;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentWithCapitalAssetItemsFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionItemFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CapitalAssetPurchasingServiceTest
extends KualiTestBase {
    public void testSetupCapitalAssetItems() {
        RequisitionDocument requisition = RequisitionDocumentWithCapitalAssetItemsFixture.REQ_VALID_IND_NEW_CAPITAL_ASSET_ITEM.createRequisitionDocument();
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetItems((PurchasingDocument)requisition);
        List afterFirstCall = requisition.getPurchasingCapitalAssetItems();
        RequisitionItem item2 = (RequisitionItem)ObjectUtils.deepCopy((Serializable)requisition.getItem(0));
        item2.setItemIdentifier(null);
        requisition.addItem((PurApItem)item2);
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetItems((PurchasingDocument)requisition);
        List afterSecondCall = requisition.getPurchasingCapitalAssetItems();
        CapitalAssetPurchasingServiceTest.assertTrue((afterSecondCall.size() == 2 ? 1 : 0) != 0);
        for (PurchasingCapitalAssetItem camsItem : afterSecondCall) {
            CapitalAssetPurchasingServiceTest.assertTrue((camsItem.getPurchasingCapitalAssetSystem() != null ? 1 : 0) != 0);
        }
    }

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=true)
    public void testDeleteCapitalAssetItems() {
        RequisitionDocument requisition = RequisitionDocumentWithCapitalAssetItemsFixture.REQ_VALID_IND_NEW_CAPITAL_ASSET_ITEM.createRequisitionDocument();
        requisition.getDocumentHeader().setDocumentDescription("From PurchasingServiceTest)");
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetItems((PurchasingDocument)requisition);
        PurchasingItem item2 = RequisitionItemFixture.REQ_ITEM_VALID_CAPITAL_ASSET.createRequisitionItemForCapitalAsset();
        requisition.addItem((PurApItem)item2);
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetItems((PurchasingDocument)requisition);
        ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)requisition);
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).deleteCapitalAssetItems((PurchasingDocument)requisition, requisition.getItem(0).getItemIdentifier());
        List afterDeletion = requisition.getPurchasingCapitalAssetItems();
        try {
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)requisition);
        }
        catch (ValidationException ex) {
            CapitalAssetPurchasingServiceTest.fail((String)("Validation error when saving document without validation: " + TestUtils.dumpMessageMapErrors()));
        }
        CapitalAssetPurchasingServiceTest.assertEquals((int)1, (int)afterDeletion.size());
        for (PurchasingCapitalAssetItem camsItem : afterDeletion) {
            CapitalAssetPurchasingServiceTest.assertNotNull((String)("PurchasingCapitalAssetSystem on " + camsItem + " should not have been null"), (Object)camsItem.getPurchasingCapitalAssetSystem());
        }
    }
}

