/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.web.struts;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformation;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.module.cam.CamsConstants;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.GeneralLedgerEntry;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

public class CapitalAssetInformationForm extends KualiForm {
    private GeneralLedgerEntry generalLedgerEntry;
    private Long primaryGlAccountId;
    private List<CapitalAssetInformation> capitalAssetInformation;
    private boolean selectAllGlEntries;
    private String currDocNumber;
    protected Long generalLedgerAccountIdentifier;

    public CapitalAssetInformationForm() {
        this.generalLedgerEntry = new GeneralLedgerEntry();
    }

    @Override
    public boolean shouldMethodToCallParameterBeUsed(String methodToCallParameterName, String methodToCallParameterValue, HttpServletRequest request) {
        if (StringUtils.equals(methodToCallParameterName, KRADConstants.DISPATCH_REQUEST_PARAMETER) && (StringUtils.equals(methodToCallParameterValue, CamsConstants.Actions.PROCESS) || StringUtils.equals(methodToCallParameterValue, CamsConstants.Actions.VIEW_DOC))) {
            return true;
        }
        return super.shouldMethodToCallParameterBeUsed(methodToCallParameterName, methodToCallParameterValue, request);
    }

    @Override
    public void addRequiredNonEditableProperties() {
        super.addRequiredNonEditableProperties();
        registerRequiredNonEditableProperty(CamsPropertyConstants.GeneralLedgerEntry.GENERAL_LEDGER_ACCOUNT_IDENTIFIER);
    }

    public GeneralLedgerEntry getGeneralLedgerEntry() {
        return generalLedgerEntry;
    }

    public void setGeneralLedgerEntry(GeneralLedgerEntry generalLedgerEntry) {
        this.generalLedgerEntry = generalLedgerEntry;
    }

    public Long getPrimaryGlAccountId() {
        return primaryGlAccountId;
    }

    public void setPrimaryGlAccountId(Long primaryGlAccountId) {
        this.primaryGlAccountId = primaryGlAccountId;
    }

    public List<CapitalAssetInformation> getCapitalAssetInformation() {
        return capitalAssetInformation;
    }

    public void setCapitalAssetInformation(List<CapitalAssetInformation> capitalAssetInformation) {
        this.capitalAssetInformation = capitalAssetInformation;
    }

    public boolean isSelectAllGlEntries() {
        return selectAllGlEntries;
    }

    public void setSelectAllGlEntries(boolean selectAllGlEntries) {
        this.selectAllGlEntries = selectAllGlEntries;
    }

    public String getCurrDocNumber() {
        return currDocNumber;
    }

    public void setCurrDocNumber(String currDocNumber) {
        this.currDocNumber = currDocNumber;
    }

    public Long getGeneralLedgerAccountIdentifier() {
        return generalLedgerAccountIdentifier;
    }

    public void setGeneralLedgerAccountIdentifier(Long generalLedgerAccountIdentifier) {
        this.generalLedgerAccountIdentifier = generalLedgerAccountIdentifier;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.selectAllGlEntries = false;
        this.currDocNumber = null;
    }

    @Override
    public boolean getIsNewForm() {
        // TODO hack for now
        // Avoid this exception after first submit
        /*
         * java.lang.RuntimeException: Cannot verify that the methodToCall should be methodToCall.submitAssetGlobal.x
         * org.kuali.rice.kns.util.WebUtils.parseMethodToCall(WebUtils.java:112)
         */
        return true;
    }
}
