/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch.service;

import java.io.File;
import java.sql.Timestamp;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.module.cam.batch.ExtractProcessLog;
import org.kuali.kfs.module.cam.batch.service.BatchExtractReportService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

public class BatchExtractReportServiceTest
extends KualiTestBase {
    private BatchExtractReportService batchExtractReportService;

    @ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
    protected void setUp() throws Exception {
        super.setUp();
        this.batchExtractReportService = (BatchExtractReportService)SpringContext.getBean(BatchExtractReportService.class);
    }

    public void testGenerateStatusReport() {
        ExtractProcessLog processLog = new ExtractProcessLog();
        processLog.setStartTime(new Timestamp(System.currentTimeMillis()));
        processLog.setFinishTime(new Timestamp(System.currentTimeMillis()));
        processLog.setLastExtractTime(new Timestamp(System.currentTimeMillis()));
        processLog.setTotalGlCount(Integer.valueOf(15));
        processLog.setPurApGlCount(Integer.valueOf(10));
        processLog.setNonPurApGlCount(Integer.valueOf(5));
        processLog.setSuccess(false);
        processLog.setErrorMessage("Unexpected error occurred");
        Entry entry1 = new Entry();
        entry1.setDocumentNumber("1234");
        entry1.setReferenceFinancialDocumentNumber("PO232");
        entry1.setAccountNumber("AC2323");
        entry1.setTransactionLedgerEntryDescription("Mismatched");
        Entry entry2 = new Entry();
        entry2.setDocumentNumber("1235");
        entry2.setReferenceFinancialDocumentNumber("PO235");
        entry2.setAccountNumber("AC2325");
        entry2.setTransactionLedgerEntryDescription("Duplicate");
        Entry entry3 = new Entry();
        entry3.setDocumentNumber("1236");
        entry3.setReferenceFinancialDocumentNumber("PO236");
        entry3.setAccountNumber("AC2326");
        entry3.setTransactionLedgerEntryDescription("Ignored");
        processLog.addMismatchedGLEntry(entry1);
        processLog.addMismatchedGLEntry(entry1);
        processLog.addMismatchedGLEntry(entry1);
        processLog.addDuplicateGLEntry(entry2);
        processLog.addDuplicateGLEntry(entry2);
        processLog.addDuplicateGLEntry(entry2);
        processLog.addIgnoredGLEntry(entry3);
        processLog.addIgnoredGLEntry(entry3);
        processLog.addIgnoredGLEntry(entry3);
        try {
            File report = this.batchExtractReportService.generateStatusReportPDF(processLog);
            if (report.isFile()) {
                BatchExtractReportServiceTest.assertTrue((boolean)report.delete());
            } else {
                BatchExtractReportServiceTest.fail((String)"Report not generated");
            }
        }
        catch (Exception e) {
            BatchExtractReportServiceTest.fail((String)("fail to generate PDF file." + e));
        }
    }

    public void testGenerateMismatchReport() {
        ExtractProcessLog processLog = new ExtractProcessLog();
        processLog.setStartTime(new Timestamp(System.currentTimeMillis()));
        processLog.setFinishTime(new Timestamp(System.currentTimeMillis()));
        processLog.setLastExtractTime(new Timestamp(System.currentTimeMillis()));
        processLog.setTotalGlCount(Integer.valueOf(15));
        processLog.setPurApGlCount(Integer.valueOf(10));
        processLog.setNonPurApGlCount(Integer.valueOf(5));
        processLog.setSuccess(false);
        processLog.setErrorMessage("Unexpected error occurred");
        Entry entry1 = new Entry();
        entry1.setDocumentNumber("1234");
        entry1.setReferenceFinancialDocumentNumber("PO232");
        entry1.setAccountNumber("AC2323");
        entry1.setTransactionLedgerEntryDescription("Mismatched");
        Entry entry2 = new Entry();
        entry2.setDocumentNumber("1235");
        entry2.setReferenceFinancialDocumentNumber("PO235");
        entry2.setAccountNumber("AC2325");
        entry2.setTransactionLedgerEntryDescription("Duplicate");
        Entry entry3 = new Entry();
        entry3.setDocumentNumber("1236");
        entry3.setReferenceFinancialDocumentNumber("PO236");
        entry3.setAccountNumber("AC2326");
        entry3.setTransactionLedgerEntryDescription("Ignored");
        processLog.addMismatchedGLEntry(entry1);
        processLog.addMismatchedGLEntry(entry1);
        processLog.addMismatchedGLEntry(entry1);
        try {
            File report = this.batchExtractReportService.generateMismatchReportPDF(processLog);
            if (report.isFile()) {
                BatchExtractReportServiceTest.assertTrue((boolean)report.delete());
            } else {
                BatchExtractReportServiceTest.fail((String)"Report not generated");
            }
        }
        catch (Exception e) {
            BatchExtractReportServiceTest.fail((String)("fail to generate PDF file." + e));
        }
    }
}

