/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.service.impl;

import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformation;
import org.kuali.kfs.fp.businessobject.CapitalAssetInformationDetail;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.service.impl.CapitalAssetManagementModuleServiceImpl;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.Campus;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.rice.krad.bo.BusinessObject;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.util.AutoPopulatingList;

public class CapitalAssetManagementModuleServiceImplTest {
    private static final AssetType TYPE_MOVABLE_ASSET = new AssetType();
    private static final AssetType TYPE_NONMOVABLE_ASSET;
    @Mock
    private DataDictionaryService dataDictionaryService;
    @Mock
    private ParameterService parameterService;
    @Mock
    private BusinessObjectService businessObjectService;
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private CapitalAssetManagementModuleServiceImpl cut;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new CapitalAssetManagementModuleServiceImpl();
        this.cut.setDataDictionaryService(this.dataDictionaryService);
        this.cut.setParameterService(this.parameterService);
        this.cut.setBusinessObjectService(this.businessObjectService);
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionaryService);
    }

    @After
    public void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void testCheckNewCapitalAssetFieldsExist_MissingCapitalAssetTypeCode() {
        String labelName = "capitalAssetTypeCode";
        String labelValue = "CAP_ASSET_LABEL";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("capitalAssetTypeCode", "CAP_ASSET_LABEL", attrClass, false, false, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("capitalAssetTypeCode", "CAP_ASSET_LABEL", valid);
    }

    @Test
    public void testCheckNewCapitalAssetFieldsExist_CapitalAssetQuantity() {
        String labelName = "capitalAssetQuantity";
        String labelValue = "CAP_ASSET_QUANTITY";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("capitalAssetQuantity", "CAP_ASSET_QUANTITY", attrClass, false, false, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode("FOO");
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(0));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("capitalAssetQuantity", "CAP_ASSET_QUANTITY", valid);
    }

    @Test
    public void testCheckNewCapitalAssetFieldsExist_VendorName() {
        String labelName = "vendorName";
        String labelValue = "CAP_ASSET_VENDOR_NAME";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("vendorName", "CAP_ASSET_VENDOR_NAME", attrClass, true, false, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode("FOO");
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("vendorName", "CAP_ASSET_VENDOR_NAME", valid);
    }

    @Test
    public void testCheckNewCapitalAssetFieldsExist_ManufacturerName() {
        String labelName = "capitalAssetManufacturerName";
        String labelValue = "CAP_ASSET_MANUFACTURER_NAME";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("capitalAssetManufacturerName", "CAP_ASSET_MANUFACTURER_NAME", attrClass, false, true, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode("FOO");
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("capitalAssetManufacturerName", "CAP_ASSET_MANUFACTURER_NAME", valid);
    }

    @Test
    public void testCheckNewCapitalAssetFieldsExist_CapitalAssetDesc() {
        String labelName = "capitalAssetDescription";
        String labelValue = "CAP_ASSET_DESC";
        Class<CapitalAssetInformation> attrClass = CapitalAssetInformation.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("capitalAssetDescription", "CAP_ASSET_DESC", attrClass, false, false, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode("FOO");
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("capitalAssetDescription", "CAP_ASSET_DESC", valid);
    }

    @Test
    public void testCheckNewCapitalAssetFieldsExist_CapitalAssetDetailMissingCampusCode() {
        String labelName = "campusCode";
        String labelValue = "CAMPUS";
        Class<Campus> attrClass = Campus.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("campusCode", "CAMPUS", attrClass, false, false, TYPE_MOVABLE_ASSET);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setBuildingCode("BLD1");
        capitalAssetInformationDetail.setBuildingRoomNumber("100");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].campusCode", "CAMPUS", valid);
    }

    @Test
    public void testCheckNewCapitalAssetFieldsExist_CapitalAssetDetailMissingBuildingCode() {
        String labelName = "buildingCode";
        String labelValue = "BUILDING";
        Class<Building> attrClass = Building.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("buildingCode", "BUILDING", attrClass, false, false, TYPE_MOVABLE_ASSET);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode("BL");
        capitalAssetInformationDetail.setBuildingRoomNumber("100");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingCode", "BUILDING", valid);
    }

    @Test
    public void testCheckNewCapitalAssetFieldsExist_CapitalAssetDetailMissingRoom() {
        String labelName = "buildingRoomNumber";
        String labelValue = "ROOM";
        Class<Room> attrClass = Room.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("buildingRoomNumber", "ROOM", attrClass, false, false, TYPE_MOVABLE_ASSET);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode("BL");
        capitalAssetInformationDetail.setBuildingCode("BLD1");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0);
        this.assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingRoomNumber", "ROOM", valid);
    }

    @Test
    public void testCheckNewCapitalAssetFieldsExist_Valid() {
        String labelName = "buildingRoomNumber";
        String labelValue = "ROOM";
        Class<Room> attrClass = Room.class;
        this.setupMocksForCheckNewCapitalAssetFieldExists("buildingRoomNumber", "ROOM", attrClass, false, false, TYPE_MOVABLE_ASSET);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode("BL");
        capitalAssetInformationDetail.setBuildingCode("BLD1");
        capitalAssetInformationDetail.setBuildingRoomNumber("001");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        Assert.assertTrue((String)"Expected valid for asset fields exist", (boolean)this.cut.checkNewCapitalAssetFieldsExist(capitalAssetInformation, null, 0));
    }

    private void setupMocksForCheckNewCapitalAssetFieldExists(String labelName, String labelValue, Class attributeClass, boolean vendorNameRequired, boolean manufacturerNameRequired, AssetType assetType) {
        Mockito.when((Object)this.dataDictionaryService.getAttributeLabel(attributeClass, labelName)).thenReturn((Object)labelValue);
        Mockito.when((Object)this.parameterService.getParameterValueAsString(Asset.class, "VENDOR_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND")).thenReturn((Object)(vendorNameRequired ? "Y" : "N"));
        Mockito.when((Object)this.parameterService.getParameterValueAsString(Asset.class, "MANUFACTURER_REQUIRED_FOR_NON_MOVEABLE_ASSET_IND")).thenReturn((Object)(manufacturerNameRequired ? "Y" : "N"));
        if (assetType != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("capitalAssetTypeCode", assetType.getCapitalAssetTypeCode());
            Mockito.when((Object)this.businessObjectService.findByPrimaryKey(AssetType.class, params)).thenReturn((Object)assetType);
        }
    }

    private void assertForCheckNewCapitalAssetFieldsExistWithSingleErrorMessage(String labelName, String labelValue, boolean valid) {
        Assert.assertFalse((String)"Expected new capital assets fields exist to return false", (boolean)valid);
        Assert.assertEquals((String)"Expected one error message", (long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        AutoPopulatingList errorList = GlobalVariables.getMessageMap().getErrorMessagesForProperty(labelName);
        Assert.assertNotNull((String)("Expected error messages for property " + labelName), (Object)errorList);
        Assert.assertEquals((String)"Expected one error message", (long)1L, (long)errorList.size());
        ErrorMessage errorMessage = (ErrorMessage)errorList.get(0);
        Assert.assertEquals((String)"Unexpected error key", (Object)"error.required", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((String)"Expected only one message parameter", (long)1L, (long)(errorMessage.getMessageParameters() != null ? (long)errorMessage.getMessageParameters().length : 0L));
        Assert.assertEquals((Object)labelValue, (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void testValidateAssetTagLocationLines_MissingCampus() {
        String labelName = "campusCode";
        String labelValue = "CAMPUS";
        Class<Campus> attrClass = Campus.class;
        this.setupMocksForValidateAssetTagLocationLines("campusCode", "CAMPUS", attrClass, TYPE_NONMOVABLE_ASSET, null, null, null, null, null, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_NONMOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].campusCode", "error.existence", valid, 1, new String[]{"CAMPUS"});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    public void testValidateAssetTagLocationLines_InvalidBuilding() {
        String labelName = "buildingCode";
        String labelValue = "BUILDING";
        Class<Building> attrClass = Building.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        String buildingCode = "FFF";
        this.setupMocksForValidateAssetTagLocationLines("buildingCode", "BUILDING", attrClass, TYPE_MOVABLE_ASSET, campus.getCode(), campus, "FFF", null, null, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode("FFF");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingCode", "error.asset.location.invalid.building.code", valid, 1, new String[]{"FFF", campus.getCode()});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    public void testValidateAssetTagLocationLines_InvalidRoomNumber() {
        String labelName = "buildingRoomNumber";
        String labelValue = "ROOM";
        Class<Room> attrClass = Room.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Building building = new Building();
        String roomNumber = "999";
        building.setCampusCode(campus.getCode());
        building.setBuildingCode("FFF");
        this.setupMocksForValidateAssetTagLocationLines("buildingRoomNumber", "ROOM", attrClass, TYPE_MOVABLE_ASSET, campus.getCode(), campus, building.getBuildingCode(), building, "999", null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode(building.getBuildingCode());
        capitalAssetInformationDetail.setBuildingRoomNumber("999");
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingRoomNumber", "error.asset.location.invalid.room.code", valid, 1, new String[]{"999", building.getBuildingCode(), campus.getCode()});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    public void testValidateAssetTagLocationLines_Valid() {
        String labelName = "buildingCode";
        String labelValue = "BUILDING";
        Class<Building> attrClass = Building.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Building building = new Building();
        Room room = new Room();
        building.setCampusCode(campus.getCode());
        building.setBuildingCode("FFF");
        room.setBuildingRoomNumber("100");
        this.setupMocksForValidateAssetTagLocationLines("buildingCode", "BUILDING", attrClass, TYPE_MOVABLE_ASSET, campus.getCode(), campus, building.getBuildingCode(), building, room.getBuildingRoomNumber(), room);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_MOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode(building.getBuildingCode());
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        Assert.assertTrue((String)"Expected valid result", (boolean)this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null));
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    public void testValidateAssetTagLocationLines_BuildingCodeWithNonmovableAsset() {
        String labelName = "buildingCode";
        String labelValue = "BUILDING";
        Class<Building> attrClass = Building.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Building building = new Building();
        building.setCampusCode(campus.getCode());
        building.setBuildingCode("FFF");
        this.setupMocksForValidateAssetTagLocationLines("buildingCode", "BUILDING", attrClass, TYPE_NONMOVABLE_ASSET, campus.getCode(), campus, building.getBuildingCode(), building, null, null);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_NONMOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode(building.getBuildingCode());
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingCode", "error.asset.location.building.number.nonmoveable", valid, 1, new String[]{"BUILDING"});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    public void testValidateAssetTagLocationLines_RoomWithNonmovableAsset() {
        String labelName = "buildingRoomNumber";
        String labelValue = "ROOM";
        Class<Room> attrClass = Room.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Room room = new Room();
        room.setBuildingRoomNumber("100");
        this.setupMocksForValidateAssetTagLocationLines("buildingRoomNumber", "ROOM", attrClass, TYPE_NONMOVABLE_ASSET, campus.getCode(), campus, null, null, room.getBuildingRoomNumber(), room);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_NONMOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingRoomNumber(room.getBuildingRoomNumber());
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingRoomNumber", "error.asset.location.room.number.nonmoveable", valid, 1, new String[]{"ROOM"});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    @Test
    public void testValidateAssetTagLocationLines_BuildingAndRoomWithNonmovableAsset() {
        String labelName = "buildingCode";
        String labelValue = "BUILDINGORROOM";
        Class<Building> attrClass = Building.class;
        Campus campus = new Campus();
        campus.setCode("EA");
        Building building = new Building();
        building.setCampusCode(campus.getCode());
        building.setBuildingCode("FFF");
        Room room = new Room();
        room.setBuildingRoomNumber("100");
        Mockito.when((Object)this.dataDictionaryService.getAttributeLabel(Room.class, "buildingRoomNumber")).thenReturn((Object)"BUILDINGORROOM");
        this.setupMocksForValidateAssetTagLocationLines("buildingCode", "BUILDINGORROOM", attrClass, TYPE_NONMOVABLE_ASSET, campus.getCode(), campus, building.getBuildingCode(), building, room.getBuildingRoomNumber(), room);
        CapitalAssetInformation capitalAssetInformation = new CapitalAssetInformation();
        capitalAssetInformation.setCapitalAssetTypeCode(TYPE_NONMOVABLE_ASSET.getCapitalAssetTypeCode());
        capitalAssetInformation.setCapitalAssetQuantity(Integer.valueOf(1));
        capitalAssetInformation.setCapitalAssetDescription("My Capital Asset!");
        CapitalAssetInformationDetail capitalAssetInformationDetail = new CapitalAssetInformationDetail();
        capitalAssetInformationDetail.setCampusCode(campus.getCode());
        capitalAssetInformationDetail.setBuildingCode(building.getBuildingCode());
        capitalAssetInformationDetail.setBuildingRoomNumber(room.getBuildingRoomNumber());
        capitalAssetInformation.getCapitalAssetInformationDetails().add(capitalAssetInformationDetail);
        boolean valid = this.cut.validateAssetTagLocationLines(capitalAssetInformation, 0, null);
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingCode", "error.asset.location.building.number.nonmoveable", valid, 2, new String[]{"BUILDINGORROOM"});
        this.assertForValidateAssetTagLocationLine("document.capitalAssetInformation[0].capitalAssetInformationDetails[0].buildingRoomNumber", "error.asset.location.room.number.nonmoveable", valid, 2, new String[]{"BUILDINGORROOM"});
        ((BusinessObjectDictionaryService)Mockito.verify((Object)this.businessObjectDictionaryService, (VerificationMode)Mockito.atLeastOnce())).performForceUppercase((BusinessObject)Mockito.any());
    }

    private void setupMocksForValidateAssetTagLocationLines(String labelName, String labelValue, Class attributeClass, AssetType assetType, String campusCode, Campus campusResult, String buildingCode, Building buildingResult, String roomNumber, Room roomResult) {
        Mockito.when((Object)this.dataDictionaryService.getAttributeLabel(attributeClass, labelName)).thenReturn((Object)labelValue);
        if (campusResult != null) {
            Mockito.when((Object)this.businessObjectService.findBySinglePrimaryKey(Campus.class, (Object)campusCode)).thenReturn((Object)campusResult);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("campusCode", campusCode);
        params.put("buildingCode", buildingCode);
        Mockito.when((Object)this.businessObjectService.findByPrimaryKey(Building.class, params)).thenReturn((Object)buildingResult);
        params = new HashMap();
        params.put("campusCode", campusCode);
        params.put("buildingCode", buildingCode);
        params.put("buildingRoomNumber", roomNumber);
        Mockito.when((Object)this.businessObjectService.findByPrimaryKey(Room.class, params)).thenReturn((Object)roomResult);
        if (assetType != null) {
            params = new HashMap();
            params.put("capitalAssetTypeCode", assetType.getCapitalAssetTypeCode());
            Mockito.when((Object)this.businessObjectService.findByPrimaryKey(AssetType.class, params)).thenReturn((Object)assetType);
        }
        this.businessObjectDictionaryService.performForceUppercase((BusinessObject)Mockito.any());
    }

    private void assertForValidateAssetTagLocationLine(String labelName, String errorKey, boolean valid, int totalErrorCount, String[] expectedMessageParameters) {
        Assert.assertFalse((String)"Expected new capital assets fields exist to return false", (boolean)valid);
        Assert.assertEquals((String)("Expected " + totalErrorCount + " error messages"), (long)totalErrorCount, (long)GlobalVariables.getMessageMap().getErrorCount());
        AutoPopulatingList errorList = GlobalVariables.getMessageMap().getErrorMessagesForProperty(labelName);
        Assert.assertNotNull((String)("Expected error messages for property " + labelName), (Object)errorList);
        Assert.assertEquals((String)"Expected one error message", (long)1L, (long)errorList.size());
        ErrorMessage errorMessage = (ErrorMessage)errorList.get(0);
        Assert.assertEquals((String)"Unexpected error key", (Object)errorKey, (Object)errorMessage.getErrorKey());
        Assert.assertEquals((String)("Expected " + expectedMessageParameters.length + " message parameter(s)"), (long)expectedMessageParameters.length, (long)(errorMessage.getMessageParameters() != null ? (long)errorMessage.getMessageParameters().length : 0L));
        String[] actualMessageParameters = errorMessage.getMessageParameters();
        for (int i = 0; i < expectedMessageParameters.length; ++i) {
            Assert.assertEquals((Object)expectedMessageParameters[i], (Object)actualMessageParameters[i]);
        }
    }

    static {
        TYPE_MOVABLE_ASSET.setCapitalAssetTypeCode("F");
        TYPE_MOVABLE_ASSET.setActive(true);
        TYPE_MOVABLE_ASSET.setCapitalAssetTypeDescription("Test Movable Asset Type");
        TYPE_MOVABLE_ASSET.setMovingIndicator(true);
        TYPE_MOVABLE_ASSET.setRequiredBuildingIndicator(true);
        TYPE_NONMOVABLE_ASSET = new AssetType();
        TYPE_NONMOVABLE_ASSET.setCapitalAssetTypeCode("T");
        TYPE_NONMOVABLE_ASSET.setActive(true);
        TYPE_NONMOVABLE_ASSET.setCapitalAssetTypeDescription("Test Non-movable Asset Type");
        TYPE_NONMOVABLE_ASSET.setMovingIndicator(false);
        TYPE_NONMOVABLE_ASSET.setRequiredBuildingIndicator(false);
    }
}

