/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam;

/**
 * Holds error key constants.
 */
public final class CamsKeyConstants {

    public static final String CONTINUE_QUESTION = "document.question.continue.text";
    public static final String ERROR_INVALID_BUILDING_CODE = "error.invalid.building.code";
    public static final String ERROR_INVALID_ROOM_NUMBER = "error.invalid.room.number";
    public static final String ERROR_INVALID_IN_SERVICE_DATE = "error.invalid.in.service.date";
    public static final String ERROR_BLANK_IN_SERVICE_DATE_DISALLOWED = "error.blank.in.service.date.disallowed";
    public static final String ERROR_INVALID_ASSET_WARRANTY_NO = "error.invalid.asset.warranty.no";
    public static final String ERROR_CAPITAL_ASSET_VENDOR_NAME_REQUIRED = "error.capital.asset.vendor.name.required";
    public static final String ERROR_TAG_NUMBER_DUPLICATE = "error.tag.number.duplicate";
    public static final String ERROR_ASSET_RETIRED_CAPITAL = "error.asset.retired.capital";
    public static final String ERROR_FABRICATION_ESTIMATED_TOTAL_AMOUNT_NEGATIVE = "error.asset.fabrication.totalAmount.negative";
    public static final String ERROR_ESTIMATED_FABRICATION_LIFE_LIMIT_NEGATIVE = "error.asset.fabrication.lifeLimit.negative";
    public static final String ORGANIZATION_OWNER_ACCOUNT_INACTIVE = "error.asset.org.owner.account.inactive";
    public static final String ORGANIZATION_OWNER_ACCOUNT_INVALID = "error.asset.org.owner.account.invalid";
    public static final String ERROR_ESTIMATED_FABRICATION_COMPLETION_DATE_PAST = "error.asset.fabrication.completionDate.past";
    public static final String ERROR_SPLIT_QTY_INVALID = "error.split.qty.invalid";
    public static final String ERROR_SPLIT_QTY_REQUIRED = "error.split.qty.required";
    public static final String ERROR_PO_ID_INVALID = "error.po.id.invalid";
    public static final String ERROR_PO_ID_EMPTY = "error.po.id.empty";
    public static final String MESSAGE_NO_ACTIVE_PURAP_DOC = "message.no.active.purap.doc";
    public static final String MESSAGE_CAB_CHANGES_SAVED_SUCCESS = "message.cab.changes.saved.success";

    public static final String ERROR_ITEM_CAPITAL_AND_EXPENSE = "errors.item.capitalAsset.capital.and.expense";
    public static final String WARNING_ABOVE_THRESHOLD_SUGGESTS_CAPITAL_ASSET_LEVEL = "warnings.item.capitalAsset.threshold.objectCodeLevel";
    public static final String ERROR_ITEM_TRAN_TYPE_OBJECT_CODE_SUBTYPE = "errors.item.capitalAsset.tranType.objectCodeSubtype";
    public static final String ERROR_ITEM_WRONG_TRAN_TYPE = "errors.item.capitalAsset.wrong.tranType";
    public static final String ERROR_ITEM_NO_TRAN_TYPE = "errors.item.capitalAsset.no.tranType";
    public static final String ERROR_MERGE_QTY_EMPTY = "error.merge.qty.empty";
    public static final String ERROR_MERGE_DESCRIPTION_EMPTY = "error.merge.description.empty";
    public static final String ERROR_ALLOCATE_NO_LINE_SELECTED = "error.allocate.no.line.selected";
    public static final String ERROR_ALLOCATE_NO_TARGET_ACCOUNT = "error.allocate.no.target.account";
    public static final String ERROR_MERGE_LINE_SELECTED = "error.merge.line.selected";
    public static final String ERROR_ADDL_CHARGE_PENDING = "error.addl.charge.pending";
    public static final String ERROR_TRADE_IN_PENDING = "error.trade.in.pending";
    public static final String QUESTION_TRADE_IN_INDICATOR_EXISTING = "question.trade.in.indicator.existing";
    public static final String QUESTION_SKIP_ASSET_NUMBERS_TO_ASSET_GLOBAL = "question.skip.asset.numbers.to.asset.global";
    public static final String QUESTION_DIFFERENT_OBJECT_SUB_TYPES = "question.different.object.sub.types";
    public static final String ERROR_FRACTIONAL_QUANTITY = "error.fractional.quantity";
    public static final String ERROR_MERGE_WITH_PRETAGGING = "error.merge.with.pretagging";
    public static final String DATA_EDIT_LOCK_ERROR = "cab.error.data.edit.lock";
    public static final String CHART_ORG_DISALLOWED_BY_CURRENT_USER = "chart.org.disallowed.by.current.user";

    /**
     * Private Constructor since this is a constants class that should never be instantiated.
     */
    private CamsKeyConstants() {
    }

    public static class Depreciation {
        public static final String NO_ELIGIBLE_FOR_DEPRECIATION_ASSETS_FOUND = "error.batch.depreciation.assetsNotFound";
        public static final String ERROR_WHEN_CALCULATING_DEPRECIATION = "error.batch.depreciation.calculationError";
        public static final String ERROR_WHEN_UPDATING_GL_PENDING_ENTRY_TABLE = "error.batch.depreciation.glpeUpdateError";
        public static final String INVALID_DEPRECIATION_DATE_FORMAT = "error.batch.depreciation.invalidDepreciationDateFormat";
        public static final String DEPRECIATION_ALREADY_RAN_MSG = "error.batch.depreciation.alreadyRan";
        public static final String MSG_REPORT_DEPRECIATION_HEADING1 = "message.batch.report.depreciation.heading.description";
        public static final String MSG_REPORT_DEPRECIATION_HEADING2 = "message.batch.report.depreciation.heading.figures";
        public static final String FISCAL_MONTH_NOT_VALID = "error.batch.depreciation.fiscalMonthNotValid";
    }

    public static class Payment {
        public static final String ERROR_INVALID_DOC_POST_DATE = "error.payment.invalid.document.postdate";
        public static final String ERROR_INVALID_OBJECT_SUBTYPE = "error.asset.payment.invalidObjectSubtypeCode";
        public static final String WARNING_NOT_SAME_OBJECT_SUB_TYPES = "warning.payment.object.subtype.not_the_same";
        public static final String QUESTION_NO_PAYMENTS_SELECTED_WHEN_CAN_MAKE_SELECTION = "question.no.payments.selected.when.can.make.selection";
        public static final String ERROR_NON_CAPITAL_ASSET = "error.non.capital.asset.payment";
        public static final String ERROR_NON_ASSETS_IN_DOCUMENT = "error.payment.document.noAssetsInDocumentFound";
        public static final String ERROR_NON_ZERO_COST_ASSETS_ALLOWED = "error.payment.document.noZeroValueAssetsAllowed";
        public static final String ERROR_POSTING_DATE_FUTURE_NOT_ALLOWED = "error.posting.date.future.notallowed";
        public static final String ERROR_IN_PROCESS_PAYMENT_NOT_BALANCE = "error.in.process.payment.not.balance";
    }

    public static class Transfer {
        public static final String ERROR_ASSET_RETIRED_NOTRANSFER = "error.asset.retired.notransfer";
        public static final String ERROR_CAMPUS_PLANT_FUND_UNKNOWN = "error.campus.plant.fund.unknown";
        public static final String ERROR_ORG_PLANT_FUND_UNKNOWN = "error.org.plant.fund.unknown";
        public static final String ERROR_OWNER_CHART_CODE_INVALID = "error.receiving.org.chart.code.invalid";
        public static final String ERROR_OWNER_ACCT_INVALID = "error.receiving.org.acct.invalid";
        public static final String ERROR_TRFR_FDOC_INVALID = "error.transfer.fund.financial.doc.invalid";
        public static final String ERROR_TRFR_FDOC_REQUIRED = "error.transfer.fund.financial.doc.required";
        public static final String ERROR_TRFR_LOANED = "error.transfer.asset.loaned";
        public static final String ERROR_INVALID_USER_AUTH_ID = "error.representative.user.invalid";
        public static final String ERROR_PAYMENT_OBJECT_CODE_NOT_FOUND = "error.transfer.document.payment.object.code.doesnt.exists";
        public static final String ERROR_INVALID_USER_GROUP_FOR_TRANSFER_NONMOVABLE_ASSET = "error.invalid.user.group.for.transfer.non.movable.asset";
        public static final String MESSAGE_NO_LEDGER_ENTRY_REQUIRED_TRANSFER = "message.no.ledger.entry.required.transfer";
    }

    public static class GLPosting {
        public static final String ERROR_ASSET_OBJECT_CODE_NOT_FOUND = "error.asset.object.code.not.found";
        public static final String ERROR_ASSET_OBJECT_CODE_INACTIVE = "error.asset.object.code.inactive";
        public static final String ERROR_OBJECT_CODE_FROM_ASSET_OBJECT_CODE_NOT_FOUND = "error.object.code.from.asset.object.code.not.found";
        public static final String ERROR_OBJECT_CODE_FROM_ASSET_OBJECT_CODE_INACTIVE = "error.object.code.from.asset.object.code.inactive";
        public static final String ERROR_OBJECT_CODE_FROM_ASSET_OBJECT_CODE_INVALID = "error.object.code.from.asset.object.code.invalid";
    }

    public static class AssetLocation {
        public static final String ERROR_INVALID_BUILDING_CODE = "error.invalid.building.code";
        public static final String ERROR_INVALID_CAMPUS_CODE = "error.invalid.campus.code";
        public static final String ERROR_INVALID_ROOM_NUMBER = "error.invalid.room.code";
        public static final String ERROR_INVALID_OFF_CAMPUS_STATE = "error.invalid.state.code";
        public static final String ERROR_LOCATION_INFO_REQUIRED = "error.location.info.required";
        public static final String ERROR_ON_CAMPUS_BUILDING_CODE_REQUIRED = "error.on.campus.building.value.required";
        public static final String ERROR_ON_CAMPUS_BUILDING_ROOM_NUMBER_REQUIRED = "error.on.campus.room.number.required";
        public static final String ERROR_OFF_CAMPUS_ADDRESS_REQUIRED = "error.off.campus.address.required";
        public static final String ERROR_OFF_CAMPUS_CITY_REQUIRED = "error.off.campus.city.required";
        public static final String ERROR_OFF_CAMPUS_STATE_REQUIRED = "error.off.campus.state.required";
        public static final String ERROR_OFF_CAMPUS_ZIP_REQUIRED = "error.off.campus.zip.required";
        public static final String ERROR_OFF_CAMPUS_CONTACT_REQUIRED = "error.off.campus.contactName.required";
        public static final String ERROR_OFF_CAMPUS_COUNTRY_REQUIRED = "error.off.campus.country.required";
        public static final String ERROR_CHOOSE_LOCATION_INFO = "error.location.choose.right";
        public static final String ERROR_ON_CAMPUS_BUILDING_ROOM_NUMBER_NOT_PERMITTED = "error.on.campus.room.number.not.permitted";
        public static final String ERROR_ON_CAMPUS_SUB_ROOM_NUMBER_NOT_PERMITTED = "error.on.campus.sub.room.number.not.permitted";
        public static final String ERROR_CHOOSE_ASSET_TYPE = "error.choose.asset.type.validate.location";
        public static final String ERROR_LOCATION_NOT_PERMITTED_ASSET_TYPE = "error.location.not.permitted.asset.type";
        public static final String ERROR_ASSET_LOCATION_ROOM_NUMBER_NON_MOVABLE = "error.asset.location.room.number.non.movable";
        public static final String ERROR_ASSET_LOCATION_BUILDING_NON_MOVABLE = "error.asset.location.building.number.non.movable";
    }

    public static class Retirement {
        public static final String ERROR_RETIREMENT_DETAIL_INFO_NULL = "error.retirement.detail.info.null";
        public static final String ERROR_INVALID_RETIREMENT_DETAIL_INFO = "error.invalid.retirement.detail.info";
        public static final String ERROR_INVALID_MERGED_TARGET_ASSET_NUMBER = "error.invalid.merged.target.asset.number";
        public static final String ERROR_NON_CAPITAL_ASSET_RETIREMENT = "error.non.capital.asset.retirement";
        public static final String ERROR_NON_ACTIVE_ASSET_RETIREMENT = "error.non.active.asset.retirement";
        public static final String ERROR_INVALID_CAPITAL_ASSET_NUMBER = "error.invalid.capital.asset.number";
        public static final String ERROR_DUPLICATE_CAPITAL_ASSET_NUMBER_WITH_TARGET = "error.duplicate.capital.asset.number.with.target";
        public static final String ERROR_INVALID_USER_GROUP_FOR_NON_MOVABLE_ASSET = "error.invalid.user.group.for.non.movable.asset";
        public static final String ERROR_BLANK_CAPITAL_ASSET_NUMBER = "error.blank.capital.asset.number";
        public static final String ERROR_ASSET_RETIREMENT_GLOBAL_NO_ASSET = "error.asset.retirement.global.no.asset";
        public static final String ERROR_MULTIPLE_ASSET_RETIRED = "error.multiple.asset.retired";
        public static final String ERROR_LOANED_ASSET_CANNOT_RETIRED = "error.retirement.asset.loaned";
        public static final String MESSAGE_NO_LEDGER_ENTRY_REQUIRED_RETIREMENT = "message.no.ledger.entry.required.retirement";
    }

    public static class AssetLocationGlobal {
        public static final String ERROR_INVALID_CAPITAL_ASSET_NUMBER = "error.asset.location.invalid.capital.asset.number";
        public static final String ERROR_INVALID_CAMPUS_CODE = "error.asset.location.invalid.campus.code";
        public static final String ERROR_INVALID_BUILDING_CODE = "error.asset.location.invalid.building.code";
        public static final String ERROR_INVALID_ROOM_NUMBER = "error.asset.location.invalid.room.code";
        public static final String ERROR_TAG_NUMBER_REQUIRED = "error.asset.location.tag.number.required";
        public static final String ERROR_DUPLICATE_TAG_NUMBER_FOUND = "error.asset.location.duplicate.tag.number";
        public static final String ERROR_DUPLICATE_TAG_NUMBER_WITHIN_DOCUMENT = "error.asset.location.duplicate.tag.within.document";
        public static final String ERROR_ASSET_LOCATION_GLOBAL_NO_ASSET_DETAIL = "error.asset.location.no.asset.location.detail.line";
        public static final String ERROR_CAMPUS_CODE_REQUIRED = "error.asset.location.campus.code.required";
        public static final String ERROR_BUILDING_CODE_REQUIRED = "error.asset.location.building.code.required";
        public static final String ERROR_ROOM_NUMBER_REQUIRED = "error.asset.location.room.number.required";
        public static final String ERROR_ASSET_AUTHORIZATION = "error.asset.authorization";
        public static final String WARNING_ASSET_NOT_CHANGED = "warning.asset.not.changed";
        public static final String WARNING_LOCATION_UPDATE_UNNECESSARY = "warning.location.update.unnecessary";
    }

    public static class BarcodeInventory {
        public static final String TITLE_BAR_CODE_INVENTORY = "message.upload.title.barCodeInventory";
        public static final String ERROR_INVALID_FIELD = "error.document.invalid.field";
        public static final String ERROR_REQUIRED_FIELD = "error.document.required.field";
        public static final String ERROR_NOT_ALLOWED_FIELD = "error.document.not.allowed.field";
        public static final String ERROR_CAPITAL_ASSET_DOESNT_EXIST = "error.document.capitalAsset.not.found";
        public static final String ERROR_CAPITAL_ASSET_IS_RETIRED = "error.document.capitalAsset.retired";
        public static final String ERROR_DUPLICATED_TAG_NUMBER = "error.document.duplicated.tagNumber";
        public static final String ERROR_ASSET_LOCKED = "error.document.locked.asset";
        public static final String ERROR_INVALID_FILE_TYPE = "error.uploadFile.invalid.type";
        public static final String ERROR_INACTIVE_FIELD = "error.document.inactive.field";
        public static final String ERROR_CHECKBOX_MUST_BE_CHECKED = "error.checkbox.must.be.checked";
        public static final String ERROR_GLOBAL_REPLACE_SEARCH_CRITERIA = "error.global.replace.empty.fields";
        public static final String ERROR_VALIDATE_ITEMS_BEFORE_APPROVE = "error.validate.items.before.approval";
    }

    public static class EquipmentLoanOrReturn {
        public static final String ERROR_INVALID_BORROWER_ID = "error.invalid.borrower.id";
        public static final String ERROR_INVALID_LOAN_DATE = "error.invalid.loan.date";
        public static final String ERROR_INVALID_EXPECTED_RETURN_DATE = "error.invalid.expected.return.date";
        public static final String ERROR_INVALID_EXPECTED_MAX_DATE = "error.invalid.expected.max.date";
        public static final String ERROR_INVALID_LOAN_RETURN_DATE = "error.invalid.loan.return.date";
        public static final String ERROR_INVALID_BORROWER_STATE = "error.invalid.borrower.state.code";
        public static final String ERROR_INVALID_BORROWER_STORAGE_STATE = "error.invalid.borrower.storage.state.code";
        public static final String ERROR_BORROWER_STORAGE_STATE_REQUIRED = "error.borrower.storage.state.required";
        public static final String ERROR_BORROWER_STORAGE_ZIP_REQUIRED = "error.borrower.storage.zip.required";
        public static final String ERROR_CAMPUS_TAG_NUMBER_REQUIRED = "error.campus.tag.number.required";
    }

    public static class AssetGlobal {
        public static final String ERROR_INVENTORY_STATUS_REQUIRED = "error.asset.inventory.status.code.required";
        public static final String ERROR_INVENTORY_STATUS_REQUIRED_FOR_PAYMENT = "error.asset.inventory.status.code.required.for.payment";
        public static final String ERROR_OWNER_ACCT_NOT_ACTIVE = "error.asset.owner.account.not.active";
        public static final String ERROR_PAYMENT_ACCT_NOT_VALID = "error.asset.payment.account.not.valid";
        public static final String MIN_ONE_ASSET_REQUIRED = "error.document.min.one.asset.required";
        public static final String MIN_ONE_PAYMENT_REQUIRED = "error.document.min.one.payment.required";
        public static final String ERROR_VENDOR_NAME_REQUIRED = "error.capital.asset.vendor.name.required";
        public static final String ERROR_MFR_NAME_REQUIRED = "error.capital.asset.manufacturer.name.required";
        public static final String ERROR_ACQUISITION_TYPE_CODE_REQUIRED = "error.acquisition.code.required";
        public static final String ERROR_CAMPUS_TAG_NUMBER_DUPLICATE = "error.asset.campus.tag.number.duplicate";
        public static final String ERROR_DOCUMENT_TYPE_CODE_NOT_ALLOWED = "error.document.type.code.not.allowed";
        public static final String ERROR_ASSET_TYPE_REQUIRED = "error.valid.capital.asset.type.required";
        public static final String ERROR_ASSET_LOCATION_DEPENDENCY = "error.asset.location.validation.dependency";
        public static final String ERROR_ASSET_PAYMENT_DEPENDENCY = "error.asset.payment.validation.dependency";
        public static final String ERROR_CAPITAL_ASSET_PAYMENT_AMOUNT_MIN = "error.capital.asset.payment.min.limit";
        public static final String ERROR_NON_CAPITAL_ASSET_PAYMENT_AMOUNT_MAX = "error.noncapital.asset.payment.max.limit";
        public static final String ERROR_DOCUMENT_POSTING_DATE_REQUIRED = "error.document.posting.date.required";
        public static final String ERROR_INVALID_PAYMENT_AMOUNT = "error.payment.amount.invalid";
        public static final String ERROR_EXPENDITURE_FINANCIAL_DOCUMENT_NUMBER_REQUIRED = "error.expenditure.financial.document.number.required";
        public static final String ERROR_EXPENDITURE_FINANCIAL_DOCUMENT_TYPE_CODE_REQUIRED = "error.expenditure.financial.document.type.code.required";
        public static final String ERROR_UNIVERSITY_NOT_DEFINED_FOR_DATE = "error.university.not.defined.for.date";
        public static final String ERROR_SEPARATE_ASSET_TOTAL_COST_NOT_MATCH_PAYMENT_TOTAL_COST = "error.separate.asset.total.cost.not.match.payment.total.cost";
        public static final String ERROR_SEPARATE_ASSET_ALREADY_SEPARATED = "error.separate.asset.already.separated";
        public static final String ERROR_INVALID_ACQUISITION_INCOME_OBJECT_CODE = "error.invalid.acquisition.income.object.code";
        public static final String ERROR_CHANGE_ASSET_TOTAL_AMOUNT_DISALLOW = "error.change.asset.total.amount.disallow";
    }

    public static class AssetSeparate {
        public static final String ERROR_CAPITAL_ASSET_TYPE_CODE_REQUIRED = "error.capital.asset.type.code.required";
        public static final String ERROR_CAPITAL_ASSET_TYPE_CODE_INVALID = "error.capital.asset.type.code.invalid";
        public static final String ERROR_ASSET_DESCRIPTION_REQUIRED = "error.asset.description.required";
        public static final String ERROR_MANUFACTURER_REQUIRED = "error.manufacturer.required";
        public static final String ERROR_NON_CAPITAL_ASSET_SEPARATE_REQUIRED = "error.non.active.capital.asset.required";
        public static final String ERROR_TOTAL_SEPARATE_SOURCE_AMOUNT_REQUIRED = "error.total.separate.source.amount.required";
        public static final String ERROR_INVALID_TOTAL_SEPARATE_SOURCE_AMOUNT = "error.total.separate.source.amount.invalid";
        public static final String ERROR_ZERO_OR_NEGATIVE_DOLLAR_AMOUNT = "error.zero.or.negative.dollar.amount";
        public static final String ERROR_ZERO_OR_NEGATIVE_LOCATION_QUANTITY = "error.zero.or.negative.location.quantity";
        public static final String ERROR_SEPARATE_ASSET_BELOW_THRESHOLD = "error.separate.asset.below.threshold";
    }

    public static class Asset {
        public static final String ERROR_INVALID_SALVAGE_AMOUNT = "error.asset.salvage.amount.not.valid";
        public static final String ERROR_INVALID_BOOKVALUE_AMOUNT = "error.asset.bookValue.amount.not.valid";

        // for use with Asset Edit
        public static final String LAST_INVENTORY_DATE_UPDATE_NOTE_TEXT = "note.last.inventory.date.updated";

        public static final String ERROR_ACQUISITION_TYPE_CODE_INVALID = "error.acquisition.type.code.invalid";
        public static final String ERROR_ASSET_STATUS_INVALID = "error.asset.status.invalid";
        public static final String ERROR_ASSET_CONDITION_INVALID = "error.asset.condition.invalid";
        public static final String ERROR_TYPE_CODE_INVALID = "error.type.code.invalid";
        public static final String ERROR_FINANCIAL_OBJECT_SUBTYPE_CODE_INVALID = "error.financial.object.subtype.code.invalid";
        public static final String ERROR_DEPRECATION_METHOD_CODE_INVALID = "error.deprecation.method.code.invalid";

        public static final String ERROR_ACQUISITION_TYPE_CODE_INACTIVE = "error.acquisition.type.code.inactive";
        public static final String ERROR_ASSET_STATUS_INACTIVE = "error.asset.status.inactive";
        public static final String ERROR_ASSET_CONDITION_INACTIVE = "error.asset.condition.inactive";
        public static final String ERROR_TYPE_CODE_INACTIVE = "error.type.code.inactive";
        public static final String ERROR_FINANCIAL_OBJECT_SUBTYPE_CODE_INACTIVE = "error.financial.object.subtype.code.inactive";
        public static final String ERROR_DEPRECATION_METHOD_CODE_INACTIVE = "error.deprecation.method.code.inactive";
    }

    public static class AssetRepairHistory {
        public static final String ERROR_DUPLICATE_INCIDENT_DATE = "error.duplicate.incident.date";
    }

    public static class AssetLock {
        public static final String ERROR_ASSET_LOCKED = "error.asset.locked";
        public static final String ERROR_ASSET_MAINTENANCE_LOCKED = "error.asset.maintenance.locked";
    }

    public static class PreTag {
        public static final String ERROR_PRE_TAG_INVALID_REPRESENTATIVE_ID = "error.invalid.representative.id";
        public static final String ERROR_PRE_TAG_NUMBER = "error.invalid.pre.tag.number";
        public static final String ERROR_PRE_TAG_DETAIL_EXCESS = "error.pre.tag.detail.excess";
    }

    public static class AssetPaymentAllocation {
        public static final String ERROR_PERCENT_NOT_100 = "error.asset.payment.allocation.percent";
        public static final String ERROR_AMOUNT_NOT_EQUAL = "error.asset.payment.allocation.not.equal";
        public static final String ERROR_NONE_ZERO_BY_AMOUNT = "error.asset.none.zero.by.amount";
    }

    public static class CapitalAssetInformation {
        public static final String ERROR_ASSET_DO_NOT_ENTER_ANY_DATA = "error.asset.do.not.enter.any.data";
        public static final String ERROR_ASSET_REQUIRE_DATA_ENTRY = "error.asset.require.data.entry";
        public static final String ERROR_ASSET_UPDATE_ALLOW_ONLY = "error.asset.update.allow.only";
        public static final String ERROR_ASSET_NEW_OR_UPDATE_ONLY = "error.asset.new.or.update.only";
        public static final String ERROR_ASSET_ACTIVE_CAPITAL_ASSET_REQUIRED = "error.asset.active.capital.asset.required";
        public static final String ERROR_ASSET_TAG_LINE_REQUIRED = "error.asset.tag.line.required";
        public static final String ERROR_ASSET_QUANTITY_NOT_MATCHING_TAG_LINES = "error.asset.quantity.not.matching.tag.lines";
    }
}
