/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject.lookup;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.module.cam.CamsConstants;
import org.kuali.kfs.module.cam.businessobject.AssetStatus;
import org.kuali.rice.krad.bo.BusinessObject;

import java.util.List;
import java.util.Map;

/**
 * This class overrides the base getActionUrls method
 */
public class AssetStatusLookupableHelperServiceImpl extends KualiLookupableHelperServiceImpl {

    @Override
    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        List<AssetStatus> assetStatuses = (List<AssetStatus>) super.getSearchResultsHelper(fieldValues, unbounded);

        //If the lookup was invoked from a document, then hide Under Construction Asset Status
        if (StringUtils.isNotBlank(fieldValues.get(KRADConstants.DOC_NUM))) {
            boolean found = false;
            int pos = -1;
            for (AssetStatus assetStatus : assetStatuses) {
                pos++;
                if (assetStatus.getInventoryStatusCode().equals(
                        CamsConstants.InventoryStatusCode.CAPITAL_ASSET_UNDER_CONSTRUCTION)) {
                    found = true;
                    break;
                }
            }

            if (found) {
                assetStatuses.remove(pos);
            }
        }
        return assetStatuses;
    }
}
