/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.AssetGlobalDetail;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.impl.AssetLocationServiceImpl;
import org.kuali.kfs.sys.businessobject.State;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.LocationService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class AssetLocationServiceTest {
    private AssetLocationServiceImpl cut;
    private AssetType assetType;
    private Map<AssetLocationService.LocationField, String> fieldMap;
    private AssetGlobalDetail onCampusObject;
    private AssetGlobalDetail offCampusObject;
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionarySvcMock;
    @Mock
    private LocationService locationSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupBusinessObjects();
        this.setupFieldMap();
        Mockito.when((Object)this.locationSvcMock.getState("US", "IN")).thenReturn((Object)new State());
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        PowerMockito.when((Object)((LocationService)SpringContext.getBean(LocationService.class, (String)"locationService-fin"))).thenReturn((Object)this.locationSvcMock);
        Mockito.when((Object)this.businessObjectDictionarySvcMock.getBusinessObjectEntry(AssetGlobalDetail.class.getName())).thenReturn((Object)this.setupBusinessObjectEntry());
        this.cut = new AssetLocationServiceImpl();
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionarySvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupBusinessObjects() {
        this.assetType = new AssetType();
        this.assetType.setMovingIndicator(true);
        this.onCampusObject = new AssetGlobalDetail();
        this.onCampusObject.setCampusCode("BL");
        this.onCampusObject.setBuildingCode("BL001");
        this.onCampusObject.setBuildingRoomNumber("B009");
        this.onCampusObject.setBuildingSubRoomNumber("23");
        this.offCampusObject = new AssetGlobalDetail();
        this.offCampusObject.setOffCampusName("eddsdsd");
        this.offCampusObject.setOffCampusAddress("Addreed");
        this.offCampusObject.setOffCampusCityName("City");
        this.offCampusObject.setOffCampusStateCode("IN");
        this.offCampusObject.setOffCampusZipCode("47401");
        this.offCampusObject.setOffCampusCountryCode("US");
    }

    private void setupFieldMap() {
        this.fieldMap = new HashMap<AssetLocationService.LocationField, String>();
        this.fieldMap.put(AssetLocationService.LocationField.CAMPUS_CODE, CamsPropertyConstants.AssetGlobalDetail.CAMPUS_CODE);
        this.fieldMap.put(AssetLocationService.LocationField.BUILDING_CODE, CamsPropertyConstants.AssetGlobalDetail.BUILDING_CODE);
        this.fieldMap.put(AssetLocationService.LocationField.ROOM_NUMBER, CamsPropertyConstants.AssetGlobalDetail.BUILDING_ROOM_NUMBER);
        this.fieldMap.put(AssetLocationService.LocationField.SUB_ROOM_NUMBER, CamsPropertyConstants.AssetGlobalDetail.BUILDING_SUB_ROOM_NUMBER);
        this.fieldMap.put(AssetLocationService.LocationField.CONTACT_NAME, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_NAME);
        this.fieldMap.put(AssetLocationService.LocationField.STREET_ADDRESS, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_ADDRESS);
        this.fieldMap.put(AssetLocationService.LocationField.CITY_NAME, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_CITY_NAME);
        this.fieldMap.put(AssetLocationService.LocationField.STATE_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_STATE_CODE);
        this.fieldMap.put(AssetLocationService.LocationField.ZIP_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_ZIP_CODE);
        this.fieldMap.put(AssetLocationService.LocationField.COUNTRY_CODE, CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_COUNTRY_CODE);
    }

    private BusinessObjectEntry setupBusinessObjectEntry() {
        BusinessObjectEntry businessObjectEntry = new BusinessObjectEntry();
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(this.buildAttributeDefinition(CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_NAME, "Contact Name"));
        attributeDefinitions.add(this.buildAttributeDefinition(CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_ADDRESS, "Street Address"));
        attributeDefinitions.add(this.buildAttributeDefinition(CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_CITY_NAME, "City"));
        attributeDefinitions.add(this.buildAttributeDefinition(CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_STATE_CODE, "State"));
        attributeDefinitions.add(this.buildAttributeDefinition(CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_ZIP_CODE, "Zip Code"));
        attributeDefinitions.add(this.buildAttributeDefinition(CamsPropertyConstants.AssetGlobalDetail.OFF_CAMPUS_COUNTRY_CODE, "Country"));
        attributeDefinitions.add(this.buildAttributeDefinition(CamsPropertyConstants.AssetGlobalDetail.BUILDING_CODE, "Building Code"));
        attributeDefinitions.add(this.buildAttributeDefinition(CamsPropertyConstants.AssetGlobalDetail.BUILDING_ROOM_NUMBER, "Room Number"));
        attributeDefinitions.add(this.buildAttributeDefinition(CamsPropertyConstants.AssetGlobalDetail.BUILDING_SUB_ROOM_NUMBER, "Sub Room Number"));
        businessObjectEntry.setAttributes(attributeDefinitions);
        return businessObjectEntry;
    }

    private AttributeDefinition buildAttributeDefinition(String name, String label) {
        AttributeDefinition attributeDefinition = new AttributeDefinition();
        attributeDefinition.setName(name);
        attributeDefinition.setLabel(label);
        return attributeDefinition;
    }

    @AfterClass
    public static void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validateLocation_ValidOnCampus_Valid() {
        Assert.assertTrue((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, this.assetType));
        Assert.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    public void validateLocation_OnCampusNullBuildingCode_Invalid() {
        this.onCampusObject.setBuildingCode(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.on.campus.building.value.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_OnCampusNullRoomNumber_Invalid() {
        this.onCampusObject.setBuildingRoomNumber(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingRoomNumber");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.on.campus.room.number.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_OnCampusNullSubRoomNumber_Valid() {
        this.onCampusObject.setBuildingSubRoomNumber(null);
        Assert.assertTrue((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, this.assetType));
        Assert.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    public void validateLocation_OnCampusBuildingRequired_Valid() {
        this.assetType.setMovingIndicator(false);
        this.assetType.setRequiredBuildingIndicator(true);
        this.onCampusObject.setBuildingRoomNumber(null);
        this.onCampusObject.setBuildingSubRoomNumber(null);
        Assert.assertTrue((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, this.assetType));
        Assert.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    public void validateLocation_OnCampusRoomNumberNotNull_Invalid() {
        this.assetType.setMovingIndicator(false);
        this.assetType.setRequiredBuildingIndicator(true);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingRoomNumber");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.on.campus.room.number.not.permitted", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingSubRoomNumber");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.on.campus.sub.room.number.not.permitted", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_OnCampusSubRoomNumberNotNull_Invalid() {
        this.assetType.setMovingIndicator(false);
        this.assetType.setRequiredBuildingIndicator(true);
        this.onCampusObject.setBuildingRoomNumber(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingSubRoomNumber");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.on.campus.sub.room.number.not.permitted", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_OffCampus_Valid() {
        this.assetType.setMovingIndicator(false);
        Assert.assertTrue((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, true, this.assetType));
        Assert.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    public void validateLocation_OffCampus_NullContactName_Invalid() {
        this.offCampusObject.setOffCampusName(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusName");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.off.campus.contactName.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_OffCampus_NullStreetAddress_Invalid() {
        this.offCampusObject.setOffCampusAddress(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusAddress");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.off.campus.address.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_OffCampus_NullCityName_Invalid() {
        this.offCampusObject.setOffCampusCityName(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusCityName");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.off.campus.city.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_OffCampus_NullStateCode_Invalid() {
        this.offCampusObject.setOffCampusStateCode(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusStateCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.off.campus.state.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_OffCampus_NullZipCode_Invalid() {
        this.offCampusObject.setOffCampusZipCode(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusZipCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.off.campus.zip.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_OffCampus_NullCountryCode_Invalid() {
        this.offCampusObject.setOffCampusCountryCode(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusCountryCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.off.campus.country.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_CapitalAsset_UndefinedAssetType_Invalid() {
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, null));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("Location Information");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.choose.asset.type.validate.location", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_CapitalAsset_RequiredBuildingAndOffCampus_Invalid() {
        this.assetType.setRequiredBuildingIndicator(true);
        this.assetType.setMovingIndicator(false);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)6L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusName");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.not.permitted.asset.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusAddress");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.not.permitted.asset.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusCityName");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.not.permitted.asset.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusStateCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.not.permitted.asset.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusZipCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.not.permitted.asset.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusCountryCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.not.permitted.asset.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_CapitalAsset_OnCampusNotAllowed_Invalid() {
        this.assetType.setMovingIndicator(false);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)3L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.not.permitted.asset.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingRoomNumber");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.not.permitted.asset.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingSubRoomNumber");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.not.permitted.asset.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_CapitalAsset_NoInfoAvailableForCapAsset_Invalid() {
        this.assetType.setRequiredBuildingIndicator(true);
        AssetGlobalDetail blankObject = new AssetGlobalDetail();
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)blankObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.info.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_CapitalAsset_BothAvailable_Invalid() {
        this.onCampusObject.setOffCampusAddress("Street");
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, true, this.assetType));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("buildingCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.location.choose.right", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void validateLocation_NonCapitalAsset_NoInformation_Valid() {
        AssetGlobalDetail blankObject = new AssetGlobalDetail();
        Assert.assertTrue((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)blankObject, false, null));
        Assert.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    public void validateLocation_NonCapitalAsset_OnCampus_FieldsAreOptional__Valid() {
        this.onCampusObject.setBuildingCode(null);
        Assert.assertTrue((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.onCampusObject, false, null));
        Assert.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    public void validateLocation_NonCapitalAsset_OffCampus_Valid() {
        Assert.assertTrue((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, false, null));
        Assert.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    public void validateLocation_NonCapitalAsset_OffCampusNullCountryCode_Invalid() {
        this.offCampusObject.setOffCampusCountryCode(null);
        Assert.assertFalse((boolean)this.cut.validateLocation(this.fieldMap, (BusinessObject)this.offCampusObject, false, null));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("offCampusCountryCode");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        Assert.assertEquals((Object)"error.off.campus.country.required", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }
}

