/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.businessobject;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.kuali.rice.core.api.util.type.KualiDecimal;

/**
 * Base account line group class which assist in easy group by clause
 */
public abstract class AccountLineGroup {

    protected Integer universityFiscalYear;
    protected String chartOfAccountsCode;
    protected String accountNumber;
    protected String subAccountNumber;
    protected String financialObjectCode;
    protected String financialSubObjectCode;
    protected String universityFiscalPeriodCode;
    protected String documentNumber;
    protected String referenceFinancialDocumentNumber;
    protected String projectCode;
    protected String organizationReferenceId;
    protected KualiDecimal amount;

    public Integer getUniversityFiscalYear() {
        return universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getUniversityFiscalPeriodCode() {
        return universityFiscalPeriodCode;
    }

    public void setUniversityFiscalPeriodCode(String universityFiscalPeriodCode) {
        this.universityFiscalPeriodCode = universityFiscalPeriodCode;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getReferenceFinancialDocumentNumber() {
        return referenceFinancialDocumentNumber;
    }

    public void setReferenceFinancialDocumentNumber(String referenceFinancialDocumentNumber) {
        this.referenceFinancialDocumentNumber = referenceFinancialDocumentNumber;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrganizationReferenceId() {
        return organizationReferenceId;
    }

    public void setOrganizationReferenceId(String organizationReferenceId) {
        this.organizationReferenceId = organizationReferenceId;
    }

    /**
     * Overridden so that group by statement can be easily implemented.
     * <li>DO NOT REMOVE this method, it is critical to reconciliation process</li>
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !AccountLineGroup.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        AccountLineGroup test = (AccountLineGroup) obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append(this.universityFiscalYear, test.getUniversityFiscalYear());
        equalsBuilder.append(replaceFiller(chartOfAccountsCode), replaceFiller(test.getChartOfAccountsCode()));
        equalsBuilder.append(replaceFiller(accountNumber), replaceFiller(test.getAccountNumber()));
        equalsBuilder.append(replaceFiller(subAccountNumber), replaceFiller(test.getSubAccountNumber()));
        equalsBuilder.append(replaceFiller(financialObjectCode), replaceFiller(test.getFinancialObjectCode()));
        equalsBuilder.append(replaceFiller(financialSubObjectCode), replaceFiller(test.getFinancialSubObjectCode()));
        equalsBuilder.append(replaceFiller(universityFiscalPeriodCode),
                replaceFiller(test.getUniversityFiscalPeriodCode()));
        equalsBuilder.append(replaceFiller(documentNumber), replaceFiller(test.getDocumentNumber()));
        equalsBuilder.append(replaceFiller(referenceFinancialDocumentNumber),
                replaceFiller(test.getReferenceFinancialDocumentNumber()));
        equalsBuilder.append(replaceFiller(organizationReferenceId), replaceFiller(test.getOrganizationReferenceId()));
        equalsBuilder.append(replaceFiller(projectCode), replaceFiller(test.getProjectCode()));
        return equalsBuilder.isEquals();
    }

    private String replaceFiller(String val) {
        if (val == null) {
            return "";
        }
        char[] charArray = val.trim().toCharArray();
        for (char c : charArray) {
            if (c != '-') {
                return val;
            }
        }
        return "";
    }

    /**
     * Overridden so that group by statement can be easily implemented.
     * <li>DO NOT REMOVE this method, it is critical to reconciliation process</li>
     */
    @Override
    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(37, 41);
        hashCodeBuilder.append(this.universityFiscalYear);
        hashCodeBuilder.append(replaceFiller(chartOfAccountsCode));
        hashCodeBuilder.append(replaceFiller(accountNumber));
        hashCodeBuilder.append(replaceFiller(subAccountNumber));
        hashCodeBuilder.append(replaceFiller(financialObjectCode));
        hashCodeBuilder.append(replaceFiller(financialSubObjectCode));
        hashCodeBuilder.append(replaceFiller(universityFiscalPeriodCode));
        hashCodeBuilder.append(replaceFiller(documentNumber));
        hashCodeBuilder.append(replaceFiller(referenceFinancialDocumentNumber));
        hashCodeBuilder.append(replaceFiller(organizationReferenceId));
        hashCodeBuilder.append(replaceFiller(projectCode));
        return hashCodeBuilder.toHashCode();
    }

    public KualiDecimal getAmount() {
        return amount;
    }

    public void setAmount(KualiDecimal absAmount) {
        this.amount = absAmount;
    }

    @Override
    public String toString() {
        return this.hashCode() + "-" + universityFiscalYear + "-" + chartOfAccountsCode + "-" + accountNumber + "-" +
                replaceFiller(subAccountNumber) + "-" + financialObjectCode + "-" +
                replaceFiller(financialSubObjectCode) + "-" + universityFiscalPeriodCode + "-" + documentNumber +
                "-" + referenceFinancialDocumentNumber;
    }
}
