/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.cam.document.authorization;

import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.module.cam.CamsConstants;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.kim.api.KimConstants;

import java.util.Map;

/**
 * AssetAuthorizer for Asset edit.
 */
public class AssetGlobalAuthorizer extends MaintenanceDocumentAuthorizerBase {

    @Override
    protected void addRoleQualification(Object businessObject, Map<String, String> attributes) {
        super.addRoleQualification(businessObject, attributes);

        //This was added so when the asset lookup page is requested, then it will check for role qualifiers and
        // validate whether the user has access to to some asset functions like "Separate". Take a look at
        // AssetLookupableHelperServiceImpl.getSeparateUrl(Asset asset) for more info.
        if (businessObject instanceof Asset) {
            Asset asset = (Asset) businessObject;
            attributes.put(CamsPropertyConstants.Asset.CAMPUS_CODE, asset.getCampusCode());
        }
    }

    @Override
    protected void addPermissionDetails(Object dataObject, Map<String, String> permissionDetails) {
        super.addPermissionDetails(dataObject, permissionDetails);
        if (dataObject instanceof AssetGlobal) {
            permissionDetails.put(KimConstants.AttributeConstants.BUTTON_NAME,
                    CamsConstants.AssetSeparate.CALCULATE_EQUAL_SOURCE_AMOUNTS_BUTTON);
            permissionDetails.put(KimConstants.AttributeConstants.BUTTON_NAME,
                    CamsConstants.AssetSeparate.CALCULATE_SEPARATE_SOURCE_REMAINING_AMOUNT_BUTTON);
        }
    }
}
