/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.lookup.AssetLookupableHelperServiceImpl;
import org.kuali.kfs.module.cam.document.authorization.AssetAuthorizer;
import org.kuali.kfs.sys.document.authorization.AccountingDocumentAuthorizerBase;

public class AssetPaymentLookupableHelperServiceImpl
extends AssetLookupableHelperServiceImpl {
    public Set<String> getConditionallyReadOnlyPropertyNames() {
        HashSet<String> conditionallyReadOnlyPropertyNames = new HashSet<String>();
        if (StringUtils.contains((CharSequence)this.getReturnLocation(), (CharSequence)"camsAssetPayment.do")) {
            conditionallyReadOnlyPropertyNames.add("capitalAssetNumber");
            conditionallyReadOnlyPropertyNames.add("account.chartOfAccountsCode");
            conditionallyReadOnlyPropertyNames.add("accountNumber");
            conditionallyReadOnlyPropertyNames.add("financialObjectCode");
            conditionallyReadOnlyPropertyNames.add("transferPaymentCode");
        }
        return conditionallyReadOnlyPropertyNames;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        AssetPayment assetPayment = (AssetPayment)businessObject;
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("capitalAssetNumber", assetPayment.getCapitalAssetNumber());
        Asset asset = (Asset)this.businessObjectService.findByPrimaryKey(Asset.class, primaryKeys);
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        if (this.assetService.isAssetRetired(asset)) {
            anchorHtmlDataList.add(super.getViewAssetUrl(asset));
        } else {
            anchorHtmlDataList.add(this.getAssetUrl(asset));
            anchorHtmlDataList.add(super.getLoanUrl(asset));
            anchorHtmlDataList.add(super.getMergeUrl(asset));
            anchorHtmlDataList.add(this.getSeparateUrl(assetPayment));
            anchorHtmlDataList.add(super.getTransferUrl(asset));
            anchorHtmlDataList.add(this.getPaymentUrl(asset));
        }
        return anchorHtmlDataList;
    }

    public HtmlData getInquiryUrl(BusinessObject businessObject, String propertyName) {
        AssetPayment assetPayment;
        if ("documentNumber".equals(propertyName) && ObjectUtils.isNull((Object)(assetPayment = (AssetPayment)businessObject).getDocumentHeader())) {
            return new HtmlData.AnchorHtmlData("", "");
        }
        return super.getInquiryUrl(businessObject, propertyName);
    }

    protected HtmlData getPaymentUrl(Asset asset) {
        AccountingDocumentAuthorizerBase assetPaymentAuthorizer = new AccountingDocumentAuthorizerBase();
        boolean isAuthorize = assetPaymentAuthorizer.canInitiate("MPAY", GlobalVariables.getUserSession().getPerson());
        if (this.assetService.isCapitalAsset(asset) && isAuthorize) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("methodToCall", "docHandler");
            parameters.put("capitalAssetNumber", asset.getCapitalAssetNumber().toString());
            parameters.put("command", "initiate");
            parameters.put("docTypeName", "MPAY");
            String href = UrlFactory.parameterizeUrl((String)(this.configurationService.getPropertyValueAsString("application.url") + "/camsAssetPayment.do"), parameters);
            return new HtmlData.AnchorHtmlData(href, "docHandler", "payment");
        }
        return new HtmlData.AnchorHtmlData("", "", "");
    }

    protected HtmlData getSeparateUrl(AssetPayment assetPayment) {
        Asset asset = assetPayment.getAsset();
        MaintenanceDocumentAuthorizer documentAuthorizer = (MaintenanceDocumentAuthorizer)this.documentDictionaryService.getDocumentAuthorizer("AA");
        boolean isAuthorized = documentAuthorizer.isAuthorized((BusinessObject)asset, "KFS-CAM", "Separate", GlobalVariables.getUserSession().getPerson().getPrincipalId());
        if (isAuthorized) {
            Map<String, String> parameters = this.getSeparateParameters(assetPayment.getAsset());
            parameters.put("separateSourcePaymentSequenceNumber", assetPayment.getPaymentSequenceNumber().toString());
            String href = UrlFactory.parameterizeUrl((String)"maintenance.do", parameters);
            return new HtmlData.AnchorHtmlData(href, "start", "separate");
        }
        return new HtmlData.AnchorHtmlData("", "", "");
    }

    protected HtmlData getAssetUrl(Asset asset) {
        AssetAuthorizer assetAuthorizer = new AssetAuthorizer();
        boolean isAuthorized = assetAuthorizer.canMaintain((Object)asset, GlobalVariables.getUserSession().getPerson());
        if (isAuthorized) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("methodToCall", "edit");
            parameters.put("capitalAssetNumber", asset.getCapitalAssetNumber().toString());
            parameters.put("businessObjectClassName", Asset.class.getName());
            String href = UrlFactory.parameterizeUrl((String)"maintenance.do", parameters);
            return new HtmlData.AnchorHtmlData(href, "edit", "edit");
        }
        return new HtmlData.AnchorHtmlData("", "", "");
    }
}

