/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class AssetPaymentLockValidation
extends GenericValidation {
    private AssetLockService assetLockService;

    public boolean validate(AttributedDocumentEvent event) {
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)event.getDocument();
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        for (AssetPaymentAssetDetail assetPaymentAssetDetail : assetPaymentDocument.getAssetPaymentAssetDetail()) {
            if (assetPaymentAssetDetail.getCapitalAssetNumber() == null) continue;
            assetNumbers.add(assetPaymentAssetDetail.getCapitalAssetNumber());
        }
        String documentTypeForLocking = "MPAY";
        if (assetPaymentDocument.isCapitalAssetBuilderOriginIndicator()) {
            documentTypeForLocking = "MPAYCAB";
        }
        return !this.assetLockService.isAssetLocked(assetNumbers, documentTypeForLocking, assetPaymentDocument.getDocumentNumber());
    }

    public AssetLockService getAssetLockService() {
        return this.assetLockService;
    }

    public void setAssetLockService(AssetLockService assetLockService) {
        this.assetLockService = assetLockService;
    }
}

