/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.OriginationCode;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.OriginationCodeService;

public class AssetPaymentOriginCodeValidation
extends GenericValidation {
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private OriginationCodeService originationCodeService;
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)event.getDocument();
        if (assetPaymentDocument.isCapitalAssetBuilderOriginIndicator()) {
            return true;
        }
        AssetPaymentDetail assetPaymentDetail = (AssetPaymentDetail)this.getAccountingLineForValidation();
        boolean result = true;
        if (StringUtils.isNotBlank((CharSequence)assetPaymentDetail.getExpenditureFinancialSystemOriginationCode()) && this.originationCodeService.getByPrimaryKey(assetPaymentDetail.getExpenditureFinancialSystemOriginationCode()) == null) {
            String label = this.businessObjectDictionaryService.getBusinessObjectEntry(OriginationCode.class.getName()).getAttributeDefinition("financialSystemOriginationCode").getLabel();
            GlobalVariables.getMessageMap().putError("expenditureFinancialSystemOriginationCode", "error.existence", new String[]{label});
            result = false;
        }
        return result;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLine) {
        this.accountingLineForValidation = accountingLine;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public OriginationCodeService getOriginationCodeService() {
        return this.originationCodeService;
    }

    public void setOriginationCodeService(OriginationCodeService originationCodeService) {
        this.originationCodeService = originationCodeService;
    }
}

