/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.Date;
import java.util.HashMap;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.module.cam.document.service.AssetPaymentService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.UniversityDateService;

public class AssetPaymentPostingDateValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;
    private DateTimeService dateTimeService;
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private BusinessObjectService businessObjectService;
    private UniversityDateService universityDateService;
    private AssetPaymentService assetPaymentService;

    public boolean validate(AttributedDocumentEvent event) {
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)event.getDocument();
        if (assetPaymentDocument.isCapitalAssetBuilderOriginIndicator()) {
            return true;
        }
        boolean valid = true;
        AssetPaymentDetail assetPaymentDetail = (AssetPaymentDetail)this.getAccountingLineForValidation();
        java.sql.Date expenditureFinancialDocumentPostedDate = assetPaymentDetail.getExpenditureFinancialDocumentPostedDate();
        if (expenditureFinancialDocumentPostedDate != null) {
            Date today = this.dateTimeService.getCurrentDate();
            if (expenditureFinancialDocumentPostedDate.after(today)) {
                GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentPostedDate", "error.posting.date.future.notallowed", new String[0]);
                return false;
            }
            HashMap<String, java.sql.Date> keyToFind = new HashMap<String, java.sql.Date>();
            keyToFind.put("universityDate", expenditureFinancialDocumentPostedDate);
            UniversityDate universityDate = (UniversityDate)this.businessObjectService.findByPrimaryKey(UniversityDate.class, keyToFind);
            if (universityDate == null) {
                String label = this.businessObjectDictionaryService.getBusinessObjectEntry(AssetPaymentDetail.class.getName()).getAttributeDefinition("expenditureFinancialDocumentPostedDate").getLabel();
                GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentPostedDate", "error.existence", new String[]{label});
                return false;
            }
            Integer currentFiscalYear = this.universityDateService.getCurrentFiscalYear();
            if (universityDate.getUniversityFiscalYear().compareTo(currentFiscalYear) > 0) {
                GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentPostedDate", "error.payment.invalid.document.postdate", new String[0]);
                valid = false;
            }
            if (valid) {
                this.assetPaymentService.extractPostedDatePeriod(assetPaymentDetail);
            }
        } else {
            String label = this.businessObjectDictionaryService.getBusinessObjectEntry(AssetPaymentDetail.class.getName()).getAttributeDefinition("expenditureFinancialDocumentPostedDate").getLabel();
            GlobalVariables.getMessageMap().putError("expenditureFinancialDocumentPostedDate", "error.required", new String[]{label});
            valid = false;
        }
        return valid;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLine) {
        this.accountingLineForValidation = accountingLine;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public AssetPaymentService getAssetPaymentService() {
        return this.assetPaymentService;
    }

    public void setAssetPaymentService(AssetPaymentService assetPaymentService) {
        this.assetPaymentService = assetPaymentService;
    }
}

