/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.util.distribution;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentAssetDetail;
import org.kuali.kfs.module.cam.businessobject.AssetPaymentDetail;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;

public abstract class AssetDistribution {
    protected AssetPaymentDocument doc;

    public AssetDistribution(AssetPaymentDocument doc) {
        this.doc = doc;
    }

    protected List<AssetPaymentDetail> getAssetPaymentDetailLines() {
        return this.doc.getSourceAccountingLines();
    }

    public abstract Map<String, Map<AssetPaymentAssetDetail, KualiDecimal>> getAssetPaymentDistributions();

    public void applyDistributionsToDocument() {
        for (AssetPaymentAssetDetail apad : this.doc.getAssetPaymentAssetDetail()) {
            apad.setAllocatedAmount(KualiDecimal.ZERO);
        }
        Collection<Map<AssetPaymentAssetDetail, KualiDecimal>> values = this.getAssetPaymentDistributions().values();
        for (Map<AssetPaymentAssetDetail, KualiDecimal> assetDistribution : values) {
            for (AssetPaymentAssetDetail apad : assetDistribution.keySet()) {
                KualiDecimal amount = (KualiDecimal)apad.getAllocatedAmount().add((AbstractKualiDecimal)assetDistribution.get((Object)apad));
                apad.setAllocatedAmount(amount);
            }
        }
    }
}

