/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.cam.batch.AssetDepreciationStep;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.businessobject.lookup.AssetLookupableHelperServiceImpl;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentAuthorizerBase;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

public class AssetLookupableHelperServiceImplTest {
    private static final String AUTHORIZED_PRINCIPAL_ID = "khuntley";
    private static final String UNAUTHORIZED_PRINCIPAL_ID = "rorenfro";
    private static final String NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE = "NA";
    private static final String CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE = "C2";
    @Spy
    private final AssetLookupableHelperServiceImpl cutSpy = new AssetLookupableHelperServiceImpl();
    @Mock
    private AssetPayment assetPaymentMock;
    @Mock
    private AssetPayment assetPaymentNonCapitalEquipmentObjectSubTypeMock;
    @Mock
    private AssetService assetSvcMock;
    @Mock
    private ConfigurationService configurationSvcMock;
    @Mock
    private DocumentDictionaryService documentDictionarySvcMock;
    @Mock
    private FinancialSystemTransactionalDocumentAuthorizerBase documentAuthorizerMock;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private PermissionService permissionSvcMock;
    @Mock
    private Person personMock;
    @Mock
    private UserSession userSessionMock;
    private Asset moveableAsset;
    private Asset nonMoveableAssetAuthorized;
    private Asset nonMoveableAssetNonAuthorized;
    private Asset unableToDetermineMoveableAsset;
    private Asset nonCapitalAssetNoPayments;
    private Asset nonCapitalAssetSubTypeShowLink;
    private Asset nonCapitalAssetSubTypeHideLink;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupMockObjects();
        this.setupAssets();
        this.setupMockServices();
        ((AssetLookupableHelperServiceImpl)Mockito.doReturn((Object)AUTHORIZED_PRINCIPAL_ID).when((Object)this.cutSpy)).determinePrincipalIdForCurrentUser();
        this.cutSpy.setAssetService(this.assetSvcMock);
        this.cutSpy.setDocumentDictionaryService(this.documentDictionarySvcMock);
        this.cutSpy.setParameterService(this.parameterSvcMock);
        this.cutSpy.setConfigurationService(this.configurationSvcMock);
    }

    private void setupMockObjects() {
        ((AssetPayment)Mockito.doNothing().when((Object)this.assetPaymentNonCapitalEquipmentObjectSubTypeMock)).refreshReferenceObject("financialObject");
        ObjectCode objectCodeNonCapitalEquipmentObjectSubType = new ObjectCode();
        objectCodeNonCapitalEquipmentObjectSubType.setChartOfAccountsCode("BL");
        objectCodeNonCapitalEquipmentObjectSubType.setFinancialObjectCode("5200");
        this.assetPaymentNonCapitalEquipmentObjectSubTypeMock.setFinancialObject(objectCodeNonCapitalEquipmentObjectSubType);
        ((AssetPayment)Mockito.doNothing().when((Object)this.assetPaymentMock)).refreshReferenceObject("financialObject");
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"principalId");
        Mockito.when((Object)this.userSessionMock.getPerson()).thenReturn((Object)this.personMock);
    }

    private void setupAssets() {
        this.moveableAsset = new Asset();
        this.moveableAsset.setCapitalAssetNumber(Long.valueOf(0L));
        this.moveableAsset.setInventoryStatusCode("A");
        this.nonMoveableAssetAuthorized = new Asset();
        this.nonMoveableAssetAuthorized.setCapitalAssetNumber(Long.valueOf(1L));
        this.nonMoveableAssetAuthorized.setInventoryStatusCode("A");
        this.nonMoveableAssetNonAuthorized = new Asset();
        this.nonMoveableAssetNonAuthorized.setCapitalAssetNumber(Long.valueOf(2L));
        this.nonMoveableAssetNonAuthorized.setInventoryStatusCode("A");
        this.unableToDetermineMoveableAsset = new Asset();
        this.unableToDetermineMoveableAsset.setCapitalAssetNumber(Long.valueOf(3L));
        this.unableToDetermineMoveableAsset.setInventoryStatusCode("A");
        this.nonCapitalAssetNoPayments = new Asset();
        this.nonCapitalAssetNoPayments.setCapitalAssetNumber(Long.valueOf(4L));
        this.nonCapitalAssetNoPayments.setInventoryStatusCode("N");
        this.nonCapitalAssetSubTypeShowLink = new Asset();
        this.nonCapitalAssetSubTypeShowLink.setCapitalAssetNumber(Long.valueOf(5L));
        ArrayList<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
        assetPayments.add(this.assetPaymentNonCapitalEquipmentObjectSubTypeMock);
        this.nonCapitalAssetSubTypeShowLink.setAssetPayments(assetPayments);
        this.nonCapitalAssetSubTypeShowLink.setInventoryStatusCode("N");
        this.nonCapitalAssetSubTypeHideLink = new Asset();
        this.nonCapitalAssetSubTypeHideLink.setCapitalAssetNumber(Long.valueOf(6L));
        assetPayments.clear();
        assetPayments.add(this.assetPaymentMock);
        this.nonCapitalAssetSubTypeHideLink.setAssetPayments(assetPayments);
        this.nonCapitalAssetSubTypeHideLink.setInventoryStatusCode("N");
    }

    private void setupMockServices() {
        Mockito.when((Object)this.assetSvcMock.isAssetMovableCheckByPayment(this.moveableAsset)).thenReturn((Object)true);
        Mockito.when((Object)this.assetSvcMock.isAssetMovableCheckByPayment(this.nonMoveableAssetAuthorized)).thenReturn((Object)false);
        Mockito.when((Object)this.assetSvcMock.isAssetMovableCheckByPayment(this.nonMoveableAssetNonAuthorized)).thenReturn((Object)false);
        Mockito.when((Object)this.assetSvcMock.isAssetMovableCheckByPayment(this.unableToDetermineMoveableAsset)).thenThrow(ValidationException.class);
        Mockito.when((Object)this.assetSvcMock.determineFinancialObjectSubTypeCode(this.nonCapitalAssetSubTypeHideLink)).thenReturn((Object)CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE);
        Mockito.when((Object)this.assetSvcMock.determineFinancialObjectSubTypeCode(this.nonCapitalAssetSubTypeShowLink)).thenReturn((Object)NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("application.url")).thenReturn((Object)"baseUrl");
        HashMap<String, String> roleQualification = new HashMap<String, String>();
        roleQualification.put("principalId", AUTHORIZED_PRINCIPAL_ID);
        Mockito.when((Object)this.permissionSvcMock.isAuthorized(AUTHORIZED_PRINCIPAL_ID, "KFS-CAM", "Separate", roleQualification)).thenReturn((Object)true);
        roleQualification.put("principalId", UNAUTHORIZED_PRINCIPAL_ID);
        Mockito.when((Object)this.permissionSvcMock.isAuthorized(UNAUTHORIZED_PRINCIPAL_ID, "KFS-CAM", "Separate", roleQualification)).thenReturn((Object)false);
        FinancialSystemTransactionalDocumentAuthorizerBase.setPermissionService((PermissionService)this.permissionSvcMock);
        Mockito.when((Object)this.documentAuthorizerMock.isAuthorized((BusinessObject)this.nonMoveableAssetAuthorized, "KFS-CAM", "Separate", AUTHORIZED_PRINCIPAL_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.documentAuthorizerMock.isAuthorized((BusinessObject)this.nonMoveableAssetNonAuthorized, "KFS-CAM", "Separate", UNAUTHORIZED_PRINCIPAL_ID)).thenReturn((Object)false);
        Mockito.when((Object)this.documentDictionarySvcMock.getDocumentAuthorizer("AT")).thenReturn((Object)this.documentAuthorizerMock);
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(AssetDepreciationStep.class, "NON_DEPRECIABLE_NON_CAPITAL_ASSET_STATUS_CODES")).thenReturn(new ArrayList<String>(Arrays.asList("N;O".split(";"))));
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(Asset.class, "NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPES")).thenReturn(new ArrayList<String>(Collections.singletonList(NON_CAPITAL_EQUIPMENT_OBJECT_SUB_TYPE)));
    }

    @AfterEach
    public void tearDown() {
        this.tearDownMockObjects();
        this.tearDownAssets();
        this.tearDownMockServices();
    }

    private void tearDownMockObjects() {
        this.assetPaymentNonCapitalEquipmentObjectSubTypeMock = null;
        this.assetPaymentMock = null;
        this.personMock = null;
        this.userSessionMock = null;
    }

    private void tearDownAssets() {
        this.moveableAsset = null;
        this.nonMoveableAssetAuthorized = null;
        this.nonMoveableAssetNonAuthorized = null;
        this.unableToDetermineMoveableAsset = null;
        this.nonCapitalAssetNoPayments = null;
        this.nonCapitalAssetSubTypeShowLink = null;
        this.nonCapitalAssetSubTypeHideLink = null;
    }

    private void tearDownMockServices() {
        this.assetSvcMock = null;
        this.permissionSvcMock = null;
        FinancialSystemTransactionalDocumentAuthorizerBase.setPermissionService(null);
        this.documentAuthorizerMock = null;
        this.documentDictionarySvcMock = null;
        this.parameterSvcMock = null;
    }

    @Test
    public void getTransferUrlUnableToDetermineMoveableAssetNonAuthorized() {
        ((AssetLookupableHelperServiceImpl)Mockito.doReturn((Object)UNAUTHORIZED_PRINCIPAL_ID).when((Object)this.cutSpy)).determinePrincipalIdForCurrentUser();
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(this.unableToDetermineMoveableAsset);
        this.validateEmptyAnchorHtmlData(anchorHtmlData);
    }

    @Test
    public void getTransferUrlUnableToDetermineMoveableAssetAuthorized() {
        Mockito.when((Object)this.documentAuthorizerMock.isAuthorized((BusinessObject)this.unableToDetermineMoveableAsset, "KFS-CAM", "Separate", AUTHORIZED_PRINCIPAL_ID)).thenReturn((Object)true);
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(this.unableToDetermineMoveableAsset);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.unableToDetermineMoveableAsset.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlMoveableAsset() {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(this.moveableAsset);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.moveableAsset.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlNonMoveableAssetAuthorized() {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(this.nonMoveableAssetAuthorized);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.nonMoveableAssetAuthorized.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlNonMoveableAssetNonAuthorized() {
        ((AssetLookupableHelperServiceImpl)Mockito.doReturn((Object)UNAUTHORIZED_PRINCIPAL_ID).when((Object)this.cutSpy)).determinePrincipalIdForCurrentUser();
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(this.nonMoveableAssetNonAuthorized);
        this.validateEmptyAnchorHtmlData(anchorHtmlData);
    }

    @Test
    public void getTransferUrlNonCapitalAssetNoPayments() {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(this.nonCapitalAssetNoPayments);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.nonCapitalAssetNoPayments.getCapitalAssetNumber().toString());
    }

    @Test
    public void getTransferUrlNonCapitalAssetSubTypeShouldHideLink() {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(this.nonCapitalAssetSubTypeHideLink);
        this.validateEmptyAnchorHtmlData(anchorHtmlData);
    }

    @Test
    public void getTransferUrlNonCapitalAssetSubTypeShouldShowLink() {
        HtmlData.AnchorHtmlData anchorHtmlData = (HtmlData.AnchorHtmlData)this.cutSpy.getTransferUrl(this.nonCapitalAssetSubTypeShowLink);
        this.validatePopulatedAnchorHtmlData(anchorHtmlData, this.nonCapitalAssetSubTypeShowLink.getCapitalAssetNumber().toString());
    }

    private void validateEmptyAnchorHtmlData(HtmlData.AnchorHtmlData anchorHtmlData) {
        Assertions.assertEquals((Object)"", (Object)anchorHtmlData.getHref());
        Assertions.assertEquals((Object)"", (Object)anchorHtmlData.getMethodToCall());
        Assertions.assertEquals((Object)"", (Object)anchorHtmlData.getDisplayText());
    }

    private void validatePopulatedAnchorHtmlData(HtmlData.AnchorHtmlData anchorHtmlData, String capitalAssetNumber) {
        Assertions.assertEquals((Object)this.generateExpectedUrl(capitalAssetNumber), (Object)anchorHtmlData.getHref());
        Assertions.assertEquals((Object)"docHandler", (Object)anchorHtmlData.getMethodToCall());
        Assertions.assertEquals((Object)"transfer", (Object)anchorHtmlData.getDisplayText());
    }

    private String generateExpectedUrl(String capitalAssetNumber) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "docHandler");
        parameters.put("capitalAssetNumber", capitalAssetNumber);
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "AT");
        return UrlFactory.parameterizeUrl((String)"baseUrl/camsAssetTransfer.do", parameters);
    }
}

