/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.cam.businessobject.AssetAcquisitionType;
import org.kuali.kfs.module.cam.document.service.impl.AssetAcquisitionTypeServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AssetAcquisitionTypeServiceTest {
    private AssetAcquisitionTypeServiceImpl cut;
    private AssetAcquisitionType assetAcquisitionType;
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.assetAcquisitionType = new AssetAcquisitionType();
        this.assetAcquisitionType.setAcquisitionTypeCode("N");
        this.assetAcquisitionType.setAcquisitionTypeName("New");
        this.assetAcquisitionType.setActive(true);
        HashMap<String, String> pkKeys = new HashMap<String, String>();
        pkKeys.put("acquisitionTypeCode", "N");
        Mockito.when((Object)((AssetAcquisitionType)this.businessObjectSvcMock.findByPrimaryKey(AssetAcquisitionType.class, pkKeys))).thenReturn((Object)this.assetAcquisitionType);
        this.cut = new AssetAcquisitionTypeServiceImpl();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
    }

    @Test
    public void hasIncomeAssetObjectCode_HasObjectCode_Success() {
        this.assetAcquisitionType.setIncomeAssetObjectCode("1175");
        Assertions.assertTrue((boolean)this.cut.hasIncomeAssetObjectCode(this.assetAcquisitionType.getAcquisitionTypeCode()));
    }

    @Test
    public void hasIncomeAssetObjectCode_NoObjectCode_Failure() {
        Assertions.assertFalse((boolean)this.cut.hasIncomeAssetObjectCode(this.assetAcquisitionType.getAcquisitionTypeCode()));
    }
}

