/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.document.service.impl.PaymentSummaryServiceImpl;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PaymentSummaryServiceTest {
    private PaymentSummaryServiceImpl cut;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private UniversityDateService universityDateSvcMock;
    private Asset asset;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupAsset();
        Mockito.when((Object)this.parameterSvcMock.getParameterValuesAsString(Asset.class, "FEDERAL_CONTRIBUTIONS_OBJECT_SUB_TYPES")).thenReturn(Collections.singletonList("BF"));
        UniversityDate universityDate = new UniversityDate();
        universityDate.setUniversityFiscalAccountingPeriod("5");
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)universityDate);
        this.cut = new PaymentSummaryServiceImpl();
        this.cut.setParameterService(this.parameterSvcMock);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
    }

    private void setupAsset() {
        this.asset = new Asset();
        this.asset.setPrimaryDepreciationMethodCode("SL");
        this.asset.setSalvageAmount(KualiDecimal.ZERO);
        ArrayList<AssetPayment> assetPayments = new ArrayList<AssetPayment>();
        assetPayments.add(this.buildAssetPayment(new KualiDecimal(5381.24), new KualiDecimal(5381.24), new KualiDecimal(1569.53), new KualiDecimal(672.66), new KualiDecimal(56.05), new KualiDecimal(56.06), new KualiDecimal(56.05), new KualiDecimal(56.05), new KualiDecimal(56.06), new KualiDecimal(56.05), new KualiDecimal(56.06), KualiDecimal.ZERO, KualiDecimal.ZERO, KualiDecimal.ZERO, KualiDecimal.ZERO, KualiDecimal.ZERO));
        assetPayments.add(this.buildAssetPayment(new KualiDecimal(687.3), new KualiDecimal(687.3), new KualiDecimal(200.46), new KualiDecimal(85.92), new KualiDecimal(17.16), new KualiDecimal(17.16), new KualiDecimal(17.16), new KualiDecimal(17.16), new KualiDecimal(22.16), new KualiDecimal(17.16), new KualiDecimal(17.16), new KualiDecimal(17.16), new KualiDecimal(17.16), new KualiDecimal(17.16), new KualiDecimal(17.16), new KualiDecimal(17.16)));
        assetPayments.add(this.buildAssetPayment(new KualiDecimal(-5381.24), new KualiDecimal(-5381.24), new KualiDecimal(-1569.53), new KualiDecimal(-672.66), new KualiDecimal(-56.05), new KualiDecimal(-56.06), new KualiDecimal(-56.05), new KualiDecimal(-56.05), new KualiDecimal(-56.06), new KualiDecimal(-56.05), new KualiDecimal(-56.06), KualiDecimal.ZERO, KualiDecimal.ZERO, KualiDecimal.ZERO, KualiDecimal.ZERO, KualiDecimal.ZERO));
        assetPayments.add(this.buildAssetPayment(new KualiDecimal(-637.3), new KualiDecimal(-587.0), new KualiDecimal(-100.46), new KualiDecimal(-23.92), new KualiDecimal(-7.16), new KualiDecimal(-7.16), new KualiDecimal(-7.16), new KualiDecimal(-7.15), new KualiDecimal(-7.16), new KualiDecimal(-7.16), new KualiDecimal(-7.16), KualiDecimal.ZERO, KualiDecimal.ZERO, KualiDecimal.ZERO, KualiDecimal.ZERO, KualiDecimal.ZERO));
        this.asset.setAssetPayments(assetPayments);
    }

    private AssetPayment buildAssetPayment(KualiDecimal accountChargeAmount, KualiDecimal primaryDepreciationBaseAmount, KualiDecimal accumulatedPrimaryDepreciationAmount, KualiDecimal previousYearPrimaryDepreciationAmount, KualiDecimal period1Depreciation1Amount, KualiDecimal period2Depreciation1Amount, KualiDecimal period3Depreciation1Amount, KualiDecimal period4Depreciation1Amount, KualiDecimal period5Depreciation1Amount, KualiDecimal period6Depreciation1Amount, KualiDecimal period7Depreciation1Amount, KualiDecimal period8Depreciation1Amount, KualiDecimal period9Depreciation1Amount, KualiDecimal period10Depreciation1Amount, KualiDecimal period11Depreciation1Amount, KualiDecimal period12Depreciation1Amount) {
        AssetPayment assetPaymentSpy = (AssetPayment)Mockito.spy(AssetPayment.class);
        Mockito.when((Object)assetPaymentSpy.getAccountChargeAmount()).thenReturn((Object)accountChargeAmount);
        Mockito.when((Object)assetPaymentSpy.getPrimaryDepreciationBaseAmount()).thenReturn((Object)primaryDepreciationBaseAmount);
        Mockito.when((Object)assetPaymentSpy.getAccumulatedPrimaryDepreciationAmount()).thenReturn((Object)accumulatedPrimaryDepreciationAmount);
        Mockito.when((Object)assetPaymentSpy.getPreviousYearPrimaryDepreciationAmount()).thenReturn((Object)previousYearPrimaryDepreciationAmount);
        Mockito.when((Object)assetPaymentSpy.getPeriod1Depreciation1Amount()).thenReturn((Object)period1Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod2Depreciation1Amount()).thenReturn((Object)period2Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod3Depreciation1Amount()).thenReturn((Object)period3Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod4Depreciation1Amount()).thenReturn((Object)period4Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod5Depreciation1Amount()).thenReturn((Object)period5Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod6Depreciation1Amount()).thenReturn((Object)period6Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod7Depreciation1Amount()).thenReturn((Object)period7Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod8Depreciation1Amount()).thenReturn((Object)period8Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod9Depreciation1Amount()).thenReturn((Object)period9Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod10Depreciation1Amount()).thenReturn((Object)period10Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod11Depreciation1Amount()).thenReturn((Object)period11Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getPeriod12Depreciation1Amount()).thenReturn((Object)period12Depreciation1Amount);
        Mockito.when((Object)assetPaymentSpy.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)assetPaymentSpy.getFinancialObjectCode()).thenReturn((Object)"7305");
        ObjectCodeCurrent objectCodeCurrentMock = (ObjectCodeCurrent)Mockito.mock(ObjectCodeCurrent.class);
        Mockito.when((Object)objectCodeCurrentMock.getFinancialObjectSubTypeCode()).thenReturn((Object)"BF");
        Mockito.when((Object)assetPaymentSpy.getObjectCodeCurrent()).thenReturn((Object)objectCodeCurrentMock);
        return assetPaymentSpy;
    }

    @Test
    public void calculateAndSetPaymentSummary_SL() {
        this.cut.calculateAndSetPaymentSummary(this.asset);
        Assert.assertEquals((Object)new KualiDecimal(50), (Object)this.asset.getFederalContribution());
        Assert.assertEquals((Object)new KualiDecimal(50), (Object)this.asset.getPaymentTotalCost());
        Assert.assertEquals((Object)new KualiDecimal(100), (Object)this.asset.getAccumulatedDepreciation());
        Assert.assertEquals((Object)new KualiDecimal(100.3), (Object)this.asset.getBaseAmount());
        Assert.assertEquals((Object)new KualiDecimal(0.3), (Object)this.asset.getBookValue());
        Assert.assertEquals((Object)new KualiDecimal(62), (Object)this.asset.getPrevYearDepreciation());
        Assert.assertEquals((Object)new KualiDecimal(160.81), (Object)this.asset.getYearToDateDepreciation());
        Assert.assertEquals((Object)new KualiDecimal(15), (Object)this.asset.getCurrentMonthDepreciation());
        Assert.assertEquals((Object)new KualiDecimal(392.38), (Object)((AssetPayment)this.asset.getAssetPayments().get(0)).getYearToDate());
        Assert.assertEquals((Object)new KualiDecimal(210.92), (Object)((AssetPayment)this.asset.getAssetPayments().get(1)).getYearToDate());
        Assert.assertEquals((Object)new KualiDecimal(-392.38), (Object)((AssetPayment)this.asset.getAssetPayments().get(2)).getYearToDate());
        Assert.assertEquals((Object)new KualiDecimal(-50.11), (Object)((AssetPayment)this.asset.getAssetPayments().get(3)).getYearToDate());
    }

    @Test
    public void calculateAndSetPaymentSummary_SV() {
        this.asset.setPrimaryDepreciationMethodCode("SV");
        this.asset.setSalvageAmount(new KualiDecimal(25));
        this.cut.calculateAndSetPaymentSummary(this.asset);
        Assert.assertEquals((Object)new KualiDecimal(50), (Object)this.asset.getFederalContribution());
        Assert.assertEquals((Object)new KualiDecimal(50), (Object)this.asset.getPaymentTotalCost());
        Assert.assertEquals((Object)new KualiDecimal(100), (Object)this.asset.getAccumulatedDepreciation());
        Assert.assertEquals((Object)new KualiDecimal(100.3), (Object)this.asset.getBaseAmount());
        Assert.assertEquals((Object)new KualiDecimal(-24.7), (Object)this.asset.getBookValue());
        Assert.assertEquals((Object)new KualiDecimal(62), (Object)this.asset.getPrevYearDepreciation());
        Assert.assertEquals((Object)new KualiDecimal(160.81), (Object)this.asset.getYearToDateDepreciation());
        Assert.assertEquals((Object)new KualiDecimal(15), (Object)this.asset.getCurrentMonthDepreciation());
        Assert.assertEquals((Object)new KualiDecimal(392.38), (Object)((AssetPayment)this.asset.getAssetPayments().get(0)).getYearToDate());
        Assert.assertEquals((Object)new KualiDecimal(210.92), (Object)((AssetPayment)this.asset.getAssetPayments().get(1)).getYearToDate());
        Assert.assertEquals((Object)new KualiDecimal(-392.38), (Object)((AssetPayment)this.asset.getAssetPayments().get(2)).getYearToDate());
        Assert.assertEquals((Object)new KualiDecimal(-50.11), (Object)((AssetPayment)this.asset.getAssetPayments().get(3)).getYearToDate());
    }
}

