/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service.impl;

import java.sql.Date;
import java.text.ParseException;
import java.time.LocalDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.impl.datetime.DateTimeServiceImpl;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetDepreciationConvention;
import org.kuali.kfs.module.cam.businessobject.AssetGlobal;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.businessobject.AssetType;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.impl.AssetDateServiceImpl;
import org.kuali.kfs.module.cam.document.service.impl.AssetServiceImpl;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AssetDateServiceImplTest {
    private AssetDateServiceImpl cut;
    private Asset oldAsset;
    private Asset newAsset;

    AssetDateServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new AssetDateServiceImpl();
        this.cut.setAssetService((AssetService)new AssetServiceImpl());
        this.cut.setDateTimeService((DateTimeService)new DateTimeServiceImpl());
        this.oldAsset = new Asset();
        this.newAsset = new Asset();
        this.oldAsset.setOffCampusLocation(new AssetLocation());
        this.newAsset.setOffCampusLocation(new AssetLocation());
    }

    @Test
    void checkAndUpdateLastInventoryDateNullOffCampusLocation() {
        this.oldAsset.setOffCampusLocation(null);
        this.newAsset.setOffCampusLocation(null);
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateNoChanges() {
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateCampusCodeChanged() {
        this.newAsset.setCampusCode("BL");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateBuildingCodeChanged() {
        this.newAsset.setBuildingCode("0001C");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateBuildingRoomNumberChanged() {
        this.newAsset.setBuildingRoomNumber("001");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateBuildingSubRoomNumberChanged() {
        this.newAsset.setBuildingSubRoomNumber("B");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateCampusTagNumberChanged() {
        this.newAsset.setCampusTagNumber("123");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateAssetLocationContactNameChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationContactName("Off Campus Location");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateAssetLocationStreetAddressChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationStreetAddress("123 Main St.");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateAssetLocationCityNameChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationCityName("Ithaca");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateAssetLocationStateCodeChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationStateCode("NY");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDateAssetLocationZipCodeChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationZipCode("14850");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void checkAndUpdateLastInventoryDatesetLocationCountryCodeChanged() {
        this.newAsset.getOffCampusLocation().setAssetLocationCountryCode("US");
        this.cut.checkAndUpdateLastInventoryDate(this.oldAsset, this.newAsset);
        Assertions.assertNotNull((Object)this.newAsset.getLastInventoryDate());
    }

    @Test
    void computeDepreciationDate_noDepreciationConvention() {
        AssetType assetType = this.setupAssetType();
        Date inServiceDate = Date.valueOf("2021-04-07");
        Date depreciationDate = this.cut.computeDepreciationDate(assetType, null, inServiceDate);
        Assertions.assertEquals((Object)inServiceDate, (Object)depreciationDate);
    }

    private AssetType setupAssetType() {
        AssetType assetType = new AssetType();
        assetType.setDepreciableLifeLimit(Integer.valueOf(1));
        return assetType;
    }

    @Test
    void computeDepreciationDate_depreciationConventionCreateDate() {
        AssetType assetType = this.setupAssetType();
        AssetDepreciationConvention depreciationConvention = this.setupAssetDepreciationConvention("CD");
        Date inServiceDate = Date.valueOf("2021-04-07");
        Date depreciationDate = this.cut.computeDepreciationDate(assetType, depreciationConvention, inServiceDate);
        Assertions.assertEquals((Object)inServiceDate, (Object)depreciationDate);
    }

    private AssetDepreciationConvention setupAssetDepreciationConvention(String depreciationConventionCode) {
        AssetDepreciationConvention depreciationConvention = new AssetDepreciationConvention();
        depreciationConvention.setDepreciationConventionCode(depreciationConventionCode);
        depreciationConvention.setActive(true);
        return depreciationConvention;
    }

    @Test
    void computeDepreciationDate_depreciationConventionHalfYear(@Mock(stubOnly=true) DateTimeService dateTimeSvcMock) throws ParseException {
        AssetType assetType = this.setupAssetType();
        AssetDepreciationConvention depreciationConvention = this.setupAssetDepreciationConvention("HY");
        Date inServiceDate = Date.valueOf("2021-04-07");
        this.setupMocksForComputeDepreciationDate(dateTimeSvcMock, inServiceDate);
        LocalDate janFirst = LocalDate.of(2021, 1, 1);
        Mockito.when((Object)dateTimeSvcMock.convertToSqlDate("01/01/2021")).thenReturn((Object)Date.valueOf(janFirst));
        Date depreciationDate = this.cut.computeDepreciationDate(assetType, depreciationConvention, inServiceDate);
        Assertions.assertEquals((Object)Date.valueOf("2021-01-01"), (Object)depreciationDate);
    }

    @Test
    void computeDepreciationDate_depreciationConventionFullYear(@Mock(stubOnly=true) DateTimeService dateTimeSvcMock) throws ParseException {
        AssetType assetType = this.setupAssetType();
        AssetDepreciationConvention depreciationConvention = this.setupAssetDepreciationConvention("FY");
        Date inServiceDate = Date.valueOf("2021-04-07");
        this.setupMocksForComputeDepreciationDate(dateTimeSvcMock, inServiceDate);
        Date depreciationDate = this.cut.computeDepreciationDate(assetType, depreciationConvention, inServiceDate);
        Assertions.assertEquals((Object)Date.valueOf("2020-07-01"), (Object)depreciationDate);
    }

    private void setupMocksForComputeDepreciationDate(DateTimeService dateTimeSvcMock, Date inServiceDate) throws ParseException {
        UniversityDateService universityDateSvcMock = (UniversityDateService)Mockito.mock(UniversityDateService.class);
        Mockito.when((Object)universityDateSvcMock.getFiscalYear((java.util.Date)inServiceDate)).thenReturn((Object)2021);
        this.cut.setUniversityDateService(universityDateSvcMock);
        ParameterService parameterSvcMock = (ParameterService)Mockito.mock(ParameterService.class);
        Mockito.when((Object)parameterSvcMock.getParameterValueAsString(AssetGlobal.class, "NEW_IN_SERVICE_ASSET_DEPRECIATION_START_DATE")).thenReturn((Object)"07/01");
        this.cut.setParameterService(parameterSvcMock);
        LocalDate julyFirst = LocalDate.of(2021, 7, 1);
        Mockito.when((Object)dateTimeSvcMock.convertToSqlDate("07/01/2021")).thenReturn((Object)Date.valueOf(julyFirst));
        this.cut.setDateTimeService(dateTimeSvcMock);
    }

    @Test
    void computeDepreciationDate_inactiveDepreciationConvention() {
        AssetType assetType = this.setupAssetType();
        AssetDepreciationConvention depreciationConvention = new AssetDepreciationConvention();
        Date inServiceDate = Date.valueOf("2021-04-07");
        Date depreciationDate = this.cut.computeDepreciationDate(assetType, depreciationConvention, inServiceDate);
        Assertions.assertEquals((Object)inServiceDate, (Object)depreciationDate);
    }
}

