/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cam.CamsPropertyConstants;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.validation.impl.BarcodeInventoryErrorDocumentRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class BarcodeInventoryErrorDocumentRuleTest {
    public static final String TAG_NUMBER_NON_EXISTENT_ASSET = "12345";
    public static final String TAG_NUMBER_ACTIVE_ASSET = "12345A";
    public static final String TAG_NUMBER_MULTIPLE_ASSETS = "12345M";
    public static final String TAG_NUMBER_MULTIPLE_ASSETS_ONE_ACTIVE = "12345MA";
    public static final String TAG_NUMBER_RETIRED_ASSET = "12345R";
    private BarcodeInventoryErrorDocumentRule barcodeInventoryErrorDocumentRule;
    private static final Asset activeAsset = new Asset();
    private static final Asset anotherActiveAsset = new Asset();
    private static final Asset retiredAsset = new Asset();

    BarcodeInventoryErrorDocumentRuleTest() {
    }

    @BeforeEach
    public void setUp() {
        retiredAsset.setInventoryStatusCode("R");
        this.barcodeInventoryErrorDocumentRule = new BarcodeInventoryErrorDocumentRule();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validateTagNumberAndRetrieveActiveAssetDoesNotExist(@Mock(stubOnly=true) AssetService assetService) {
        this.barcodeInventoryErrorDocumentRule.setAssetService(assetService);
        Mockito.when((Object)assetService.findAssetsMatchingTagNumber(TAG_NUMBER_NON_EXISTENT_ASSET)).thenReturn(new ArrayList());
        Assertions.assertNull((Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_NON_EXISTENT_ASSET));
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        List errorMessage = (List)errorMessages.get(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER);
        Assertions.assertNotNull((Object)errorMessage);
        Assertions.assertEquals((int)1, (int)errorMessage.size());
        Assertions.assertEquals((Object)"error.document.capitalAsset.not.found", (Object)((ErrorMessage)errorMessage.get(0)).getErrorKey());
    }

    @Test
    void validateTagNumberAndRetrieveActiveAssetMultipleAssets(@Mock(stubOnly=true) AssetService assetService) {
        this.barcodeInventoryErrorDocumentRule.setAssetService(assetService);
        ArrayList<Asset> assets = new ArrayList<Asset>(List.of(activeAsset, anotherActiveAsset));
        Mockito.when((Object)assetService.findAssetsMatchingTagNumber(TAG_NUMBER_MULTIPLE_ASSETS)).thenReturn(assets);
        Assertions.assertNull((Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_MULTIPLE_ASSETS));
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        List errorMessage = (List)errorMessages.get(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER);
        Assertions.assertNotNull((Object)errorMessage);
        Assertions.assertEquals((int)1, (int)errorMessage.size());
        Assertions.assertEquals((Object)"error.document.duplicated.tagNumber", (Object)((ErrorMessage)errorMessage.get(0)).getErrorKey());
    }

    @Test
    void validateTagNumberAndRetrieveActiveAssetRetiredAsset(@Mock(stubOnly=true) AssetService assetService) {
        this.barcodeInventoryErrorDocumentRule.setAssetService(assetService);
        ArrayList<Asset> retiredAssets = new ArrayList<Asset>(Collections.singletonList(retiredAsset));
        Mockito.when((Object)assetService.findAssetsMatchingTagNumber(TAG_NUMBER_RETIRED_ASSET)).thenReturn(retiredAssets);
        Mockito.when((Object)assetService.isAssetRetired(retiredAsset)).thenReturn((Object)true);
        Assertions.assertNull((Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_RETIRED_ASSET));
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        List errorMessage = (List)errorMessages.get(CamsPropertyConstants.BarcodeInventory.ASSET_TAG_NUMBER);
        Assertions.assertNotNull((Object)errorMessage);
        Assertions.assertEquals((int)1, (int)errorMessage.size());
        Assertions.assertEquals((Object)"error.document.capitalAsset.retired", (Object)((ErrorMessage)errorMessage.get(0)).getErrorKey());
    }

    @Test
    void validateTagNumberAndRetrieveActiveAssetOneActive(@Mock(stubOnly=true) AssetService assetService) {
        this.barcodeInventoryErrorDocumentRule.setAssetService(assetService);
        ArrayList<Asset> oneActiveAsset = new ArrayList<Asset>(Collections.singletonList(activeAsset));
        Mockito.when((Object)assetService.findAssetsMatchingTagNumber(TAG_NUMBER_ACTIVE_ASSET)).thenReturn(oneActiveAsset);
        Assertions.assertEquals((Object)activeAsset, (Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_ACTIVE_ASSET));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }

    @Test
    void validateTagNumberAndRetrieveActiveAssetOneActiveOneRetired(@Mock(stubOnly=true) AssetService assetService) {
        this.barcodeInventoryErrorDocumentRule.setAssetService(assetService);
        ArrayList<Asset> oneActiveOneRetiredAssets = new ArrayList<Asset>(List.of(activeAsset, retiredAsset));
        Mockito.when((Object)assetService.findAssetsMatchingTagNumber(TAG_NUMBER_MULTIPLE_ASSETS_ONE_ACTIVE)).thenReturn(oneActiveOneRetiredAssets);
        Mockito.when((Object)assetService.isAssetRetired(retiredAsset)).thenReturn((Object)true);
        Mockito.when((Object)assetService.isAssetRetired(activeAsset)).thenReturn((Object)false);
        Assertions.assertEquals((Object)activeAsset, (Object)this.barcodeInventoryErrorDocumentRule.validateTagNumberAndRetrieveActiveAsset(TAG_NUMBER_MULTIPLE_ASSETS_ONE_ACTIVE));
        Assertions.assertFalse((boolean)GlobalVariables.getMessageMap().hasErrors());
    }
}

