/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.businessobject;

import java.sql.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.doctype.bo.DocumentType;
import org.kuali.kfs.kew.doctype.service.DocumentTypeService;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.sys.businessobject.OriginationCode;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;

public class AssetPaymentDetail
extends SourceAccountingLine {
    private String expenditureFinancialSystemOriginationCode;
    private Date expenditureFinancialDocumentPostedDate;
    private boolean transferPaymentIndicator;
    private String expenditureFinancialDocumentNumber;
    private String expenditureFinancialDocumentTypeCode;
    private String postingPeriodCode;
    private String purchaseOrderNumber;
    private String requisitionNumber;
    private KualiDecimal amount;
    private AccountingPeriod financialDocumentPostingPeriod;
    private DocumentType expenditureFinancialSystemDocumentType;
    private OriginationCode expenditureFinancialSystemOrigination;
    private Account account;

    public AssetPaymentDetail() {
    }

    public AssetPaymentDetail(AssetPayment assetPayment) {
        this.setSequenceNumber(assetPayment.getPaymentSequenceNumber());
        this.setChartOfAccountsCode(assetPayment.getChartOfAccountsCode());
        this.setAccountNumber(assetPayment.getAccountNumber());
        this.setSubAccountNumber(assetPayment.getSubAccountNumber());
        this.setFinancialObjectCode(assetPayment.getFinancialObjectCode());
        this.setFinancialSubObjectCode(assetPayment.getFinancialSubObjectCode());
        this.setProjectCode(assetPayment.getProjectCode());
        this.setOrganizationReferenceId(assetPayment.getOrganizationReferenceId());
        this.setExpenditureFinancialSystemOriginationCode(assetPayment.getFinancialSystemOriginationCode());
        this.setExpenditureFinancialDocumentNumber(assetPayment.getDocumentNumber());
        this.setExpenditureFinancialDocumentTypeCode(assetPayment.getFinancialDocumentTypeCode());
        this.setPurchaseOrderNumber(assetPayment.getPurchaseOrderNumber());
        this.setRequisitionNumber(assetPayment.getRequisitionNumber());
        this.setExpenditureFinancialDocumentPostedDate(assetPayment.getFinancialDocumentPostingDate());
        this.setPostingYear(assetPayment.getFinancialDocumentPostingYear());
        this.setPostingPeriodCode(assetPayment.getFinancialDocumentPostingPeriodCode());
        this.setAmount(assetPayment.getAccountChargeAmount());
    }

    protected LinkedHashMap<String, String> assetPaymentToStringMapper() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("documentNumber", this.getDocumentNumber());
        m.put("sequenceNumber", this.getSequenceNumber() == null ? "" : this.getSequenceNumber().toString());
        m.put("chartOfAccountsCode", this.getChartOfAccountsCode());
        m.put("accountNumber", this.getAccountNumber());
        m.put("subAccountNumber", this.getSubAccountNumber());
        m.put("financialObjectCode", this.getFinancialObjectCode());
        m.put("financialSubObjectCode", this.getFinancialSubObjectCode());
        m.put("projectCode", this.getProjectCode());
        m.put("postingYear", this.getPostingYear().toString());
        return m;
    }

    public String getAssetPaymentDetailKey() {
        LinkedHashMap<String, String> paymentMap = this.assetPaymentToStringMapper();
        paymentMap.put("expenditureFinancialDocumentTypeCode", this.getExpenditureFinancialDocumentTypeCode());
        paymentMap.put("expenditureFinancialDocumentNumber", this.getExpenditureFinancialDocumentNumber());
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        for (String key : paymentMap.keySet()) {
            builder.append(key, (Object)paymentMap.get(key));
        }
        return paymentMap.toString();
    }

    public String getExpenditureFinancialSystemOriginationCode() {
        return this.expenditureFinancialSystemOriginationCode;
    }

    public void setExpenditureFinancialSystemOriginationCode(String expenditureFinancialSystemOriginationCode) {
        this.expenditureFinancialSystemOriginationCode = expenditureFinancialSystemOriginationCode;
    }

    public Date getExpenditureFinancialDocumentPostedDate() {
        return this.expenditureFinancialDocumentPostedDate;
    }

    public void setExpenditureFinancialDocumentPostedDate(Date expenditureFinancialDocumentPostedDate) {
        this.expenditureFinancialDocumentPostedDate = expenditureFinancialDocumentPostedDate;
    }

    public boolean isTransferPaymentIndicator() {
        return this.transferPaymentIndicator;
    }

    public void setTransferPaymentIndicator(boolean transferPaymentIndicator) {
        this.transferPaymentIndicator = transferPaymentIndicator;
    }

    public String getExpenditureFinancialDocumentNumber() {
        return this.expenditureFinancialDocumentNumber;
    }

    public void setExpenditureFinancialDocumentNumber(String expenditureFinancialDocumentNumber) {
        this.expenditureFinancialDocumentNumber = expenditureFinancialDocumentNumber;
    }

    public String getExpenditureFinancialDocumentTypeCode() {
        return this.expenditureFinancialDocumentTypeCode;
    }

    public void setExpenditureFinancialDocumentTypeCode(String expenditureFinancialDocumentTypeCode) {
        this.expenditureFinancialDocumentTypeCode = expenditureFinancialDocumentTypeCode;
    }

    public String getPostingPeriodCode() {
        return this.postingPeriodCode;
    }

    public void setPostingPeriodCode(String postingPeriodCode) {
        this.postingPeriodCode = postingPeriodCode;
    }

    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public String getRequisitionNumber() {
        return this.requisitionNumber;
    }

    public void setRequisitionNumber(String requisitionNumber) {
        this.requisitionNumber = requisitionNumber;
    }

    public AccountingPeriod getFinancialDocumentPostingPeriod() {
        return this.financialDocumentPostingPeriod;
    }

    public void setFinancialDocumentPostingPeriod(AccountingPeriod financialDocumentPostingPeriod) {
        this.financialDocumentPostingPeriod = financialDocumentPostingPeriod;
    }

    public DocumentType getExpenditureFinancialSystemDocumentType() {
        this.expenditureFinancialSystemDocumentType = ((DocumentTypeService)SpringContext.getBean(DocumentTypeService.class)).updateDocumentTypeIfNecessary(this.expenditureFinancialDocumentTypeCode, this.expenditureFinancialSystemDocumentType);
        return this.expenditureFinancialSystemDocumentType;
    }

    public OriginationCode getExpenditureFinancialSystemOrigination() {
        return this.expenditureFinancialSystemOrigination;
    }

    public void setExpenditureFinancialSystemOrigination(OriginationCode expenditureFinancialSystemOrigination) {
        this.expenditureFinancialSystemOrigination = expenditureFinancialSystemOrigination;
    }

    public Account getAccount() {
        return this.account;
    }

    @Deprecated
    public void setAccount(Account account) {
        this.account = account;
    }

    public KualiDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(KualiDecimal amount) {
        this.amount = amount;
    }

    public Map getValuesMap() {
        Map simpleValues = super.getValuesMap();
        simpleValues.put("expenditureFinancialSystemOriginationCode", this.getExpenditureFinancialSystemOriginationCode());
        simpleValues.put("expenditureFinancialDocumentPostedDate", this.getExpenditureFinancialDocumentPostedDate());
        return simpleValues;
    }
}

