/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.validation.impl;

import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.document.AssetPaymentDocument;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class AssetPaymentZeroAmountValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        AssetPaymentDocument assetPaymentDocument = (AssetPaymentDocument)event.getDocument();
        if (assetPaymentDocument.isCapitalAssetBuilderOriginIndicator()) {
            return true;
        }
        KualiDecimal amount = this.accountingLineForValidation.getAmount();
        if (ObjectUtils.isNull((Object)amount)) {
            GlobalVariables.getMessageMap().putError("amount", "error.blankAmount", new String[]{""});
            return false;
        }
        if (amount.isZero()) {
            GlobalVariables.getMessageMap().putError("amount", "error.zeroAmount", new String[]{"an accounting line"});
            return false;
        }
        return true;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLine) {
        this.accountingLineForValidation = accountingLine;
    }
}

