/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.report;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.sys.context.SpringContext;

public class DepreciationReport {
    private static final Logger LOG = LogManager.getLogger();
    private int pageNumber = 0;
    private int line = 0;
    private int linesPerPage = 28;
    private Document document;
    private PdfWriter writer;

    public void generateReport(List<String[]> reportLog, String errorMsg, String sDepreciationDate) {
        try {
            DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            LOG.debug("createReport() started");
            this.document = new Document();
            String destinationDirectory = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("reports.directory");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.US);
            String filename = destinationDirectory + File.separator + "cam" + File.separator + "CAMS_DEPRECIATION_REPORT_" + sdf.format(dateTimeService.getCurrentDate()) + ".PDF";
            Font headerFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)0);
            PageHelper helper = new PageHelper();
            helper.runDate = dateTimeService.getCurrentDate();
            helper.headerFont = headerFont;
            helper.title = "Asset Depreciation Report - Statistics";
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(filename));
            this.writer.setPageEvent((PdfPageEvent)helper);
            this.document.open();
            this.generateReportLogBody(reportLog);
            this.generateReportErrorLog(errorMsg);
        }
        catch (Exception e) {
            throw new RuntimeException("DepreciationReport.generateReport(List<String[]> reportLog, List<String> errorLog) - Error on report generation: " + e.getMessage());
        }
        finally {
            if (this.document != null && this.document.isOpen()) {
                this.document.close();
            }
        }
    }

    private void generateReportLogBody(List<String[]> reportLog) {
        try {
            Font font = FontFactory.getFont((String)"Helvetica", (float)9.0f, (int)0);
            int[] columnWidths = new int[]{40, 15};
            Table aTable = new Table(2, this.linesPerPage);
            int rowsWritten = 0;
            for (String[] columns : reportLog) {
                if (this.pageNumber == 0 || this.line >= this.linesPerPage) {
                    int elementsLeft;
                    if (this.pageNumber > 0) {
                        this.document.add((Element)aTable);
                    }
                    int rowsNeeded = (elementsLeft = reportLog.size() - rowsWritten) >= this.linesPerPage ? this.linesPerPage : elementsLeft;
                    this.document.newPage();
                    this.generateColumnHeaders();
                    aTable = new Table(2, rowsNeeded);
                    aTable.setAutoFillEmptyCells(true);
                    aTable.setPadding(3.0f);
                    aTable.setWidths(columnWidths);
                    aTable.setWidth(100.0f);
                    aTable.setBorder(0);
                    this.line = 0;
                    ++this.pageNumber;
                }
                ++rowsWritten;
                Cell cell = new Cell((Element)new Phrase(columns[0], font));
                cell.setHorizontalAlignment(0);
                cell.setVerticalAlignment(5);
                aTable.addCell(cell);
                cell = new Cell((Element)new Phrase(columns[1], font));
                cell.setHorizontalAlignment(2);
                cell.setVerticalAlignment(5);
                aTable.addCell(cell);
                ++this.line;
            }
            this.document.add((Element)aTable);
        }
        catch (DocumentException de) {
            throw new RuntimeException("DepreciationReport.generateReportLogBody(List<String[]> reportLog) - error: " + de.getMessage());
        }
    }

    private void generateReportErrorLog(String errorMsg) {
        try {
            Font font = FontFactory.getFont((String)"Helvetica", (float)9.0f, (int)0);
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                this.generateErrorColumnHeaders();
                Paragraph p1 = new Paragraph(new Chunk(errorMsg, font));
                this.document.add((Element)p1);
                ++this.line;
            }
        }
        catch (Exception de) {
            throw new RuntimeException("DepreciationReport.generateReportErrorLog(List<String> reportLog) - Report Generation Failed: " + de.getMessage());
        }
    }

    private void generateErrorColumnHeaders() {
        try {
            int[] headerWidths = new int[]{60};
            Table aTable = new Table(1, 1);
            aTable.setAutoFillEmptyCells(true);
            aTable.setPadding(3.0f);
            aTable.setWidths(headerWidths);
            aTable.setWidth(100.0f);
            Font font = FontFactory.getFont((String)"Helvetica", (float)9.0f, (int)0);
            Cell cell = new Cell((Element)new Phrase("Error(s)", font));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setGrayFill(0.9f);
            aTable.addCell(cell);
            this.document.add((Element)aTable);
        }
        catch (Exception e) {
            throw new RuntimeException("DepreciationReport.generateErrorColumnHeaders() - Error: " + e.getMessage());
        }
    }

    private void generateColumnHeaders() {
        try {
            int[] headerWidths = new int[]{40, 15};
            Table aTable = new Table(2, 1);
            aTable.setAutoFillEmptyCells(true);
            aTable.setPadding(3.0f);
            aTable.setWidths(headerWidths);
            aTable.setWidth(100.0f);
            Font font = FontFactory.getFont((String)"Helvetica", (float)9.0f, (int)0);
            Cell cell = new Cell((Element)new Phrase(((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("message.batch.report.depreciation.heading.description"), font));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setGrayFill(0.9f);
            aTable.addCell(cell);
            cell = new Cell((Element)new Phrase(((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("message.batch.report.depreciation.heading.figures"), font));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            cell.setGrayFill(0.9f);
            aTable.addCell(cell);
            this.document.add((Element)aTable);
        }
        catch (Exception e) {
            throw new RuntimeException("DepreciationReport.generateColumnHeaders() - Error: " + e.getMessage());
        }
    }

    class PageHelper
    extends PdfPageEventHelper {
        public Date runDate;
        public Font headerFont;
        public String title;

        PageHelper() {
        }

        public void onEndPage(PdfWriter writer, Document document) {
            try {
                Font titleFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)0);
                Font font = FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)0);
                Rectangle page = document.getPageSize();
                PdfPTable head = new PdfPTable(3);
                int[] widths = new int[]{15, 70, 15};
                head.setWidths(widths);
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.US);
                PdfPCell cell = new PdfPCell(new Phrase(sdf.format(this.runDate), font));
                cell.setBorder(0);
                head.addCell(cell);
                cell = new PdfPCell(new Phrase(this.title, titleFont));
                cell.setBorder(0);
                cell.setHorizontalAlignment(1);
                head.addCell(cell);
                cell = new PdfPCell(new Phrase("Page: " + writer.getPageNumber(), font));
                cell.setBorder(0);
                cell.setHorizontalAlignment(2);
                head.addCell(cell);
                head.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
                head.writeSelectedRows(0, -1, document.leftMargin(), page.getHeight() - document.topMargin() + head.getTotalHeight(), writer.getDirectContent());
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
    }
}

