/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.module.cam.businessobject.GlAccountLineGroup;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class GlAccountLineGroupTest {
    GlAccountLineGroupTest() {
    }

    @Test
    void combineEntry() {
        GlAccountLineGroup cut = new GlAccountLineGroup(this.createEntry("D", new KualiDecimal(100)));
        Entry second = this.createEntry("D", new KualiDecimal(200));
        Assertions.assertEquals((Object)cut, (Object)new GlAccountLineGroup(second));
        cut.combineEntry(second);
        Assertions.assertEquals((Object)"D", (Object)cut.getTargetEntry().getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)new KualiDecimal(300), (Object)cut.getTargetEntry().getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)new KualiDecimal(300), (Object)cut.getAmount());
        Entry third = this.createEntry("C", new KualiDecimal(200));
        Assertions.assertEquals((Object)cut, (Object)new GlAccountLineGroup(third));
        cut.combineEntry(third);
        Assertions.assertEquals((Object)"D", (Object)cut.getTargetEntry().getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)new KualiDecimal(100), (Object)cut.getTargetEntry().getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100), (Object)cut.getAmount());
        Entry fourth = this.createEntry("C", new KualiDecimal(200));
        Assertions.assertEquals((Object)cut, (Object)new GlAccountLineGroup(fourth));
        cut.combineEntry(fourth);
        Assertions.assertEquals((Object)"C", (Object)cut.getTargetEntry().getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)new KualiDecimal(100), (Object)cut.getTargetEntry().getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)new KualiDecimal(-100), (Object)cut.getAmount());
        Entry fifth = this.createEntry("D", new KualiDecimal(200));
        Assertions.assertEquals((Object)cut, (Object)new GlAccountLineGroup(fifth));
        cut.combineEntry(fifth);
        Assertions.assertEquals((Object)"D", (Object)cut.getTargetEntry().getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)new KualiDecimal(100), (Object)cut.getTargetEntry().getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)new KualiDecimal(100), (Object)cut.getAmount());
        List sourceEntries = cut.getSourceEntries();
        Assertions.assertEquals((int)5, (int)sourceEntries.size());
        KualiDecimal srcAmount = KualiDecimal.ZERO;
        for (Entry entry : sourceEntries) {
            if ("C".equals(entry.getTransactionDebitCreditCode())) {
                srcAmount = (KualiDecimal)srcAmount.add((AbstractKualiDecimal)((KualiDecimal)entry.getTransactionLedgerEntryAmount().negated()));
                continue;
            }
            srcAmount = (KualiDecimal)srcAmount.add((AbstractKualiDecimal)entry.getTransactionLedgerEntryAmount());
        }
        Assertions.assertEquals((Object)new KualiDecimal(100), (Object)srcAmount);
        Assertions.assertEquals((Object)cut.getAmount(), (Object)srcAmount);
    }

    private Entry createEntry(String dbtCrdtCode, KualiDecimal amount) {
        Entry entry = new Entry();
        entry.setUniversityFiscalYear(Integer.valueOf(2008));
        entry.setChartOfAccountsCode("BL");
        entry.setAccountNumber("BL002323");
        entry.setSubAccountNumber("--");
        entry.setFinancialObjectCode("7000");
        entry.setFinancialSubObjectCode(null);
        entry.setUniversityFiscalPeriodCode("01");
        entry.setDocumentNumber("1001");
        entry.setReferenceFinancialDocumentNumber(null);
        entry.setTransactionDebitCreditCode(dbtCrdtCode);
        entry.setTransactionLedgerEntryAmount(amount);
        return entry;
    }
}

