/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document.service;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetLocation;
import org.kuali.kfs.module.cam.document.service.EquipmentLoanOrReturnService;
import org.kuali.kfs.module.cam.document.service.impl.EquipmentLoanOrReturnServiceImpl;

class EquipmentLoanOrReturnServiceTest {
    private EquipmentLoanOrReturnService cut;
    private Asset asset;

    EquipmentLoanOrReturnServiceTest() {
    }

    @BeforeEach
    public void setUp() {
        this.cut = new EquipmentLoanOrReturnServiceImpl();
        Date date = Date.valueOf(LocalDate.now());
        this.asset = new Asset(){

            public void refreshReferenceObject(String referenceObjectName) {
                ArrayList<AssetLocation> assetLocations = new ArrayList<AssetLocation>();
                AssetLocation loc1 = new AssetLocation();
                loc1.setAssetLocationTypeCode("B");
                assetLocations.add(loc1);
                AssetLocation loc2 = new AssetLocation();
                loc2.setAssetLocationTypeCode("BS");
                assetLocations.add(loc2);
                this.setAssetLocations(assetLocations);
            }
        };
        this.asset.setExpectedReturnDate(date);
    }

    @Test
    void setEquipmentLoanInfo() {
        this.cut.setEquipmentLoanInfo(this.asset);
        Assertions.assertNotNull((Object)this.asset.getBorrowerLocation());
        Assertions.assertNotNull((Object)this.asset.getBorrowerStorageLocation());
    }

    @Test
    void setEquipmentLoanInfo_NoLoan() {
        this.asset.setExpectedReturnDate(null);
        this.cut.setEquipmentLoanInfo(this.asset);
        Assertions.assertNull((Object)this.asset.getBorrowerLocation());
        Assertions.assertNull((Object)this.asset.getBorrowerStorageLocation());
    }
}

