/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.fixture;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.cam.batch.AssetPaymentInfo;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetObjectCode;
import org.kuali.kfs.module.cam.businessobject.AssetPayment;
import org.kuali.kfs.module.cam.fixture.CamsFixture;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.businessobject.UniversityDate;

public enum AssetDepreciationServiceFixture {
    DATA;

    private static Properties properties;
    static String TEST_RECORD;
    static String ASSET;
    static String ASSET_PAYMENT;
    static String DEPRECIATION_DATE;
    static String FIELD_NAMES;
    static String NUM_OF_REC;
    static String DELIMINATOR;
    static String RESULT;

    private <T> List<T> getObjects(Class<T> clazz, String prefix) {
        Integer numOfRecords = new Integer(properties.getProperty(prefix + "." + NUM_OF_REC));
        ArrayList<T> results = new ArrayList<T>();
        String deliminator = properties.getProperty(DELIMINATOR);
        String fieldNames = properties.getProperty(prefix + "." + FIELD_NAMES);
        for (int i = 1; i <= numOfRecords; ++i) {
            String propertyKey = prefix + "." + TEST_RECORD + i;
            T item = CamsFixture.DATA_POPULATOR.buildTestDataObject(clazz, properties, propertyKey, fieldNames, deliminator);
            results.add(item);
        }
        return results;
    }

    public List<Asset> getAssets() {
        return this.getObjects(Asset.class, ASSET);
    }

    public List<AssetPayment> getAssetPaymentsFromPropertiesFile() {
        return this.getObjects(AssetPayment.class, ASSET_PAYMENT);
    }

    public List<AssetPaymentInfo> getResultsFromPropertiesFile() {
        return this.getObjects(AssetPaymentInfo.class, RESULT);
    }

    public String getDepreciationDateString() {
        return properties.getProperty(DEPRECIATION_DATE);
    }

    public Date getDepreciationDate() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        return dateFormat.parse(this.getDepreciationDateString());
    }

    public SystemOptions getSystemOptions() {
        SystemOptions result = new SystemOptions();
        result.setUniversityFiscalYearStartMo("1");
        return result;
    }

    public UniversityDate getUniversityDate() {
        UniversityDate result = new UniversityDate();
        result.setUniversityFiscalYear(Integer.valueOf(2010));
        result.setUniversityFiscalAccountingPeriod("1");
        return result;
    }

    public List<AssetPaymentInfo> getAssetPaymentInfo() {
        List<Asset> assets = this.getAssets();
        List<AssetPayment> assetPayments = this.getAssetPaymentsFromPropertiesFile();
        return this.getAssetPaymentInfo(assets, assetPayments);
    }

    private List<AssetPaymentInfo> getAssetPaymentInfo(List<Asset> assets, List<AssetPayment> assetPayments) {
        ArrayList<AssetPaymentInfo> result = new ArrayList<AssetPaymentInfo>();
        for (AssetPayment payment : assetPayments) {
            AssetPaymentInfo info = new AssetPaymentInfo();
            info.setAccumulatedPrimaryDepreciationAmount(payment.getAccumulatedPrimaryDepreciationAmount());
            info.setCapitalAssetNumber(payment.getCapitalAssetNumber());
            info.setChartOfAccountsCode(payment.getChartOfAccountsCode());
            info.setFinancialObjectCode(payment.getFinancialObjectCode());
            info.setFinancialSubObjectCode(payment.getFinancialSubObjectCode());
            info.setPaymentSequenceNumber(payment.getPaymentSequenceNumber());
            info.setPrimaryDepreciationBaseAmount(payment.getPrimaryDepreciationBaseAmount());
            info.setProjectCode(payment.getProjectCode());
            info.setSubAccountNumber(payment.getSubAccountNumber());
            for (Asset asset : assets) {
                if (!asset.getCapitalAssetNumber().equals(payment.getCapitalAssetNumber())) continue;
                info.setSalvageAmount(asset.getSalvageAmount());
                info.setPrimaryDepreciationMethodCode(asset.getPrimaryDepreciationMethodCode());
                info.setDepreciationDate(asset.getDepreciationDate());
                switch (asset.getCapitalAssetTypeCode()) {
                    case "304": {
                        info.setDepreciableLifeLimit(Integer.valueOf(3));
                        break;
                    }
                    case "90001": {
                        info.setDepreciableLifeLimit(Integer.valueOf(1));
                        break;
                    }
                }
            }
            switch (payment.getFinancialObjectCode()) {
                case "7000": {
                    info.setFinancialObjectSubTypeCode("CM");
                    break;
                }
                case "7030": {
                    info.setFinancialObjectSubTypeCode("CF");
                    break;
                }
            }
            info.setOrganizationPlantAccountNumber("9520004");
            info.setOrganizationPlantChartCode("BL");
            info.setCampusPlantAccountNumber("9520000");
            info.setCampusPlantChartCode("BL");
            info.setFinancialObjectTypeCode("EE");
            info.setAccumulatedRoundingErrorInMillicents(payment.getAccumulatedRoundingErrorInMillicents());
            result.add(info);
        }
        return result;
    }

    public Map<Long, KualiDecimal> getPrimaryDepreciationBaseAmountForSV() {
        List<Asset> assets = this.getAssets();
        List<AssetPayment> assetPayments = this.getAssetPaymentsFromPropertiesFile();
        return this.getPrimaryDepreciationBaseAmountForSV(assets, assetPayments);
    }

    private Map<Long, KualiDecimal> getPrimaryDepreciationBaseAmountForSV(List<Asset> assets, List<AssetPayment> assetPayments) {
        HashMap<Long, KualiDecimal> result = new HashMap<Long, KualiDecimal>();
        for (Asset asset : assets) {
            if (!asset.getPrimaryDepreciationMethodCode().equals("SV")) continue;
            result.put(asset.getCapitalAssetNumber(), KualiDecimal.ZERO);
        }
        for (AssetPayment payment : assetPayments) {
            KualiDecimal total = (KualiDecimal)result.get(payment.getCapitalAssetNumber());
            if (total == null) continue;
            result.put(payment.getCapitalAssetNumber(), (KualiDecimal)total.add((AbstractKualiDecimal)payment.getPrimaryDepreciationBaseAmount()));
        }
        return result;
    }

    public List<AssetObjectCode> getAssetObjectCodes() {
        ArrayList<AssetObjectCode> result = new ArrayList<AssetObjectCode>();
        AssetObjectCode assetObjectCode = new AssetObjectCode();
        assetObjectCode.setChartOfAccountsCode("BL");
        assetObjectCode.setUniversityFiscalYear(Integer.valueOf(2010));
        assetObjectCode.setFinancialObjectSubTypeCode("CM");
        assetObjectCode.setCapitalizationFinancialObjectCode("8610");
        assetObjectCode.setAccumulatedDepreciationFinancialObjectCode("8910");
        assetObjectCode.setDepreciationExpenseFinancialObjectCode("5115");
        assetObjectCode.setActive(true);
        assetObjectCode.setObjectCode(new ArrayList());
        ObjectCode objectCode = new ObjectCode();
        objectCode.setChartOfAccountsCode("BL");
        objectCode.setFinancialObjectCode("7000");
        assetObjectCode.getObjectCode().add(objectCode);
        result.add(assetObjectCode);
        assetObjectCode = new AssetObjectCode();
        assetObjectCode.setChartOfAccountsCode("BL");
        assetObjectCode.setUniversityFiscalYear(Integer.valueOf(2010));
        assetObjectCode.setFinancialObjectSubTypeCode("CF");
        assetObjectCode.setCapitalizationFinancialObjectCode("8611");
        assetObjectCode.setAccumulatedDepreciationFinancialObjectCode("8910");
        assetObjectCode.setDepreciationExpenseFinancialObjectCode("5115");
        assetObjectCode.setActive(true);
        assetObjectCode.setObjectCode(new ArrayList());
        objectCode = new ObjectCode();
        objectCode.setChartOfAccountsCode("BL");
        objectCode.setFinancialObjectCode("7030");
        assetObjectCode.getObjectCode().add(objectCode);
        result.add(assetObjectCode);
        return result;
    }

    static {
        String propertiesFileName = "org/kuali/kfs/module/cam/document/service/depreciation_service.properties";
        properties = new Properties();
        try {
            properties.load(ClassLoader.getSystemResourceAsStream(propertiesFileName));
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        TEST_RECORD = "testRecord";
        ASSET = "asset";
        ASSET_PAYMENT = "assetPayment";
        DEPRECIATION_DATE = "depreciationDate";
        FIELD_NAMES = "fieldNames";
        NUM_OF_REC = "numOfRecords";
        DELIMINATOR = "deliminator";
        RESULT = "result";
    }
}

