/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.batch;

import java.util.Collection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.module.cam.batch.service.BatchExtractService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.sys.batch.AbstractStep;

public class PreAssetTaggingStep
extends AbstractStep {
    private static final Logger LOG = LogManager.getLogger();
    private BatchExtractService batchExtractService;
    private DateTimeService dateTimeService;

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        try {
            java.sql.Date currentSqlDate = this.dateTimeService.getCurrentSqlDate();
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DateTimeService)this.dateTimeService).getCurrentTimestamp();
            LOG.debug("Pre Asset Tagging extract started at {}", supplierArray);
            Collection<PurchaseOrderAccount> preTaggablePOAccounts = this.batchExtractService.findPreTaggablePOAccounts();
            if (preTaggablePOAccounts != null && !preTaggablePOAccounts.isEmpty()) {
                this.batchExtractService.savePreTagLines(preTaggablePOAccounts);
            }
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = () -> ((DateTimeService)this.dateTimeService).getCurrentTimestamp();
            LOG.debug("Pre Asset Tagging extract finished at {}", supplierArray2);
            this.batchExtractService.updateLastExtractDate(currentSqlDate);
        }
        catch (Throwable e) {
            LOG.error("Unexpected error occurred during Pre Asset Tagging extract", e);
            throw new RuntimeException(e);
        }
        return true;
    }

    public BatchExtractService getBatchExtractService() {
        return this.batchExtractService;
    }

    public void setBatchExtractService(BatchExtractService batchExtractService) {
        this.batchExtractService = batchExtractService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

