/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cam.document;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.api.identity.IdentityService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.cam.businessobject.Asset;
import org.kuali.kfs.module.cam.businessobject.AssetFabrication;
import org.kuali.kfs.module.cam.businessobject.defaultvalue.NextAssetNumberFinder;
import org.kuali.kfs.module.cam.document.service.AssetLocationService;
import org.kuali.kfs.module.cam.document.service.AssetService;
import org.kuali.kfs.module.cam.document.service.EquipmentLoanOrReturnService;
import org.kuali.kfs.module.cam.document.service.PaymentSummaryService;
import org.kuali.kfs.module.cam.document.service.RetirementInfoService;
import org.kuali.kfs.module.cam.service.AssetLockService;
import org.kuali.kfs.module.cam.util.MaintainableWorkflowUtils;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.springframework.util.AutoPopulatingList;

public class AssetMaintainableImpl
extends FinancialSystemMaintainable {
    private static final Logger LOG = LogManager.getLogger();
    private Asset asset;
    private Asset copyAsset;
    private boolean fabricationOn;
    protected static volatile IdentityService identityService;
    protected static volatile DocumentService documentService;
    protected static volatile AssetService assetService;
    private static final Map<String, String> FINANCIAL_DOC_NAME_MAP;

    public List<MaintenanceLock> generateMaintenanceLocks() {
        return new ArrayList<MaintenanceLock>();
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        super.doRouteStatusChange(documentHeader);
        WorkflowDocument workflowDoc = documentHeader.getWorkflowDocument();
        if (this.getBusinessObject() instanceof Asset && !(this.getBusinessObject() instanceof AssetFabrication) && (workflowDoc.isCanceled() || workflowDoc.isDisapproved() || workflowDoc.isProcessed() || workflowDoc.isFinal())) {
            this.getCapitalAssetManagementModuleService().deleteAssetLocks(this.getDocumentNumber(), null);
        }
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return (CapitalAssetManagementModuleService)SpringContext.getBean(CapitalAssetManagementModuleService.class);
    }

    public void processAfterEdit(MaintenanceDocument document, Map parameters) {
        this.initializeAttributes(document);
        this.getAssetLocationService().setOffCampusLocation(this.copyAsset);
        this.getAssetLocationService().setOffCampusLocation(this.asset);
        PaymentSummaryService paymentSummaryService = (PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class);
        paymentSummaryService.calculateAndSetPaymentSummary(this.copyAsset);
        paymentSummaryService.calculateAndSetPaymentSummary(this.asset);
        AssetMaintainableImpl.getAssetService().setSeparateHistory(this.copyAsset);
        AssetMaintainableImpl.getAssetService().setSeparateHistory(this.asset);
        RetirementInfoService retirementInfoService = (RetirementInfoService)SpringContext.getBean(RetirementInfoService.class);
        retirementInfoService.setRetirementInfo(this.copyAsset);
        retirementInfoService.setRetirementInfo(this.asset);
        retirementInfoService.setMergeHistory(this.copyAsset);
        retirementInfoService.setMergeHistory(this.asset);
        EquipmentLoanOrReturnService equipmentLoanOrReturnService = (EquipmentLoanOrReturnService)SpringContext.getBean(EquipmentLoanOrReturnService.class);
        equipmentLoanOrReturnService.setEquipmentLoanInfo(this.copyAsset);
        equipmentLoanOrReturnService.setEquipmentLoanInfo(this.asset);
        super.processAfterEdit(document, parameters);
    }

    public List<Section> getCoreSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getCoreSections(document, oldMaintainable);
        Asset asset = (Asset)this.getBusinessObject();
        if (asset.getAssetPayments().size() == 0) {
            for (Section section : sections) {
                if (!"paymentInformation".equals(section.getSectionId())) continue;
                section.setSectionTitle(section.getSectionTitle() + "- No payment exists for Capital Asset: " + asset.getCapitalAssetNumber());
            }
        }
        return sections;
    }

    private void initializeAttributes(MaintenanceDocument document) {
        if (this.asset == null) {
            this.asset = (Asset)document.getNewMaintainableObject().getBusinessObject();
            this.asset.setTagged();
        }
        if (this.copyAsset == null) {
            this.copyAsset = (Asset)document.getOldMaintainableObject().getBusinessObject();
        }
        this.setFabricationOn(document.getNewMaintainableObject().getBusinessObject() instanceof AssetFabrication);
    }

    public void processAfterRetrieve() {
        if (this.getBusinessObject() instanceof Asset && MaintainableWorkflowUtils.isDocumentSavedOrEnroute(this.getDocumentNumber())) {
            Asset asset = (Asset)this.getBusinessObject();
            asset.refreshReferenceObject("assetPayments");
            PaymentSummaryService paymentSummaryService = (PaymentSummaryService)SpringContext.getBean(PaymentSummaryService.class);
            paymentSummaryService.calculateAndSetPaymentSummary(asset);
        }
    }

    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> parameters) {
        String customAction = this.findCustomAction(parameters);
        if (StringUtils.equals((CharSequence)"lastInventoryDateUpdateButton", (CharSequence)customAction)) {
            this.processLastInventoryDateUpdate(document);
        }
        this.deleteObsoleteNotes(document);
        super.processAfterPost(document, parameters);
    }

    private String findCustomAction(Map<String, String[]> parameters) {
        String customAction = null;
        String[] customActions = parameters.get("customAction");
        if (customActions != null) {
            customAction = customActions[0];
        }
        return customAction;
    }

    private void processLastInventoryDateUpdate(MaintenanceDocument document) {
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDoc != null && workflowDoc.isInitiated()) {
            Asset oldAsset = (Asset)document.getOldMaintainableObject().getBusinessObject();
            Asset newAsset = (Asset)document.getNewMaintainableObject().getBusinessObject();
            if (AssetMaintainableImpl.getAssetService().hasAssetLocationChanged(oldAsset, newAsset)) {
                GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject.");
                GlobalVariables.getMessageMap().putWarning("campusCode", "warning.location.update.unnecessary", new String[]{newAsset.getCapitalAssetNumber().toString()});
                GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.");
            } else {
                String noteText = this.buildNoteText();
                Note lastInventoryDateUpdatedNote = AssetMaintainableImpl.getDocumentService().createNoteFromDocument((Document)document, noteText);
                if (this.shouldAddNote(document, noteText)) {
                    this.clearObsoleteWarningMessage();
                    this.asset.setLastInventoryDate(new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime()));
                    lastInventoryDateUpdatedNote.setAuthorUniversalIdentifier(this.getIdentityService().getPrincipalByPrincipalName("kfs").getPrincipalId());
                    document.addNote(lastInventoryDateUpdatedNote);
                    AssetMaintainableImpl.getDocumentService().saveDocumentNotes((Document)document);
                }
            }
        }
    }

    private String buildNoteText() {
        String userPrincipalName = GlobalVariables.getUserSession().getUserToLog();
        String noteTextPattern = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("note.last.inventory.date.updated");
        return MessageFormat.format(noteTextPattern, userPrincipalName, ((Asset)this.businessObject).getCapitalAssetNumber().toString());
    }

    private boolean shouldAddNote(MaintenanceDocument document, String noteText) {
        boolean shouldAddNote = true;
        for (Note note : document.getNotes()) {
            if (!note.getNoteText().equals(noteText)) continue;
            shouldAddNote = false;
            break;
        }
        return shouldAddNote;
    }

    private void clearObsoleteWarningMessage() {
        Map warningMessages = GlobalVariables.getMessageMap().getWarningMessages();
        if (ObjectUtils.isNotNull((Object)warningMessages) && !warningMessages.isEmpty()) {
            warningMessages.entrySet().removeIf(nextWarningMessage -> ((ErrorMessage)((AutoPopulatingList)nextWarningMessage.getValue()).get(0)).getErrorKey().equals("warning.location.update.unnecessary"));
        }
    }

    private void deleteObsoleteNotes(MaintenanceDocument document) {
        Asset oldAsset = (Asset)document.getOldMaintainableObject().getBusinessObject();
        Asset newAsset = (Asset)document.getNewMaintainableObject().getBusinessObject();
        if (AssetMaintainableImpl.getAssetService().hasAssetLocationChanged(oldAsset, newAsset)) {
            if (!newAsset.getLastInventoryDate().equals(oldAsset.getLastInventoryDate())) {
                newAsset.setLastInventoryDate(oldAsset.getLastInventoryDate());
            }
            String noteText = this.buildNoteText();
            Iterator noteIterator = document.getNotes().iterator();
            while (noteIterator.hasNext()) {
                Note note = (Note)noteIterator.next();
                if (!note.getNoteText().equals(noteText)) continue;
                noteIterator.remove();
                AssetMaintainableImpl.getDocumentService().saveDocumentNotes((Document)document);
            }
        }
    }

    public void saveBusinessObject() {
        Asset asset = (Asset)this.businessObject;
        if (asset.getCapitalAssetNumber() == null) {
            asset.setCapitalAssetNumber(NextAssetNumberFinder.getLongValue());
        }
        asset.refreshReferenceObject("assetLocations");
        if (this.getAssetLocationService().isOffCampusLocationExists(asset.getOffCampusLocation())) {
            this.getAssetLocationService().updateOffCampusLocation(asset);
        }
        super.saveBusinessObject();
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterNew(document, parameters);
        this.initializeAttributes(document);
        if (this.asset.getCreateDate() == null) {
            this.asset.setCreateDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate());
            this.asset.setAcquisitionTypeCode("C");
            this.asset.setVendorName("CONSTRUCTED");
            this.asset.setInventoryStatusCode("U");
            this.asset.setPrimaryDepreciationMethodCode("SL");
            this.asset.setCapitalAssetTypeCode(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(AssetFabrication.class, "ASSET_TYPE"));
            this.asset.setManufacturerName(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(AssetFabrication.class, "MANUFACTURER"));
            AssetMaintainableImpl.getAssetService().setFiscalPeriod(this.asset);
        }
        this.getAssetLocationService().setOffCampusLocation(this.asset);
    }

    protected boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if ("RequiresOrganizationInactiveReview".equals(nodeName)) {
            return this.isRequiresOrganizationInactiveRouteNode();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    protected boolean isRequiresOrganizationInactiveRouteNode() {
        Asset asset = (Asset)this.getBusinessObject();
        asset.getOrganizationOwnerAccount().refreshReferenceObject("organization");
        return !asset.getOrganizationOwnerAccount().getOrganization().isActive();
    }

    public void setGenerateDefaultValues(String docTypeName) {
    }

    public List<String> getFpLinks() {
        Asset asset = (Asset)this.getBusinessObject();
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        assetNumbers.add(asset.getCapitalAssetNumber());
        return ((AssetLockService)SpringContext.getBean(AssetLockService.class)).getAssetLockingDocuments(assetNumbers, "AFPINQ", "");
    }

    public List<String> getPreqLinks() {
        Asset asset = (Asset)this.getBusinessObject();
        ArrayList<Long> assetNumbers = new ArrayList<Long>();
        assetNumbers.add(asset.getCapitalAssetNumber());
        return ((AssetLockService)SpringContext.getBean(AssetLockService.class)).getAssetLockingDocuments(assetNumbers, "APREQINQ", "");
    }

    public List<String> getFpLinkedDocumentInfo() {
        ArrayList<String> documentInfo = new ArrayList<String>();
        for (String aDocumentNumber : this.getFpLinks()) {
            String docTypeName = AssetMaintainableImpl.getDocumentService().getByDocumentHeaderId(aDocumentNumber).getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
            documentInfo.add(FINANCIAL_DOC_NAME_MAP.get(docTypeName) + "-" + aDocumentNumber);
        }
        return documentInfo;
    }

    public boolean isFabricationOn() {
        return this.fabricationOn;
    }

    public void setFabricationOn(boolean fabricationOn) {
        this.fabricationOn = fabricationOn;
    }

    protected static AssetService getAssetService() {
        if (assetService == null) {
            assetService = (AssetService)SpringContext.getBean(AssetService.class);
        }
        return assetService;
    }

    private AssetLocationService getAssetLocationService() {
        return (AssetLocationService)SpringContext.getBean(AssetLocationService.class);
    }

    protected static DocumentService getDocumentService() {
        if (documentService == null) {
            documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return documentService;
    }

    public IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = (IdentityService)SpringContext.getBean(IdentityService.class);
        }
        return identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        AssetMaintainableImpl.identityService = identityService;
    }

    static {
        FINANCIAL_DOC_NAME_MAP = new HashMap<String, String>();
        FINANCIAL_DOC_NAME_MAP.put("CR", "Cash Receipt");
        FINANCIAL_DOC_NAME_MAP.put("DI", "Distribution of Income and Expense");
        FINANCIAL_DOC_NAME_MAP.put("GEC", "General Error Correction");
        FINANCIAL_DOC_NAME_MAP.put("IB", "Internal Billing");
        FINANCIAL_DOC_NAME_MAP.put("SB", "Service Billing");
        FINANCIAL_DOC_NAME_MAP.put("YEDI", "Year End Distribution of Income and Expense");
        FINANCIAL_DOC_NAME_MAP.put("YEGE", "Year End General Error Correction");
        FINANCIAL_DOC_NAME_MAP.put("PCDO", "Procurement Card");
    }
}

